/* The parallel IO version */

#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include "meshc.h"

#ifdef FORTRANUNDERSCORE
#define dump_float dump_float_
#define restart_io restart_io_
#endif

#ifdef HAS_CAP
#define dump_float DUMP_FLOAT
#define restart_io RESTART_IO
#endif

#ifndef HAS_IO

void dump_float(sz,filename,step_par,out_par,
		ux,uy,uz,press,temp,rho,scalar,aux)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *scalar;
float *aux;
{
   printf("Not doing dump_float for now\n");
}

#else

#include "tools.h"
#include "comm/comm.h"
#include "comm/io/pio.h"

#include <unistd.h>
#include "uni_def.h"

/*..................................................................*/
void dump_float(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,scalar,aux)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *scalar;
float *aux;
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy;
	int nstep, ndim = 3;
	char prefix[80];
	char out[100];
	PIFILE *fp;
        PIArrayPart zz[3];
        float par[6]; int gdim[3];

        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;

/*	printf("In PIO %d %d %d %d %d %d\n",bx,ex,by,ey,bz,ez); */

/*.....................................................................*/
        /* Create the file name and open the file
         * Here we do it only at the beginning, and
         * then we hope that the file will accumulate
         * sequentially onto the first file
         */
#ifdef HAS_UNITREE
        has_unitree = PIOAddUnitree();
#endif

	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/

        nstep = step_par[0];

#ifdef HAS_UNITREE
        /*--Form the Unitree extension--*/
        sprintf(out, "%s%s.%04d", UNITREE_DIR, prefix, nstep);
#else        
        sprintf(out, "%s%s.%04d", PIOFS_DIR,prefix, nstep); /**/
#endif

        set_zz(zz,sz);        

        PIgsync(PIAllProcs);
        PIFSetWritersBlock(); /**/
        fp = PIFopen(out,PIAllProcs,O_RDWR|O_CREAT,PIO_AS_SEQUENTIAL,-1);
        PIFCacheEnable( fp, wsize, rsize ); /**/

/*......................................................................*/
        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[0];        /* nstep */
        par[4] = step_par[1];        /* time */
        par[5] = step_par[9];        /* dt */

        PIWriteCommon( fp, NULL, sizeof(float), par, 6, MSG_FLT );

/*......................................................................*/
#ifdef FORCE_SINGLE_OUTPUT
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(rho+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(ux+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uy+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uz+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(temp+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(press+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
#ifdef DO_PASSIVE_SCALAR
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(scalar+i) );
    PIWriteDistributedArray(fp,NULL,sizeof(float), zz, 3, aux, MSG_FLT);
#endif    
#else
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, rho, MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, ux , MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, uy , MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, uz , MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, temp, MSG_DBL);
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, press, MSG_DBL);
#ifdef DO_PASSIVE_SCALAR    
    PIWriteDistributedArray(fp,NULL,sizeof(array), zz, 3, scalar, MSG_DBL);
#endif
#endif
/*......................................................................*/

    PIFflush(fp);
    PIFclose(fp);
    PIgsync(PIAllProcs);

}
 
/*......................................................................*/

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/ 
/*.... ....................................................*/
/* Set up the array descriptor for the IO routines */
/* This is clumsy, but you do it only once... */
set_zz(zz,sz)
PIArrayPart zz[3];
ALArrayPart sz[3];
{
        int k;
        for(k=0; k<3; k++){ 
	   zz[k].mdim  = sz[k].mdim;
           zz[k].ndim  = sz[k].end+sz[k].eg-sz[k].start+sz[k].sg+1;
           zz[k].start = sz[k].sg;
           zz[k].end   = sz[k].end+sz[k].eg-sz[k].start;
           zz[k].gstart= sz[k].start;
           zz[k].gend  = sz[k].end;
        }
}
/*..................................................................*/

#endif
