/* The parallel MPI-IO version */

#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>

#include "../meshc.h"

#ifdef HAS_HASH
#define restart_io restart_io_
#endif
#ifdef HAS_CAP
#define restart_io RESTART_IO
#endif

/*.... This writes the restart file ....................................*/
/*..................................................................*/
void restart_io(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,scalar, aux,mode)
ALArrayPart *sz;
char *filename, *mode;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *scalar;
#ifdef FORCE_SINGLE_OUTPUT
float *aux;
#else
array *aux;
#endif
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy;
	int buflen, hd, count,nstep,ndim = 3;
	char prefix[80];
	char out[100];
        char rd = 'r', wr = 'w';
        char *vars[] = {"dens", "ux", "uy", "uz", "temp", "press", "param"};
        int nvars = 6;
        PIArrayPart zz[3];
        float par[6];
        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;
	double work;

        MPI_File fp;
        MPI_Status status;
        MPI_Comm comm3d = MPI_COMM_WORLD;
        MPI_Datatype filetype, buftype;
        MPI_Offset   OffsetDisp;
        int array_of_sizes[3], array_of_subsizes[3];
        int mynod, nprocs, array_of_starts[3], order, k;

        MPI_Comm_rank(MPI_COMM_WORLD, &mynod);
        MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;

/*.....................................................................*/

        /* Create the file name and open the file */

	sprintf(out, "%srestart", FILEPATH);

	/* printf("dump_restart %s\n", out); */

        MPI_File_open( comm3d, out, MPI_MODE_CREATE | MPI_MODE_RDWR,
                       MPI_INFO_NULL, &fp ); 

        set_zz_restart(zz,sz);        

#ifdef FORCE_SINGLE_OUTPUT
	OffsetDisp = 6*sizeof(float);
#else
	OffsetDisp = 6*sizeof(double);
#endif
	order = MPI_ORDER_FORTRAN;

	for (k=0; k<3; k++)
	{
	  array_of_sizes[k] = zz[k].mdim;
	  array_of_subsizes[k] = zz[k].end-zz[k].start+1;/* Has ghost points */
	  array_of_starts[k] = zz[k].gstart; /* MPIO assumes 0-indexing! */
	}

#ifdef FORCE_SINGLE_OUTPUT
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_FLOAT, &filetype);
#else
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_DOUBLE, &filetype);
#endif

	MPI_Type_commit(&filetype);

	/* Now build the memory-subarray describing the actual array
	   within the ghost super-array. This affects only the memory layout, 
	   does not affect the filetype described above.
	   The filetype is used to describe the file distribution across 
	   procs whereas the memory-layout is within one proc. */

	for (k=0; k<3; k++)
	{
	  array_of_sizes[k] = zz[k].ndim; /* Size of ghost-super array which
					     contains the actual data 
					     subarray */
	  array_of_subsizes[k] = zz[k].end-zz[k].start+1;/* Has ghost points */
	  array_of_starts[k] = zz[k].start; /* MPIO assumes 0-indexing! */
	}

#ifdef FORCE_SINGLE_OUTPUT
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_FLOAT, 
				 &buftype);
#else
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_DOUBLE, 
				 &buftype);
#endif

	MPI_Type_commit(&buftype);


/*--------------- WRITE THE RESTART FILE ------------------*/
     if( strncasecmp(mode,&wr,1) == 0 ){

/*......................................................................*/
        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[0];   /* nstep */
        par[4] = step_par[1];   /* time */
        par[5] = step_par[9];   /* dt */

	if (mynod == 0) 
	{
#ifdef FORCE_SINGLE_OUTPUT
	  MPI_File_write(fp, par, 6, MPI_FLOAT, &status);
#else
	  MPI_File_write(fp, par, 6, MPI_DOUBLE, &status);
#endif
	}
#ifdef FORCE_SINGLE_OUTPUT
        MPI_File_set_view(fp, OffsetDisp, MPI_FLOAT, filetype, "native", 
			  MPI_INFO_NULL);
#else
        MPI_File_set_view(fp, OffsetDisp, MPI_DOUBLE, filetype, "native", 
			  MPI_INFO_NULL);
#endif

#ifdef FORCE_SINGLE_OUTPUT
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(rho+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(ux+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uy+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uz+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(temp+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(press+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

#else
      MPI_File_write_all(fp, rho, 1, buftype, &status);
      MPI_File_write_all(fp, ux, 1, buftype, &status);
      MPI_File_write_all(fp, uy, 1, buftype, &status);
      MPI_File_write_all(fp, uz, 1, buftype, &status);
      MPI_File_write_all(fp, temp, 1, buftype, &status);
      MPI_File_write_all(fp, press, 1, buftype, &status);
#endif

    }

/*--------------- READ THE RESTART FILE ------------------*/
    if( strncasecmp(mode,&rd,1) == 0 ){

	if (mynod == 0) 
	{
#ifdef FORCE_SINGLE_OUTPUT
	  MPI_File_read(fp, par, 6, MPI_FLOAT, &status);
#else
	  MPI_File_read(fp, par, 6, MPI_DOUBLE, &status);
#endif
	}

	/* Broadcast the values read by node 0 to other nodes */
#ifdef FORCE_SINGLE_OUTPUT
	MPI_Bcast(par, 6, MPI_FLOAT, 0, comm3d);
#else
	MPI_Bcast(par, 6, MPI_DOUBLE, 0, comm3d);
#endif


#ifdef FORCE_SINGLE_OUTPUT
        MPI_File_set_view(fp, OffsetDisp, MPI_FLOAT, filetype, "native", 
			  MPI_INFO_NULL);
#else
        MPI_File_set_view(fp, OffsetDisp, MPI_DOUBLE, filetype, "native", 
			  MPI_INFO_NULL);
#endif

/*
             if( sz->mdim != par[0] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NX in input: %d",sz->mdim,par[0]);
             }
             if( (sz+1)->mdim != par[1] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NY in input: %d",sz->mdim,par[0]);
             }
             if( (sz+2)->mdim != par[2] ){
                printf("Warning in RESTART.\n");
         printf("    NX declared: %d   NZ in input: %d",sz->mdim,par[0]);
             }
*/
             step_par[0] = par[3];        /* nstep */
             step_par[1] = par[4];        /* time */
             step_par[9] = par[5];        /* dt */
             out_par[0] = par[3];        /* nstep */
             out_par[1] = par[4];        /* time */


#ifdef FORCE_SINGLE_OUTPUT
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(rho+i) );
      MPI_File_read_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(ux+i) );
      MPI_File_read_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uy+i) );
      MPI_File_read_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uz+i) );
      MPI_File_read_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(temp+i) );
      MPI_File_read_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(press+i) );
      MPI_File_read_all(fp, aux, 1, buftype, &status);

#else
      MPI_File_read_all(fp, rho, 1, buftype, &status);
      MPI_File_read_all(fp, ux, 1, buftype, &status);
      MPI_File_read_all(fp, uy, 1, buftype, &status);
      MPI_File_read_all(fp, uz, 1, buftype, &status);
      MPI_File_read_all(fp, temp, 1, buftype, &status);
      MPI_File_read_all(fp, press, 1, buftype, &status);
#endif

    }

    MPI_File_close(&fp);
    MPI_Type_free(&filetype);
    MPI_Type_free(&buftype);
}



/*.........................................................*/
/* Set up the array descriptor for the IO routines */
/* This is clumsy, but you do it only once... */
set_zz_restart(zz,sz)
PIArrayPart zz[3];
ALArrayPart sz[3];
{
        int k;
        for(k=0; k<3; k++){ 
	   zz[k].mdim  = sz[k].mdim;
           zz[k].ndim  = sz[k].end+sz[k].eg-sz[k].start+sz[k].sg+1;
           zz[k].start = sz[k].sg;
           zz[k].end   = sz[k].end+sz[k].eg-sz[k].start;
           zz[k].gstart= sz[k].start;
           zz[k].gend  = sz[k].end;
        }
return 0;
}
/*..................................................................*/
