/* The parallel MPI-IO version */

#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>

#include "../meshc.h"

#ifdef HAS_HASH
#define dump_raster_3d dump_raster_3d_
#endif
 #ifdef HAS_CAP
#define dump_raster_3d DUMP_RASTER_3D
#endif

/*..................................................................*/
void dump_raster_3d(sz,filename,step_par,out_par,arr,arrmax,arrmin)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *arr, *arrmax, *arrmin;
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy,buflen;
	int nstep, ndim = 3, pset;
	char prefix[80];
	char out[100];
        PIArrayPart zz[3];
        float par[6]; int gdim[3];

	unsigned char *rast;

        int myid;

        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

        MPI_File fp;
        MPI_Status status;
        MPI_Comm comm3d = MPI_COMM_WORLD;
        MPI_Datatype filetype;
	MPI_Offset OffsetDisp;
        int array_of_sizes[3], array_of_subsizes[3];
        int nprocs, array_of_starts[3], order, k;

        MPI_Comm_rank(MPI_COMM_WORLD, &myid);
        MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;
        buflen = (ex-bx+1)*(ey-by+1)*(ez-bz+1)*sizeof(unsigned char);

        rast = (unsigned char *)malloc(buflen);
	if( !rast ) printf("%d Error: rast allocation failed \n",myid);

        /* ..... get max and min of the array to dump .....*/
	pset = 0;

        if( *arrmax == 0.0 && *arrmin == 0.0 )
	  AL_get_maxmin(arrmax,arrmin,arr,sz,&ndim,&pset);
        
/*..... Form the raster array ...........*/        
        AL_from_array_to_rast3d(rast,arr,arrmax,arrmin,
     &bx,&ex,&bxgp,&exgp, &by,&ey,&bygp,&eygp, &bz,&ez,&bzgp,&ezgp ); 

        /* Create the file name and open the file */

 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/
	
        nstep = step_par[0]; /*Step from the beginning of the simulation*/

        set_zz_3d_raster(zz,sz);        

       sprintf(out, "%s%s.%04d", FILEPATH, prefix, nstep);

       /* printf("dump_raster %s\n", out); */

       MPI_File_open( comm3d, out, MPI_MODE_CREATE | MPI_MODE_RDWR,
                      MPI_INFO_NULL, &fp ); 

/*.... Write parameters .............................................. */
/*......................................................................*/
        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[1];        /* time */
        par[4] = *arrmax;             /* max arr */
        par[5] = *arrmin;             /* min arr */

	if (myid == 0)
	{
#ifdef FORCE_SINGLE_OUTPUT
	  MPI_File_write(fp, par, 6, MPI_FLOAT, &status);
#else
	  MPI_File_write(fp, par, 6, MPI_DOUBLE, &status);
#endif
	}

#ifdef FORCE_SINGLE_OUTPUT
	OffsetDisp = 6*sizeof(float);
#else
	OffsetDisp = 6*sizeof(double);
#endif
	order = MPI_ORDER_FORTRAN;

	for (k=0; k<3; k++)
	{
	  array_of_sizes[k] = zz[k].mdim;
	  array_of_subsizes[k] = zz[k].ndim; /* No ghost points */
	  array_of_starts[k] = zz[k].gstart; /* MPIO assumes 0-indexing! */
	}
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_CHAR, &filetype);
	MPI_Type_commit(&filetype);

        MPI_File_set_view(fp, OffsetDisp, MPI_CHAR, filetype, "native", 
			  MPI_INFO_NULL);

	MPI_File_write_all(fp, rast, buflen, MPI_CHAR, &status); 

	MPI_File_close(&fp);
	MPI_Type_free(&filetype);

    free(rast);

}



/*.... ....................................................*/
/* Set up the array descriptor for the 3D raster routines */
/* This is clumsy, but you do it only once... */
set_zz_3d_raster(zz,sz)
PIArrayPart zz[3];
ALArrayPart sz[3];
{
        int k;

        for(k=0; k<3; k++){ 
	   zz[k].mdim  = sz[k].mdim;
           zz[k].ndim  = sz[k].end-sz[k].start+1;
           zz[k].start = 0;
           zz[k].end   = sz[k].end-sz[k].start;
           zz[k].gstart= sz[k].start;
           zz[k].gend  = sz[k].end;
        }
return 0;
}
/*..................................................................*/

