/* The parallel MPI-IO version */

#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>

#include "../meshc.h"

#ifdef HAS_HASH
#define dump_float dump_float_
#define restart_io restart_io_
#endif

#ifdef HAS_CAP
#define dump_float DUMP_FLOAT
#define restart_io RESTART_IO
#endif

/*..................................................................*/
void dump_float(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,phi,aux)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *phi;
float *aux;
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy;
	int nstep, ndim = 3;
	char prefix[80];
	char out[100];
        PIArrayPart zz[3];
        float par[6]; int gdim[3];

        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;
 
	MPI_File fp;
	MPI_Status status;
	MPI_Comm comm3d = MPI_COMM_WORLD;
        MPI_Datatype filetype, buftype;
        MPI_Offset   OffsetDisp;
        int array_of_sizes[3], array_of_subsizes[3];
        int mynod, nprocs, array_of_starts[3], order, k, extent;

        MPI_Comm_rank(MPI_COMM_WORLD, &mynod);
        MPI_Comm_size(MPI_COMM_WORLD, &nprocs);

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;

/*.....................................................................*/

        /* Create the file name and open the file */

 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/

        nstep = step_par[0];

        set_zz(zz,sz);        

        sprintf(out, "%s%s.%04d", FILEPATH, prefix, nstep);

	/* printf("dump_float %s\n", out); */

        MPI_File_open( comm3d, out, MPI_MODE_CREATE | MPI_MODE_RDWR,
                       MPI_INFO_NULL, &fp ); 

/*......................................................................*/

        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[0];        /* nstep */
        par[4] = step_par[1];        /* time */
        par[5] = step_par[9];        /* dt */

	if (mynod == 0)
	{
#ifdef FORCE_SINGLE_OUTPUT
	  MPI_File_write(fp, par, 6, MPI_FLOAT, &status);
#else
	  MPI_File_write(fp, par, 6, MPI_DOUBLE, &status);
#endif
	}

#ifdef FORCE_SINGLE_OUTPUT
	OffsetDisp = 6*sizeof(float);
#else
	OffsetDisp = 6*sizeof(double);
#endif
	order = MPI_ORDER_FORTRAN;

	for (k=0; k<3; k++)
	{
	  array_of_sizes[k] = zz[k].mdim;
	  array_of_subsizes[k] = zz[k].end-zz[k].start+1;/* Has ghost points */
	  array_of_starts[k] = zz[k].gstart; /* MPIO assumes 0-indexing! */
/*	  printf("size %d\n", array_of_sizes[k]);
	  printf("subsize %d\n", array_of_subsizes[k]);
	  printf("start %d\n", array_of_starts[k]); */
	}

#ifdef FORCE_SINGLE_OUTPUT
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_FLOAT, &filetype);
#else
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_DOUBLE, &filetype);
#endif
	MPI_Type_commit(&filetype);

#ifdef FORCE_SINGLE_OUTPUT
        MPI_File_set_view(fp, OffsetDisp, MPI_FLOAT, filetype, "native", 
			  MPI_INFO_NULL);
#else
        MPI_File_set_view(fp, OffsetDisp, MPI_DOUBLE, filetype, "native", 
			  MPI_INFO_NULL);
#endif

	/* Now build the memory-subarray describing the actual array
	   within the ghost super-array. This affects only the memory layout, 
	   does not affect the filetype described above.
	   The filetype is used to describe the file distribution across 
	   procs whereas the memory-layout is within one proc. */

	for (k=0; k<3; k++)
	{
	  array_of_sizes[k] = zz[k].ndim; /* Size of ghost-super array which
					     contains the actual data 
					     subarray */
	  array_of_subsizes[k] = zz[k].end-zz[k].start+1;/* Has ghost points */
	  array_of_starts[k] = zz[k].start; /* MPIO assumes 0-indexing! */
	}

#ifdef FORCE_SINGLE_OUTPUT
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_FLOAT, 
				 &buftype);
#else
	MPI_Type_create_subarray(3, array_of_sizes, array_of_subsizes,
				 array_of_starts, order, MPI_DOUBLE, 
				 &buftype);
#endif

	MPI_Type_commit(&buftype);

 	/* printf( "About to execute File_write_all\n" ); */
#ifdef FORCE_SINGLE_OUTPUT
      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(rho+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(ux+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uy+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(uz+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(temp+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

      for(i=0;i<siz-1;i++) *(aux+i) = (float)( *(press+i) );
      MPI_File_write_all(fp, aux, 1, buftype, &status);

#else
      MPI_File_write_all(fp, rho, 1, buftype, &status);
      MPI_File_write_all(fp, ux, 1, buftype, &status);
      MPI_File_write_all(fp, uy, 1, buftype, &status);
      MPI_File_write_all(fp, uz, 1, buftype, &status);
      MPI_File_write_all(fp, temp, 1, buftype, &status);
      MPI_File_write_all(fp, press, 1, buftype, &status);
#endif
      /* printf ("Closing files\n" ); */
    MPI_File_close(&fp);
    MPI_Type_free(&filetype);
    MPI_Type_free(&buftype);
}
 

/*.... ....................................................*/
/* Set up the array descriptor for the IO routines */
/* This is clumsy, but you do it only once... */
set_zz(zz,sz)
PIArrayPart zz[3];
ALArrayPart sz[3];
{
        int k;
        for(k=0; k<3; k++){ 
	   zz[k].mdim  = sz[k].mdim;
           zz[k].ndim  = sz[k].end+sz[k].eg-sz[k].start+sz[k].sg+1;
           zz[k].start = sz[k].sg;
           zz[k].end   = sz[k].end+sz[k].eg-sz[k].start;
           zz[k].gstart= sz[k].start;
           zz[k].gend  = sz[k].end;
/*	  printf("size %d\n", zz[k].mdim);
	  printf("subsize %d\n", zz[k].end-zz[k].start+1);
	  printf("start %d\n", zz[k].gstart);*/
        }
	MPI_Barrier(MPI_COMM_WORLD);
return 0;
}
/*..................................................................*/
