
#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "meshc.h"

/* We keep this for later ......
#ifdef HAS_HASH
#define write_buffer write_buffer_
#define read_buffer read_buffer_
#define open_file open_file_
#endif

#ifdef HAS_CAP
#define write_buffer WRITE_BUFFER 
#define read_buffer READ_BUFFER 
#define open_file OPEN_FILE 
#endif
*/
 
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/
/*>>>>>>>>>>>>>>>>>>> UTILITY ARRAYS >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/
/*..................................................................*/
/* Write buffer 'phi' and return number of elements read            */
/*                                                                  */
/*------------EXAMPLE-----------------------*/
/*                                          */
/*	fp = open_file(out, O_RDWR|O_CREAT);*/
/*                                          */
/*.....  Dump the Pressure ................ */
/*      
 *        count = write_buffer(press,aux,fp,count,hd,
 *             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);
 *
 *-----------------------------------------*/

int write_buffer(phi,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
array *phi;
#ifdef FORCE_SINGLE_OUTPUT
float *aux;
#else
array *aux;
#endif
int fp;
int count,hd;
int  bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp;
{
    register int i,j,k,ind,ind2,ind3;  
    int buflen,sizx,sizy,sizz,sxy ;

    if( count == 0 ) count = count-1;

    sizx   = (ex+exgp-bx+bxgp+1);
    sizy   = (ey+eygp-by+bygp+1);
    sizz   = (ez+ezgp-bz+bzgp+1);
    sxy    = sizx*sizy;

#ifdef FORCE_SINGLE_OUTPUT
    buflen = (ex-bx+1)*(ey-by+1)*sizeof(float);
#else
    buflen = (ex-bx+1)*(ey-by+1)*sizeof(array);
#endif
            for(k=bz-1; k<ez; k++){
                count = count+1;
                ind3 = (k+bzgp)*sxy;
        	for(j=by-1;j< ey;j++){
	        for(i=bx-1;i< ex;i++){
                    ind  = (i+bxgp)+ sizx*(j+bygp)+ind3;
                    ind2 = i+ ex*j;
                    *(aux+ind2) = *(phi+ind);
                }
                }
                write_arr( fp, count, aux, buflen, hd);
        }

    return count;
}


int read_buffer(phi,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp)
array *phi;
#ifdef SINGLE_OUTPUT
float *aux;
#else
array *aux;
#endif
int fp;
int count,hd;
int  bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp;
{
    register int i,j,k,ind,ind2,ind3;  
    int buflen,sizx,sizy,sizz,sxy ;

    if( count == 0 ) count = count-1;

    sizx   = (ex+exgp-bx+bxgp+1);
    sizy   = (ey+eygp-by+bygp+1);
    sizz   = (ez+ezgp-bz+bzgp+1);
    sxy    = sizx*sizy;

#ifdef FORCE_SINGLE_OUTPUT
    buflen = (ex-bx+1)*(ey-by+1)*sizeof(float);
#else
    buflen = (ex-bx+1)*(ey-by+1)*sizeof(array);
#endif
            for(k=bz-1; k<ez; k++){
                count = count+1;
                ind3 = (k+bzgp)*sxy;
                read_arr( fp, count, aux, buflen, hd);
        	for(j=by-1;j< ey;j++){
	        for(i=bx-1;i< ex;i++){
                    ind  = (i+bxgp)+ sizx*(j+bygp)+ind3;
                    ind2 = i+ ex*j;
                    *(phi+ind) = *(aux+ind2);
                }
                }

        }

    return count;
}

int open_file(opfil, opmode)
char *opfil; int  opmode;
{
        int fd;
        if( (fd = open(opfil, opmode, 0660)) == -1) {
             printf("Cannot open file %s \n", opfil);
             exit(0);
        }
        return fd;
}

int write_arr( rfil, count, arr, buflen, hd)
int rfil;
int count, buflen, hd;
char *arr;
{
        int off, s1;


        off = hd + count*buflen;

        if(lseek( rfil, off, 0) < 0) {
                 printf("Seek error in  write_arr\n");
        }

        if(write(rfil, arr, buflen) != buflen){
                 printf("Write error in write_arr\n");
                 exit(1);
        }
        return rfil;
}

read_arr( rfil, count, arr, buflen, hd)
int rfil;
int count, buflen, hd;
char *arr;
{
        int off, s1;


        off = hd + count*buflen;

        if(lseek( rfil, off, 0) < 0) {
                 printf("Seek error in  read_arr\n");
        }

        if(read(rfil, arr, buflen) != buflen){
                 printf("Write error in read_arr\n");
                 exit(1);
        }
        return rfil;
}
/*..................................................................*/
