/* The parallel IO version */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "meshc.h"

#ifdef FORTRANUNDERSCORE
#define dump_raster_3d dump_raster_3d_
#endif

#ifdef HAS_CAP
#define dump_raster_3d DUMP_RASTER_3D
#endif

#define MAX_RAST_LEN  (128*128*128)
#define PIAllProcs MPI_COMM_WORLD

/*..................................................................*/
void dump_raster_3d(sz,filename,step_par,out_par,arr,arrmax,arrmin)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *arr, *arrmax, *arrmin;
{	
	register int i; 
        int size, siz, sizx, sizy, sizz, sxy,buflen,count,hd;
	int nstep, ndim = 3;
	char prefix[80];
	char out[100];
	int fp;
        float par[6]; int gdim[3];
        unsigned char *rast;

        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        siz    = sizx*sizy*sizz;
        buflen = (ex-bx+1)*(ey-by+1)*(ez-bz+1)*sizeof(unsigned char);

        if( buflen > MAX_RAST_LEN ){
            printf("DUMP_RASTER_3D: buflen exceeds MAX_RAST_LEN\n");
        }
        rast = (unsigned char *)malloc(buflen);

/*	printf("In PIO %d %d %d %d %d %d\n",bx,ex,by,ey,bz,ez); /**/

        /* ..... get max and min of the array to dump .....*/
        if( *arrmax == 0.0 && *arrmin == 0.0 )
        AL_get_maxmin(arrmax,arrmin,arr,sz,&ndim,PIAllProcs);
        
/*..... Form the raster array ...........*/        
        AL_from_array_to_rast3d(rast,arr,arrmax,arrmin,
     &bx,&ex,&bxgp,&exgp, &by,&ey,&bygp,&eygp, &bz,&ez,&bzgp,&ezgp ); 
/*.....................................................................*/
        /* Create the file name and open the file
         * Here we do it only at the beginning, and
         * then we hope that the file will accumulate
         * sequentially onto the first file
         */
	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/

        nstep = step_par[0];

        sprintf(out, "%s.%04d", prefix, nstep); /**/
        fp = open_file(out, O_RDWR|O_CREAT);

/*.... Write parameters ........... */
/*......................................................................*/
        par[0] = (sz+0)->mdim;       /* nx */
        par[1] = (sz+1)->mdim;       /* ny */
        par[2] = (sz+2)->mdim;       /* nz */
        par[3] = step_par[1];        /* time */
        par[4] = *arrmax;             /* max arr */
        par[5] = *arrmin;             /* min arr */

        hd = 0; count = 0;
        write_arr( fp, count, par, 6*sizeof(float), hd);
/*......................................................................*/
  
/*......................................................................*/
        hd = 6*sizeof(float); count = 0;
        write_arr( fp, count, rast, buflen, hd);
/*......................................................................*/

     close(fp);
     free(rast);

}

