
#define FORCE_SINGLE_OUTPUT

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "meshc.h"


#ifdef FORTRANUNDERSCORE
#define dump_float dump_float_
#endif

#ifdef HAS_CAP
#define dump_float DUMP_FLOAT
#endif
 
/*..................................................................*/
void dump_float(sz,filename,step_par,out_par,
                ux,uy,uz,press,temp,rho,scalar,aux)
ALArrayPart *sz;
char *filename;
array *step_par, *out_par;
array *ux, *uy, *uz, *press, *temp, *rho, *scalar, *aux;
{	
        int bx,ex,bxgp,exgp;
        int by,ey,bygp,eygp;
        int bz,ez,bzgp,ezgp;
        int write_buffer();
	register int i, j, k, ind, ind2, ind3; 
        int size, siz, sizx, sizy, sizz, sxy;
	int buflen, hd, count,nstep,ndim = 3;
	char prefix[80];
	char out[100];
	float par[6]; int gdim[3];
	int fp;

        AL_get_array_bounds(&bx,&ex,&bxgp,&exgp,"x",sz);
        AL_get_array_bounds(&by,&ey,&bygp,&eygp,"y",sz);
        AL_get_array_bounds(&bz,&ez,&bzgp,&ezgp,"z",sz);

        AL_get_array_tsize(&size,sz,&ndim);

        AL_get_global_dim(gdim,sz,&ndim);

        sizx   = (ex+exgp-bx+bxgp+1);
        sizy   = (ey+eygp-by+bygp+1);
        sizz   = (ez+ezgp-bz+bzgp+1);
        sxy    = sizx*sizy;
        buflen = (ex-bx+1)*(ey-by+1)*sizeof(array);
	hd = 6*sizeof(float);

        nstep = out_par[0];

	/*have to make a copy else screw up fortran */
 	strncpy(prefix,filename,79);
	*strchr(prefix,32) = '\0'; /*remove trailing spaces*/
        sprintf(out, "%s.%04d", prefix, nstep); /**/

	fp = open_file(out, O_RDWR|O_CREAT);

/*......................................................................*/
        par[0] = gdim[0];       /* nx */
        par[1] = gdim[1];       /* ny */
        par[2] = gdim[2];       /* nz */
        par[3] = step_par[0];   /* nstep */
        par[4] = step_par[1];   /* time */
        par[5] = step_par[9];   /* dt */

        write_arr( fp, 0, par, hd, 0);
/*......................................................................*/
  
        
/*.....  Dump the density  ................. */
        count = 0;
        count = write_buffer(rho,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....  Dump the X-velocity............... */
      
        count = write_buffer(ux,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....  Dump the Y-velocity............... */
        
        count = write_buffer(uy,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....  Dump the Z-velocity............... */
        
        count = write_buffer(uz,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....  Dump the Temperature ............... */
       
        count = write_buffer(temp,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

/*.....  Dump the Pressure ............... */
       
        count = write_buffer(press,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);

#ifdef DO_PASSIVE_SCALAR
/*.....  Dump the Passive Scalar ............... */

        count = write_buffer(scalar,aux,fp,count,hd,
             bx,ex,bxgp,exgp,by,ey,bygp,eygp,bz,ez,bzgp,ezgp);
#endif
        close(fp);

}

