*/*F
*******************************************************
*                                                     *
* SUBROUTINE FLUID_SOLVER                             *
*                                                     *
* Solve the 1D compressible fluid equations           *
*                                                     *
* This particular version implements PPM,             *
* the Piecewise Parabolic Method of Woodward          *
* and Colella (1984).                                 *
* This code is based on an original version by        *
* Bruce Fryxell.                                      *
*                                                     *
*                                                     *
*    Author: Andrea Malagoli                          *
*    Date: 16 June 1995                               *
*                                                     *
*******************************************************
      subroutine Fluid_Solver(beg, end, bgp, egp, g, csi,
     &                        wold,uold,wsrc,usrc,wnew,unew,             
     &                        step_par, grid1_par, fluid_par, do_par, 
     &                        iy, iz, swpd)
      include 'meshf.h'
      include 'ppm.h'
      include 'param.h'
      integer beg,end,bgp,egp
      dimension g(beg-bgp:end+egp,2), csi(beg-bgp:end+egp,gr_0:gr_1)
      dimension wold(6,beg-bgp:end+egp),uold(6,beg-bgp:end+egp)
      dimension wnew(6,beg-bgp:end+egp),unew(6,beg-bgp:end+egp)
      dimension wsrc(5,beg-bgp:end+egp),usrc(5,beg-bgp:end+egp)
      dimension grid1_par(3)

*.............. Local Variables .......................*
      integer ndim, stencil, in
      parameter (nmax    = q)
      parameter( stencil = 4 )
      parameter(in = 1-stencil, en = nmax+stencil)
      integer bc_left, bc_right, geom 
*.......................................................*

*..... Do a little preparation here ........
        bc_left  = grid1_par(2)
        bc_right = grid1_par(3)
        geom     = grid1_par(1)

        smlrho = fluid_par( 1)
	smallp = fluid_par( 2)
	small  = 1.d-7
	smallu = small
	smalle = smallp

        ioff = beg-bgp-1

        nzn  = end-beg+1
	nzn1 = nzn+1
	nzn2 = nzn+2
	nzn3 = nzn+3
	nzn4 = nzn+4
	nzn5 = nzn+5
	nzn6 = nzn+6
	nzn7 = nzn+7
	nzn8 = nzn+8

	nriem = 3

	dt    = step_par(10)
	cfl   = step_par( 7)
	gamma = fluid_par( 4)
        fmult = 1.d0/(gamma - 1.d0)
        ggm1  = gamma*fmult

*>>>>>>>>>>>>>>>> This is really redundant >>>>>>>>>>>>>>>*
*>>>>>>>>>>>>>>>>  and should change soon  >>>>>>>>>>>>>>>*
	Do i = 1, nzn8
                ii       = i+ioff
		x(i)     = csi(ii,gr_x)
		xl(i)    = csi(ii,gr_xl)
		xr(i)    = csi(ii,gr_xr)
		dx(i)    = csi(ii,gr_dx)
		rho(i)   = wold(1,ii)
		u  (i)   = wold(2,ii)
		ut (i)   = wold(3,ii)
		utt(i)   = wold(4,ii)
		p(i)     = wold(5,ii)
		grav(i)  = g(ii,1)
		epot(i)  = g(ii,2)
c		areal(i) = csi(ii,gr_areal)
c		dvol(i)  = csi(ii,gr_dvol)
	End Do
                

40    continue

      gmm = (gamma-1.d0)

      ioff = beg-5

      Do  i = 5, nzn4
	  i4 = i+ioff
	  wnew(1,i4)	= rho(i)
	  wnew(2,i4)	= u  (i)
	  wnew(3,i4)	= ut (i)
	  wnew(4,i4)	= utt(i)
	  wnew(5,i4)    = p(i)
      End do

      return
      end

