/** test program for the Parallel Skip List implementation in Fork95.
 *  @author  C.W. Kessler    03/1999
 */
#include <fork.h>
#include <stdlib.h>
#include <io.h>
#include <assert.h>

#include "skip.h"


int thiscmp( Key a, Key b)
{
#if DEBUG
   pprintf("thiscmp %d : %d\n", (int)a, (int)b );
#endif
   if ( (int) a < (int) b) return -1;
   else 
   if ( (int) a > (int) b) return 1;
   else return 0;
}

#define N 50

void main( void )
{
 start {
    sh PSkipList l;
    pr PSkipListItem mi; 
    sh int num[N], res[2*N];
    sh PSkipListItem ret[2*N];
    sh int counter = 0;
    sh int rescnt = 0;
    pr int i, j;
    seq pprintf("\nSkip list\n");
    farm srand( $*$*$ );
    seq l = new_PSkipList( thiscmp, 9, (Key) -9999 ); 
    seq l->print( l );
    seq {  // get deterministic random numbers:
       for (i=0; i<N; i++) { num[i] = rand()&0xffff; printf(" %d", num[i]); }
       printf("\n");
    }
    farm 
       for (i = mpadd(&counter,1); i<N; i=mpadd(&counter,1))
          if (!((i+1)%8)) {
               mi = l->delete( l, (Key)(num[i/2+1]));
               if (mi) res[mpadd(&rescnt,1)] = (int)(mi->key);
               else    res[mpadd(&rescnt,1)] = 1111111;  // marker
 
          }
          else
          if (!((i+2)%4)) 
               mi = l->decreaseKey( l, (Key)(num[i/3+1]), (Key)i );
          else
               l->insert( l, (Key)(num[i]), NULL );
    seq l->print( l );
    farm 
       for (i=$; i< l->size(l); i+=async_groupsize()) {
           mi = l->locate( l, (Key)num[i] );
           if (mi) pprintf("locate(%d): %d\n", num[i], (int)(mi->key));
           else    pprintf("locate(%d): not found\n", num[i]);
       } 
    while (! l->empty( l ) ) {
          sh int k = 7;
          sh int found = l->deleteMins( l, k, ret+rescnt );
          farm assert(found);
          for (i=$+rescnt; i<rescnt+found; i+=groupsize()) 
            res[i] = (int)(ret[i]->key);
          seq 
            for (i=rescnt; i<rescnt+found; i++) 
              pprintf("DeleteMins[%d]: %p, %d\n", i, ret[i], ret[i]->key );
          seq rescnt += found;
    }
    seq
       for (i=0; i<rescnt; i++)
          printf(" %d", res[i] );
 }
}
