#include"define.h"
#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include "coff.h"

extern char infilename[FILENAMELEN];   /* Namen fuer Ausgabefile ohne suffix */
extern char outfilename[FILENAMELEN];   /* Namen fuer Ausgabefile ohne suffix */

char dumpfilename[FILENAMELEN];

char listfilename[FILENAMELEN];   /*       */

struct fstackel /* Record fuer INCLUDE Stack */
{ FILE *f;                      /* FILE Pointer */
  int zn;                       /* Zeilennummer */
  int azn;                      /* aktuelle Zeilennummer */
  char nm[STR_LAENG];           /* File name */
};

struct fstackel fstack[FSTACKMAX];  /* INCLUDE stack */

int first;               /* Flag ob Oeffnen der ersten Datei */
int fstackanz;           /* Anzahl der Files auf INCLUDE stack */
extern int zeilnr, spaltnr,line;
int z_akt;
int file_ende;
extern int range;

extern int zeilenende;
extern long codeline, codelen;
extern int first_zeile;
extern int list_flag;
extern int anz_token;
extern struct token *tokens[TOKENANZ];
extern struct token *token_anf;
extern int anz_lab;
extern struct label *frelbl[MAXLABELANZ]; /* Feld von Zeigern auf freie labels */
extern struct label *frelbl_anf;       /* Anfang des Speicherbereichs der Labels */
extern struct label *lab_list[HASHANZ];/* Liste der definierten Labels */
extern int scndrun;
extern int verbose;



int akt_outlevel=1,akt_displevel=1;
extern FILE *infile, *outfile, *dumpfile;

int isop(char c)       

{  
  if (c=='+' || c=='-') return(2);
  else if (c=='&' || c=='|' || c=='^') return(3);
  else if (c=='*' || c=='/' || (c=='%') || c=='>' || c=='<') return(4);
  else if (c=='(') return(1); else if ((c)==')') return(1);
  else if (c=='_' || c=='~') return(5);
  else return(0);
}

/**************************************************************************
 fpop versucht einen FILE Zeiger vom INCLUDE Stack zu nehmen und zurueckzu-
 geben. Bei Fehler wird NULL zurueckgegeben.
 **************************************************************************/
 
FILE *fpop()
 
{ FILE *fzgr;                   /* Rueckgabewer */
 
  if(fstackanz)
  { zeilnr=fstack[--fstackanz].zn;
    strcpy(infilename,fstack[fstackanz].nm);
    fzgr=fstack[fstackanz].f;
    z_akt=fstack[fstackanz].azn;
    spaltnr=file_ende=0;
    range=FAILURE;
    codeline=(long)FAILURE;
    zeilenende=1;
  }
  else { errmsg(INCL_STACK_ERR); fzgr=NULL; }
  return(fzgr);
}
 

/**************************************************************************
 fpush versucht, die Datei mit Namen w zum Lesen zu oeffnen. Ist es eine
 INCLUDE Datei, so wird die alte Datei auf den INCLUDE Stack gepusht. Der
 Rueckgabewert ist 1 bei Erfolg, 0 sonst.
 **************************************************************************/
 
int fpush(w)
char *w;                        /* Neuer FILE Name */
 
{ int success=1;                /* Rueckgabewert */
 
  if(!first && (fstackanz<FSTACKMAX))
  { strcpy(fstack[fstackanz].nm,infilename);
    fstack[fstackanz].f=infile;
    fstack[fstackanz].azn=z_akt;
    fstack[fstackanz++].zn=zeilnr;
 
  }
  else if(!first) { errmsg(INCL_MAX_ERR); success=0; }
  zeilnr=spaltnr=file_ende=0;
  z_akt=-1;
  range=FAILURE;
  codeline=0L;
  zeilenende=1;
  if(success)
  { infile=NULL;
    strcpy(infilename,w);
    if(!(infile=fopen(infilename,"r")))
      {
	if(!(strcmp(infilename,STDINCODE))) infile=stdin;
	else
	  {
	    errmsg(IN_FILE_ERR); success=0;
	    if(!first) infile=fpop();
	  }
      }
  }
  if(first) first=0;
  if(success)
	  if(akt_displevel && verbose) 
		  printf("Reading file %s\n\n",infilename);
  return(success);
}

/* init all vars and structures */

int init(runcnt)
PASSMODE runcnt;                /* distinguish between single, first, second run */

{ 
  register int i;
  int success=1;

  if(runcnt==FIRST_RUN || runcnt==SINGLE_RUN)

  {
        if (verbose)
	    printf("This is PRASS, Version %s \n",VERSION);
	  
	  line=0;
	  
	  token_anf=(struct token*)malloc(TOKENANZ*sizeof(struct token));
	  if(token_anf!=NULL)
	  { 
		  for(i=TOKENANZ;i--;) tokens[i]=token_anf+i;
		  anz_token=TOKENANZ;
	  }
	  else success=0;

	  frelbl_anf=(struct label*)malloc(MAXLABELANZ*sizeof(struct label));
	  if(frelbl_anf!=NULL)
	  { 
		  for(i=MAXLABELANZ;i--;) frelbl[i]=frelbl_anf+i;
		  anz_lab=MAXLABELANZ;
		  for(i=HASHANZ;i--;) lab_list[i]=NULL;
	  }
	  else success=0;

	  strcpy(listfilename,outfilename);
	  strcat(listfilename,LST_SUFFIX);
	  strcpy(dumpfilename,outfilename);
	  strcat(dumpfilename,".cod");
      
	  outfile=NULL;
	  if(!(outfile=fopen(outfilename,"w"))) 
	  { 
		  errmsg(OUT_FILE_ERR); 
		  akt_outlevel=0; 
	  }
	  /*
	  dumpfile=NULL;
	  if(!(dumpfile=fopen(dumpfilename,"w"))) 
	  { 
		  errmsg(OUT_FILE_ERR); 
		  akt_outlevel=0; 
	  }
	  */
	  first_zeile=1;
	  list_flag=0;
	  first=1;

	  success=fpush(infilename);
	  
	  if(!success) errmsg(INIT_ERR);
  }  

if (runcnt==SECOND_RUN)
{
	coff_init(runcnt);
	akt_displevel=0;
	codeline=0;
	line=0;
	success=fpush(infilename);

	scndrun=1;
}

  return(success);
}



void de_init(int success)
{
	if (success && verbose)
	{
		printf("Successfully generated file  %s\n\n",outfilename);
	}
	
}

  
