/* -*-mb0-c-*- */
/* FILE:	getsym.c
   DESCRIPTION:	Assembler for SB-PRAM, compatible to GNU as
   AUTHOR:	Stefan Franziskus (stefan)
   VERSION:	0.1
   DATE:	Sept 8, 1993
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "define.h"
#include "coff.h"

/* global vars */

char *datacomms[]={"DC","DS"};

char *ranges[]={"CODE","DATA","BSS"};

char *speccomm[]={"CLOSE","OPEN","READ","WRITE"};

char *befehls[]=                /* verwendete Befehle */
{
    #define COMMAND(a,b,c,d,e,f) #a,          
    #include "commands.h"       /* commands.h enthaelt alle Befehle incl. */
    #undef COMMAND              /* Opcodes                                */
};

extern struct befehl com[];

extern int file_ende;

char zeile[ZEILELAENG];         /* Eine Zeile des Eingabefiles */

extern FILE *infile;
extern int line;
extern char strngwort[LABELLAENG];
extern char labelwort[LABELLAENG];
extern int range;
extern int z_ende;
extern int scndrun;

extern struct token puttoken[10];
extern struct token *putptr;

extern int lab_find();

extern struct section *sct;

/**************************************************************************
 binsuche sucht das Vorkommen eines Strings str in einem Feld von Strings,
 auf das feld zeigt, die Laenge des Feldes ist anz. Die Suche ist eine
 Binaersuche nach Mehlhorn, der Rueckgabewert ist der Feldindex des gesuch-
 ten Strings bei Vorkommen, die negative Zahl FAILURE bei Nichtvorkommen. 
 **************************************************************************/
 
int binsuche(feld,anz,str)
register char **feld;                    /* Zeiger auf Feld von Strings */
int anz;                        /* Laenge des Feldes */
register char *str;                      /* Gesuchter String */
 
{ register int unten,oben,naechster;     /* Feldgrenzen und -index */
  register int vgl;                      /* Resultat des Stringvergleichs */
 
  unten=0; oben=anz-1;
  naechster=(oben+unten)/2 + (oben+unten)%2;
  while((oben>=unten) && (vgl=strcmp(*(feld+naechster),str)))
  { if(vgl>0) oben=naechster-1; else unten=naechster+1;
    naechster=(oben+unten)/2 + (oben+unten)%2; 
  }
  if(!vgl) return(naechster); else return(FAILURE);
}


/**************************************************************************
 dezcheck untersucht ein Wort, ob es eine Dezimalzahl ist. Bei erfolgreichem
 Lesen wird *num mit ihrem Wert besetzt und der Rueckgabewert ist 1. Bei
 Fehler ist der Rueckgabewert 0.
 **************************************************************************/
 
int dezcheck(w,num)
register char *w;                        /* Zu testendes Wort */
register long *num;                      /* Zeiger auf zu liefernden Wert */
 
{ int success=1;                /* Rueckgabewert */

  *num=0L;
  while(*w!='\0' && success)
  { if(!isdigit(*w)) success=0;
    else *num= (*num)*10L + (long)(*w - '0');
    w++;
  }
  return(success);
}
 
 
/**************************************************************************
 speccommcheck untersucht ein Wort, ob es eines der festgelegten IO-Komman-
 dos ist. Bei erfolgreichem Lesen wird der Token *z gesetzt und der Rueck-
 gabewert ist 1. Bei Fehler ist der Rueckgabewert 0.
 **************************************************************************/
 
int speccommcheck(w,z)
register char *w;               /* Zu untersuchendes Wort */
register struct token *z;       /* Zu besetzendes Token */
 
{ register int success=1;       /* Rueckgabewert */
  register int index;           /* Nummer des Operators */
 
  index=binsuche(&speccomm[0],SPECCOMMANZ,w);
  if(index==FAILURE) success=0;
  else { z->typ=SPECBEFEHL; z->wert=(long)index; }
  return(success);
}
 
 
/**************************************************************************
 datacommcheck untersucht ein Wort, ob es einer der festgelegten Befehle
 auf Daten ist.
 Bei erfolgreichem Lesen wird der Token *z gesetzt und der Rueckgabewert
 ist 1. Bei Fehler ist der Rueckgabewert 0.
 **************************************************************************/
 
int datacommcheck(w,z)
register char *w;               /* Zu untersuchendes Wort */
register struct token *z;       /* Zu besetzendes Token */
 
{ register int success=1;       /* Rueckgabewert */
  register int index;           /* Nummer des Operators */
 
  if(*w!=SPECZEI) success=0;
  else
  { index=binsuche(&datacomms[0],DATACOMMANZ,w+1);
    if(index==FAILURE) success=0;
    else { z->typ=DATBEFEHL; z->wert=(long)index; }
  }
  return(success);
}
 
 
/**************************************************************************
 commcheck untersucht ein Wort, ob es einer der festgelegten Befehle ist.
 Bei erfolgreichem Lesen wird der Token *z gesetzt und der Rueckgabewert
 ist 1. Bei Fehler ist der Rueckgabewert 0.
 **************************************************************************/
 
int commcheck(w,z)
register char *w;                   /* Zu untersuchendes Wort */
register struct token *z;           /* Zu besetzendes Token */
 
{ register int success=1;           /* Rueckgabewert */
  register int index;               /* Nummer des Operators */
  char locw[STRINGLEN];             /* Lokale Variable fuer zu untersuchendes Wort */
  register char *zgr;               /* Pointer im string locw */

  strcpy(locw,w);
  
  zgr=locw;
  while(*zgr!='\0') { *zgr=toupper(*zgr); zgr++; };
  index=binsuche(&befehls[0],BEFANZ,locw);
  if(index==FAILURE) success=0;
  else 
  { 
	  z->typ=com[index].type;
	  if(z->typ==BEFEHL)
		  z->wert=(long)index;
	  else
		  z->wert=com[index].opcode;
  }
  return(success);
}
 
 
/**************************************************************************
 rangecheck untersucht ein Wort, ob es einer der festgelegten Bereiche ist.
 Bei erfolgreichem Lesen wird der Token *z gesetzt und der Rueckgabewert
 ist 1. Bei Fehler ist der Rueckgabewert 0.
 **************************************************************************/
 
int rangecheck(w,z)
register char *w;               /* Zu untersuchendes Wort */
register struct token *z;       /* Zu besetzendes Token */
 
{ register int success=1;       /* Rueckgabewert */
  register int index;           /* Nummer des Operators */
 
  if(*w!=SPECZEI) success=0;
  else
  { index=binsuche(&ranges[0],RANGESANZ,w+1);
    if(index==FAILURE) success=0;
    else { z->typ=RANGE; z->wert=(long)index; }
  }
  return(success);
}
 
/*************************************************************************
 symbolcheck untersucht ob ein Wort ein zulaessiger Label- oder Symbolname 
 ist. Bei erfolgreichem Lesen wird der Token *z gesetzt und der Rueckgabewert
 ist 1. Bei Fehler ist der Rueckgabewert 0.
 **************************************************************************/

int symbolcheck(w,z)
register char *w;
register struct token *z;

{
  register int success=1;
  
  if (!isalpha(*w) && (*w!='$') && (*w!='_') && (*w!='.')) success=0;
  w++;
  while((*w!='\0') && (*w!=':') && success)
  { 
	  if (!isalnum(*w) && *w!='$' && *w!='_' && *w!='.') success=0;
	  w++;
  };
  if (*w==':')  
  { 
	  z->typ=LABEL;      /* Falls letztes Zeichen ':' -> Label */
	  z->wert=(long)range;
  }
  else 
  {
	  z->typ=SYMBOL;     /* Falls letztes Zeichen '\0' -> Symbol */
	  z->wert=0L; 
  }
  
  return(success);
}
	  
/**************************************************************************
 hex_oct_bin_check untersucht ein Wort, ob es eine Hexadezimal-, Oktal- oder 
 Bin"arzahl ist. Bei erfolgreichem Lesen wird *num mit ihrem Wert besetzt 
 und der Rueckgabewert ist 1. Bei Fehler ist der Rueckgabewert 0.
**************************************************************************/
 
int hex_oct_bin_check(w,shift,num)
register char *w;                        /* Zu testendes Wort */
register short shift;                    /* Shiftwert 1-bin, 3-oct, 4-hex */
register long *num;                      /* Zeiger auf zu liefernden Wert */
 
{ int success=1;                /* Rueckgabewert */
  register char c;
  
  *num=0L;
  while(*w!='\0' && success)
    {
		if(shift==4) success=success && isxdigit(*w);
		if(shift==3) success=success && isoctdigit(*w);
		if(shift==1) success=success && isbindigit(*w);
		if(success)
		{ 
			*num <<= shift;
			c=(isdigit(*w)?(*w - '0'):(toupper(*w) - 'A' + 10));
			*num += (long)c;
		}
		w++;
    }
  
  return(success);
}

/*************************************************************************
 floatcheck prueft ob ein Wort eine zulaessige Floatingpointzahl ist,
 Bei Erflog wird der Token *z gesetzt und der Rueckgabewert ist 1. Bei
 Fehler ist der Rueckgabewert 0.
*************************************************************************/

int floatcheck(w,z)
register char *w;                /* Zu untersuchendes Wort */
register struct token *z;        /* Zu besetzendes Token */
 
{ int success=1;                 /* Rueckgabewert */
  int vorz=POSITIV;              /* Vorzeichen des Int Teils */
  int expv=POSITIV;              /* Vorzeichen des Exponenten */

  if((*w=='0') && (tolower(*(w+1))==FLOATSIGN))
    { w+=2;
      if (*w=='-') { vorz=NEGATIV; w++; }
      else if (*w=='+') { vorz=POSITIV; w++; };
	while((*w!='\0') && (*w!='.') 
	      && (tolower(*w)!=FLOATSIGN) && success)
	  { 
	    if (!isdigit(*w++)) success=0;     /* Optional Integer Part*/
	  }
      if(*(w)=='.')
	{ w++;
	  while((*w!='\0') && (tolower(*w)!=FLOATSIGN) && success)
	    {
	      if(!isdigit(*w++)) success=0;     /* Optional Fractional Part */
	    }
	}
      else if(tolower(*(w++))==FLOATSIGN)
	{ 
	  if (*(w)=='-') { expv=NEGATIV; w++; }
	  else 
	    if (*w=='+') { expv=POSITIV; w++; }
	    else
	      while((*w!='\0') && (tolower(*w)!=FLOATSIGN) && success)
		{
		  if(!isdigit(*w++)) success=0;	     /* Optional Exponent */
		}
	}
    }
  else success=0;
  if (success) { z->typ=ZAHL; z->wert=0; }
  return(success);
}

/**************************************************************************
 zahlcheck untersucht ein Wort, ob es eine Zahl mit fuehrendem # in
 binaerem (B), hexadezimalem (X) oder dezimalem Format ist. Bei erfolg-
 reichem Lesen wird der Token *z gesetzt und der Rueckgabewert ist 1. Bei
 Fehler ist der Rueckgabewert 0.
 **************************************************************************/
 
int zahlcheck(w,z)
register char *w;                /* Zu untersuchendes Wort */
register struct token *z;        /* Zu besetzendes Token */
 
{ int success=1;                 /* Rueckgabewert */
  long number=0;                   /* Zu lesende Zahl */
  int vorz=POSITIV;              /* Vorzeichen der Zahl */
  
  if (*w=='-') { vorz=NEGATIV; w++; }
  if(isdigit(*w))                /* Falls Zahlzeichen */
    { 
      if(((nozdigit(*w)) && dezcheck(w,&number))
	 || ((*(w++)==ZAHLZEI)
	     && (((tolower(*w)==HEXZEI)&&hex_oct_bin_check(w+1,4,&number))
		 || ((isoctdigit(*w))&&hex_oct_bin_check(w,3,&number)) 
		 || ((tolower(*w)==BINZEI)&&hex_oct_bin_check(w+1,1,&number)))));
	  else if (*w=='\0') number=0;
      else success=0;
    }
  else success=0;

  if (vorz==NEGATIV) number=-number; 
  if(success) 
  {
	  z->typ=ZAHL; 
	  z->wert=number;
  } 
  return(success);
}
 

/**************************************************************************
 getsym liefert das naechste Token des Eingabefiles. Zusaetzlich ist der
 Rueckgabewert 1 falls erfolgreich, 0 falls Fehler.
 **************************************************************************/
 
int getsym(tokzgr)
register struct token **tokzgr;
 
{ 
	int success=1;                        /* Rueckgabewert */
	char wort[STRINGLEN];	   	          /* Wort einer Zeile */
	register int gelesen=0;               /* Flag ob token erzeugt */
	char *dest, *strdest;
	static char *cz, *hz;
	int strg=0,chconst=0;
	int komflag=0;
    int i;
	
	int zzgr;
	int rzgr;
	
	if(puttoken!=putptr) 
	{
		if(*tokzgr==NULL) 
			*tokzgr=(struct token *)hol_token();
		**tokzgr=*putptr--; 
		return(1);
	} 
	
	else 

	if(file_ende) { errmsg(EOF_ERR); success=0; }
	else 
	{
		if(*tokzgr==NULL) 
			*tokzgr=(struct token *)hol_token();   /* Token Record anlegen */
		(*tokzgr)->wert=0;

		while(!gelesen)
		{
		  if(z_ende)                   /* Falls keine Zeile mehr da */
			{ 
				file_ende=(fgets(zeile,ZEILELAENG-1,infile)==NULL);
				line++;                         /* Zeilennummer setzen */
				cz=zeile;
				z_ende=0;
			}
			if(file_ende) 
			{ 
				(*tokzgr)->typ=F_ENDE; 
				gelesen=1;
				z_ende=1;
			}
			else                                  /* Nichtleere Zeile bearbeiten */
			{ 
				dest=wort;
				
				while(!z_ende && ( *cz=='\0' || *cz=='\t' || *cz==' ' || *cz==',' || komflag))
				{
					if (*cz=='\0') z_ende=1;
					if(*cz=='*' && *(cz+1)=='/') 
					{
						komflag=0;
						cz++;
					}
					
					cz++;
				}
			  if(!z_ende && !komflag)
				switch(*cz)
				{
					
				case '\n' :
				case ';'  : 
					(*tokzgr)->typ=EOTOK;
					(*tokzgr)->wert=0L;
					cz++;
					if(!komflag) return(1);
					break;
						
				case '\"' : strg=1;
				case '\'' : 
					if(*cz=='\'') chconst=1;
					while(strg || chconst)
					{ 
						if(strg)
							(*tokzgr)->wert++;
						if(*cz=='\\')
						{ 
							cz++;
							if (isdigit(*cz) && (*cz!='0'))
							{ 
								*dest=0;
								while (isdigit(*cz) && (*cz!='\0'))
								{ 
									*dest= *dest*8 + (*cz - '0');
									cz++;
								}
								dest++;
							}
							else
							{
								switch(*cz) 
								{ case '\\': *dest++='\\'; break;
								case 'b' : *dest++='\b'; break;
								case 't' : *dest++='\t'; break;
								case 'n' : *dest++='\n'; break;
								case 'f' : *dest++='\f'; break;
								case 'r' : *dest++='\r'; break;
								case '"' : *dest++='\"'; break;
								case '0' : *dest++='\0'; break;
								case '\n': break;
									default  : *dest++=*cz; break;
								}
								cz++;
							}
						}
						else
						{ 
							if(strg && *cz=='\n')
							{   								
								errmsg(NEWLINE_ERR);
								return(0);
							}

							if(chconst  && (*(cz+1)!='\\')) 
							{ 
								*dest++=*cz++;
							  
							} 
							*dest++=*cz++; 
						
					    }
						
						if(isbreak(*cz) && chconst)
						{
							chconst=0;
							if (chconst==0)
							{ 
								*dest='\0';
								(*tokzgr)->typ=ZAHL;
								(*tokzgr)->wert=*(dest-1);
								return(1);
							}
						}

						if(*cz=='\0')
							{
								file_ende=(fgets(zeile,ZEILELAENG-1,infile)==NULL);
								line++;                     
								cz=zeile;
								if (file_ende) return(0);
								
							}
				
						if(strg && *cz=='\"') 
							{
								cz++;
								strg=1-strg;
								if (strg==0)
								{ 
									(*tokzgr)->typ=STRNG;
									*dest='\0';
									strdest=strngwort;
									dest=wort+1;
									for(i=(*tokzgr)->wert;i>0;i--)
										*strdest++=*dest++;
										
									/* strncpy(strngwort,wort+1,(*tokzgr)->wert); */
									*(strngwort+strlen(strngwort))='\0';
									/* printf("%s %s\n",wort,strngwort); */
									return(1);
								}
							}
					}
				break;
					
				case '-' :
				case '~' :
				case '+' :
				case '%' :
				case '<' :
				case '>' :
				case '|' :
				case '&' :
				case '^' :
				case '*' :
				case '/' :
				case '(' :
				case ')' :
					if((*cz=='<' && *(cz+1)=='<') || (*cz=='>' && *(cz+1)=='>')) 
						cz++;
					if(iskomzei(*cz,*(cz+1)))
					{
						komflag=1;
						cz++;
					}
					else 
					{
						(*tokzgr)->typ=OPERAT;
						(*tokzgr)->wert=(long)*cz;
					}
					cz++;
					if(!komflag) return(1);
					break;
					
				case '#' :
				case '!' :
					z_ende=1;
					(*tokzgr)->typ=EOTOK;
					(*tokzgr)->wert=0L;
					return(1);
					
				case '=' :
					(*tokzgr)->typ=EQUAL;
					(*tokzgr)->wert=0L;
					cz++;
					return(1);

				case '\\':
					file_ende=(fgets(zeile,ZEILELAENG-1,infile)==NULL);
					line++;                     
					cz=zeile;
					if (file_ende) return(0);
					break;

				case '@':
					if(*(cz+1)=='b' && *(cz+2)=='r' && *(cz+3)=='d')
					{
						errmsg(BRD_ERR);
						cz+=4;
					}
					break;

			        case '.' :
					if(*(cz+1)=='=' || *(cz+1)=='+' || isbreak(*(cz+1)))
					{
						(*tokzgr)->typ=DOT;
						(*tokzgr)->wert=sct->head.s_size;
						cz++;
						return(1);
					}	
					   
				case '0' : 
					if(*(cz+1)=='e' || *(cz+1)=='E')
					{   
						hz=cz+2;
						while(isalnum(*cz) || *cz=='+' || *cz=='-' || *cz=='.')
							*dest++=*cz++;
						
						*dest='\0';
						success=floatcheck(wort,*tokzgr);
						if(success)
						{
							*(float *)(&((*tokzgr)->wert))=atof(hz);
							return(success);
						}
					}
					
				default:
	
					{
						while(isalnum(*cz) || *cz=='.' || *cz=='_' || *cz=='$')
							*dest++=*cz++;
						*dest='\0';

						if(commcheck(wort,*tokzgr))
						{ /* OK Befehl gefunden */ 
							if(*cz==':')
							{
								errmsg(LAB_BEF_ERR);  
								cz++;
								success=0;
								/* Labelname=Befehl abfangen */
							}
						}

						else if(datacommcheck(wort,*tokzgr))
						{ /* Befehl auf Daten gefunden */ }
						
						else if (speccommcheck(wort,*tokzgr))
						{ /* IO-Kommando gefunden */ }

						else if (zahlcheck(wort,*tokzgr))
						{ /* OK Zahl gefunden */ }
						


						else if(*cz==':')
						{
							*dest++=*cz++;
							*dest='\0';
							symbolcheck(wort,*tokzgr);
							strcpy(labelwort,wort);
						}
						
						else if (symbolcheck(wort,*tokzgr))
						{ /* OK Label oder Symbol gefunden */
							if ((*tokzgr)->typ==SYMBOL) 
							{
								success=lab_find(wort,&zzgr,&rzgr);
								strcpy(labelwort,wort);
								(*tokzgr)->wert=zzgr;
								if(!success && scndrun)
								{
									lab_ins(labelwort, 0, 0, 0, C_EXT);
									success=lab_find(wort,&zzgr,&rzgr);
									strcpy(labelwort,wort);
									(*tokzgr)->wert=zzgr;
								}
							}
						}
						else 
						{
							cz++;
							errmsg(UNKNOWN_ERR);
							success=0;
						}
					}
					if(!komflag && !strg) gelesen=1;
					break;
				}
			}
		}
	}
  return((int)success);
}

int putsym(tokzgr)
register struct token **tokzgr;
{
		*(++putptr)=**tokzgr;

		return(0);
}




















