/* -*-mb0-c-*- */
/* FILE:        coff.c
   DESCRIPTION: generating coff-coded files
   AUTHOR:      Stefan Franziskus
   DATE:        DEC 14, 1993
*/

#include<stdio.h>
#include<stdlib.h>
#include <string.h>
#include <ctype.h>
#include "define.h"
#include "coff.h"

struct section *sct;           /* Sectionliste */
struct section *sct_beg;       /* Pointer auf Anfang der Sectionliste */
struct syment_blk *symtab;
struct syment_blk *symtab_beg;
static struct filehdr file_head;
static struct aouthdr aout_head;
extern FILE *outfile,*dumpfile;
long str_tab_len=4;

void coff_init(PASSMODE runcnt)
{
	if (runcnt==FIRST_RUN || runcnt==SINGLE_RUN)
	{
		sct=NULL;
		sct_beg=NULL;
		file_head.f_opthdr=sizeof(AOUTHDR);
		symtab=malloc(sizeof(struct syment_blk));
		symtab_beg=symtab;
	}
	if (runcnt==SECOND_RUN)
	{
		sct=sct_beg;
		while(sct!=NULL)
        {
			sct->head.s_size=0;
			sct=sct->next;
        }
	}
}

int add_section(char *name, long type)
{
	int i=0;
	
	if(sct==NULL)
	{
		sct=malloc(sizeof(struct section));
		sct->section_nr=1;
	}
	else
	{
		sct->next=malloc(sizeof(struct section));
		sct->next->section_nr=sct->section_nr+1;
		sct=sct->next;
	}
	sct->next=NULL;

	file_head.f_nscns++;
	
	if(sct_beg==NULL)
		sct_beg=sct;
	while(*name!=NULL)
		sct->head.s_name[i++]=*name++;
	sct->head.s_name[i++]='\0';
	sct->symndx=file_head.f_nsyms;
	sct->head.s_size=0;
	sct->head.s_flags=type;
	sct->data=malloc(sizeof(struct section_data));
	sct->data_start=sct->data;
	sct->head.s_nreloc=0;
	sct->relocate=malloc(sizeof(struct reloc_data));
	sct->reloc_start=sct->relocate;
	sct->head.s_nlnno=0;
	sct->lineno=malloc(sizeof(struct lineno_blk));
	sct->lineno_start=sct->lineno;
	return(1);
}

int search_section(char *name, long type)
{
	sct=sct_beg;
	while(sct!=NULL && sct->next!=NULL && strcmp(sct->head.s_name,name))
		sct=sct->next;
		
	if(sct==NULL || (sct->next==NULL && strcmp(sct->head.s_name,name)))
		add_section(name,type);
	if(sct->head.s_flags!=type)
		return(1); /*error*/
	
	return(1);
}

int coff_code_out(long code)
{
	if(sct==NULL)
	{
		errmsg(NO_SCT_ERR);
		return(0);
	}
	if ((sct->head.s_size-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
	{
		sct->data->next=malloc(sizeof(struct section_data));
		sct->data=sct->data->next;
		sct->data->next=NULL;
	}
	
	sct->data->data_item[sct->head.s_size % COFF_BLK_SIZE] = code;

	return(1);
}

long search_syment(long sct_num)
{
	int block_ptr=0;
	struct syment_blk *symtab_last;
	int return_value;
  
	symtab_last=symtab;	
	symtab=symtab_beg;
	while(symtab->entry[block_ptr % COFF_BLK_SIZE].n_scnum!=sct_num)
	{
		block_ptr++;
		if ((block_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
			symtab=symtab->next;
	}

	return_value=symtab->entry[block_ptr % COFF_BLK_SIZE].n_value;
	symtab=symtab_last;
	return(return_value);
}

long get_symndx(long sct_num)
{
	int block_ptr=0;
	struct section *sct_ptr;
	struct syment_blk *symtab_last;

	symtab_last=symtab;	
	sct_ptr=sct_beg;
	if(sct_num!=0)
	{
	  while(sct_ptr!=NULL && sct_ptr->section_nr!=sct_num)
	    sct_ptr=sct_ptr->next;
	  return(sct_ptr->symndx);
	}
	symtab=symtab_beg;
	while(symtab->entry[block_ptr % COFF_BLK_SIZE].n_scnum!=sct_num)
	  
	{
		block_ptr++;
		if ((block_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
			symtab=symtab->next;
	}

	symtab=symtab_last;
	return(block_ptr);
}

int create_relocent(long vaddr, long sct_num, long symval, int adr,  unsigned short type)
{
	unsigned long c_r_offset;
	long symndx;
	
	symndx=get_symndx(sct_num);
	
	c_r_offset=symval-search_syment(sct_num);
	
	if (sct_num==0)
	{
	    symndx=adr;
	    c_r_offset=symval-adr;
	}
	if((sct->head.s_nreloc-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
	{
		sct->relocate->next=malloc(sizeof(struct reloc_data));
		sct->relocate=sct->relocate->next;
		sct->relocate->next=NULL;
	}
	sct->relocate->reloc_item[sct->head.s_nreloc % COFF_BLK_SIZE].r_vaddr=vaddr;
	sct->relocate->reloc_item[sct->head.s_nreloc % COFF_BLK_SIZE].r_symndx=symndx;
	sct->relocate->reloc_item[sct->head.s_nreloc % COFF_BLK_SIZE].r_offset=c_r_offset;
	sct->relocate->reloc_item[sct->head.s_nreloc % COFF_BLK_SIZE].r_type=type;

	sct->head.s_nreloc++;

	return(0);
	
}

void create_lineno_ent(int l_paddr, int l_lnno)
{
	if((sct->head.s_nlnno-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
	{
		sct->lineno->next=malloc(sizeof(struct lineno_blk));
		sct->lineno=sct->lineno->next;
		sct->lineno->next=NULL;
	}
	sct->lineno->entry[sct->head.s_nlnno % COFF_BLK_SIZE].l_addr.l_paddr=l_paddr;
	sct->lineno->entry[sct->head.s_nlnno % COFF_BLK_SIZE].l_lnno=l_lnno;
	sct->head.s_nlnno++;
	
}


int patch_syment(char *name,long value,short scnum,char sclass)
{
	struct syment_blk *symtab_last;
	int i=0;
	
	symtab_last=symtab;
	symtab=symtab_beg;
	if(strlen(name)<=8)
		while(i<=file_head.f_nsyms && strcmp(symtab->entry[i% COFF_BLK_SIZE].n_name,name))
		{
			i++;
			if ((i-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
				symtab=symtab->next;
			
		}
	else
		while(i<=file_head.f_nsyms && strcmp(symtab->entry[i% COFF_BLK_SIZE].long_name,name))
		{
			i++;
			if ((i-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
				symtab=symtab->next;
		}
	
	
	symtab->entry[i % COFF_BLK_SIZE].n_value=value;
	symtab->entry[i % COFF_BLK_SIZE].n_scnum=scnum;
	symtab->entry[i % COFF_BLK_SIZE].n_sclass=sclass;
	
	symtab=symtab_last;
	
	return(i);
}

  

int create_syment(char *name,long value,short scnum,char sclass)
{
	int i=0;
	
	if ((file_head.f_nsyms-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
	{
		symtab->next=malloc(sizeof(struct syment_blk));
		symtab=symtab->next;
		symtab->next=NULL;
	}
	if(strlen(name)<=8)
		while(*name!=NULL)
			symtab->entry[file_head.f_nsyms % COFF_BLK_SIZE].n_name[i++]=*name++;
	else
	{
		symtab->entry[file_head.f_nsyms % COFF_BLK_SIZE].n_zeroes=0;
		symtab->entry[file_head.f_nsyms % COFF_BLK_SIZE].n_offset=str_tab_len;
		str_tab_len+=(strlen(name)+1);
		strcpy(symtab->entry[file_head.f_nsyms % COFF_BLK_SIZE].long_name,name);
	}	
	symtab->entry[file_head.f_nsyms % COFF_BLK_SIZE].n_value=value;
	symtab->entry[file_head.f_nsyms % COFF_BLK_SIZE].n_scnum=scnum;
	symtab->entry[file_head.f_nsyms % COFF_BLK_SIZE].n_sclass=sclass;
	
	file_head.f_nsyms++;
	
	return(file_head.f_nsyms-1);
	
}

void calculate_pointers()
{
	int i;
	long file_ptr;
	
	file_ptr=sizeof(struct filehdr)+sizeof(struct aouthdr)\
		+file_head.f_nscns*sizeof(struct scnhdr);
	aout_head.text_start=file_ptr;
	
	sct=sct_beg;

	while(sct!=NULL)
	{
		if(sct->head.s_flags!=STYP_BSS)
		{
			if(i==STYP_DATA)
				aout_head.data_start=file_ptr;
			
			sct->head.s_scnptr=file_ptr;
			file_ptr=file_ptr+sct->head.s_size * sizeof(long);
			
		}	
		sct=sct->next;
	}
	


	sct=sct_beg;
	while(sct!=NULL)
	{
		sct->head.s_relptr=file_ptr;
		file_ptr=file_ptr+sct->head.s_nreloc*RELOC_SIZE;
		
		sct=sct->next;
	}
	
	sct=sct_beg;
	while(sct!=NULL)
	{
		sct->head.s_lnnoptr=file_ptr;
		file_ptr=file_ptr+sct->head.s_nlnno*LINE_SIZE;
		
		sct=sct->next;
	}

	file_head.f_symptr=file_ptr;
}


int coff_file_out()
{

	long block_ptr;
	long block_size;
	
	sct=sct_beg;
	while(sct!=NULL)
	{
		switch(sct->head.s_flags)
		{
		case STYP_TEXT:
			aout_head.tsize+=(sct->head.s_size*sizeof(long));
			break;
		case STYP_DATA:
			aout_head.dsize+=(sct->head.s_size*sizeof(long));
			break;
		case STYP_BSS:
			aout_head.bsize+=(sct->head.s_size*sizeof(long));
			break;
		default:
			break;
		}
		sct=sct->next;
	}
	
	calculate_pointers();

	file_head.f_magic=0x0500;
	file_head.f_flags=F_LNNO | F_AR32W;
	
	fwrite(&(file_head.f_magic), sizeof(short), 2, outfile);
	fwrite(&file_head.f_timdat, sizeof(long), 3, outfile);
	fwrite(&file_head.f_opthdr, sizeof(short), 2, outfile);

	fwrite(&aout_head.magic, sizeof(short), 2, outfile);
	fwrite(&aout_head.tsize, sizeof(long), 6, outfile);

	sct=sct_beg;
	while(sct!=NULL)
	{
		sct->head.s_size*=sizeof(long);
		
		fwrite(&sct->head.s_name, sizeof(char), 8, outfile);
		fwrite(&sct->head.s_paddr, sizeof(long), 6, outfile);
		fwrite(&sct->head.s_nreloc, sizeof(short), 2, outfile);
		fwrite(&sct->head.s_flags, sizeof(long), 1, outfile);
		
		sct=sct->next;
	}


	sct=sct_beg;
	while(sct!=NULL)
	{
		sct->data=sct->data_start;
		
		block_size=sct->head.s_size / sizeof(long);
		if(sct->head.s_flags!=STYP_BSS)
			while(block_size>0)
			{
				if(block_size>COFF_BLK_SIZE)
				block_ptr=COFF_BLK_SIZE;
				else
					block_ptr=block_size;
			
				fwrite(sct->data->data_item, sizeof(long), block_ptr, outfile);
				block_size-=COFF_BLK_SIZE;
				sct->data=sct->data->next;
			}
		
		sct=sct->next;
	}


	sct=sct_beg;
	while(sct!=NULL)
	{
		sct->relocate=sct->reloc_start;
		for(block_ptr=0;block_ptr<sct->head.s_nreloc;block_ptr++)
		{
			if ((block_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
				sct->relocate=sct->relocate->next;
			
			fwrite(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_vaddr, sizeof(long), 1, outfile);
			fwrite(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_symndx, sizeof(long), 1, outfile);
			fwrite(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_offset, sizeof(long), 1, outfile);
			fwrite(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_type, sizeof(short), 1, outfile);
			fwrite(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_stuff, sizeof(short), 1, outfile);
			
		}
		sct=sct->next;
	}

	sct=sct_beg;
	while(sct!=NULL)
	{
		sct->lineno=sct->lineno_start;
		for(block_ptr=0;block_ptr<sct->head.s_nlnno;block_ptr++)
		{
			if ((block_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
				sct->lineno=sct->lineno->next;
			fwrite(&sct->lineno->entry[block_ptr % COFF_BLK_SIZE].l_addr.l_paddr,
				   sizeof(long), 2, outfile);
		}
		sct=sct->next;
	}
	
	symtab=symtab_beg;
	for(block_ptr=0;block_ptr<file_head.f_nsyms;block_ptr++)
	{
		if ((block_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
			symtab=symtab->next;
		
		fwrite(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_name, sizeof(char), 8, outfile);
		fwrite(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_value, sizeof(long), 1, outfile);
		fwrite(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_scnum, sizeof(short), 1, outfile);
		fwrite(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_type, sizeof(short), 1, outfile);
		fwrite(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_sclass, sizeof(char), 1, outfile);
		fwrite(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_numaux, sizeof(char), 1, outfile);
	}
	fwrite(&str_tab_len, sizeof(long), 1, outfile);	
	symtab=symtab_beg;
	for(block_ptr=0;block_ptr<file_head.f_nsyms;block_ptr++)
	{
		if ((block_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
			symtab=symtab->next;

		if(symtab->entry[block_ptr % COFF_BLK_SIZE].n_zeroes==0)
			fwrite(&symtab->entry[block_ptr % COFF_BLK_SIZE].long_name,\
			  strlen(symtab->entry[block_ptr % COFF_BLK_SIZE].long_name)+1,\
			  1, outfile);

	}
	fflush(outfile);
	return(0);
	
}	
