/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

#include "config.h"

static const char sccsid[] = "@(#)time.c	1.8";

#ifndef HAVE_TIMES
#include <sys/time.h>
#include <sys/resource.h>
#else
#include <sys/types.h>
#include <sys/times.h>
#include <limits.h>
#endif

#ifndef CLK_TCK
#include <unistd.h>
#define CLK_TCK sysconf(_SC_CLK_TCK)
#endif

#ifndef HAVE_TIMES
double get_time(void)
{
	static struct rusage usage_start;
	struct rusage usage_end;
	double time_diff;

	getrusage(RUSAGE_SELF, &usage_end);
	time_diff =
		(double)(usage_end.ru_utime.tv_sec
				 - usage_start.ru_utime.tv_sec
				 + usage_end.ru_stime.tv_sec
				 - usage_start.ru_stime.tv_sec)
			+ (usage_end.ru_utime.tv_usec
			   - usage_start.ru_utime.tv_usec
			   + usage_end.ru_stime.tv_usec
			   - usage_start.ru_stime.tv_usec) * 1e-6;
	getrusage(RUSAGE_SELF, &usage_start);
	return time_diff;
}
#else
double get_time(void)
{
        static struct tms usage_start;
        struct tms usage_end;
        double time;

        times(&usage_end);
        time =
                (double)(usage_end.tms_utime - usage_start.tms_utime 
                        + usage_end.tms_stime - usage_start.tms_stime)/CLK_TCK;
        times(&usage_start);
        return time;
}
#endif
