/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

static const char sccsid[] = "@(#) test_net.c 1.5@(#)";

#include <stdio.h>

#include "export_net.h"
#include "net.h"

static const char *mod_name[] =
{
	"LD", "ST", "MP", "SY",	"GH", "EOR", "ERRO", "ERRM"
};

static const char *op_name[] =
{
	"AND", "MPOPDIFF", "OR", "NETERR",
	"MAX", "NA", "ADD", "ALUOF"

};

void EmitNetPack(enum net_mod mod, enum net_op op, UWORD addr, WORD data,
				 struct vpregs *vp, int ppn, int modulobit)
{
	printf("packet: %s %s %08x %08x %d %d\n",
		   mod_name[mod], op_name[op], addr, data, ppn, modulobit);
}

void SimulateNetRound(int modulobit)
{
	printf("End of Round\n");
}

void InitNet(int ppn, int vpn)
{
	printf("init ppn=%d, vpn=%d\n", ppn, vpn);
}
