/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

/* @(#)simul.h	1.17 */

#ifndef __SIMUL_H
#define __SIMUL_H

#define BRK_STOP 1
#define BRK_DUMP 2
#define BRK_EXIT 4

#define FILEANZ 256
#define LFILEANZ 10

struct descriptor
{
	int opencnt;
	int fd;
	int isatty;            /* this should be cleaned up in the future */
	int word_type;         /* char or WORD or hWORD */
	int mode;
	char name[256];
};

struct NetStatistics
{
	int last_ct;
	int idle_nr, access_nr;
	int idle_access[32][32];
	int access_idle[32][32];
};

#ifdef MOD_EXTERN_NET
#define OPT_EXTERN_NET 1
#else
#define OPT_EXTERN_NET 0
#endif
#define OPT_NET_DEBUG 0x100
#define OPT_NET_INIT 2
#define OPT_NET 0x200
#define OPT_OP_TEST 0x400
#define OPT_NET_STAT 0x800
#define OPT_SIMULATE_ILLEGAL 4
#define OPT_SIMULATE_SYSC 8
#ifdef MOD_DEV_MAPPING
#define OPT_DEV_MAPPING 0x10
#else
#define OPT_DEV_MAPPING 0
#endif
#define OPT_TRACE 0x20
#define OPT_TEST_SLOW 0x40
#define OPT_BREAKPOINT 0x80
#ifdef MOD_FILE_MAPPING
#define OPT_FILE_MAPPING 0x1000
#else
#define OPT_FILE_MAPPING 0
#endif
#ifdef MOD_UART
#define OPT_UART 0x2000
#else
#define OPT_UART 0x0
#endif
#define OPT_RANDOMIZE 0x4000
#ifdef MOD_FILE_MAPPING
#define OPT_LAZY_MALLOC 0x8000
#else
#define OPT_LAZY_MALLOC 0x0
#endif
#define OPT_ER_TEST 0x10000
#define OPT_EW_TEST 0x20000

/* options handled only in SimulateNStepsSlow */
#define OPT_SLOW (OPT_EXTERN_NET|OPT_NET|OPT_NET_INIT|OPT_NET_STAT|OPT_TRACE|OPT_TEST_SLOW|OPT_BREAKPOINT)

#define IFOPT(a) if(options & (a))

#endif /* __SIMUL_H */
