/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

/* @(#)sim_cmds.h	1.8 */

#ifndef CMD_NAME
#define CMD_NAME(x)
#endif

CMD_NAME(reg)
#if CMD_DESCR
{"r", {ARG_OPT, ARG_PROZ, ARG_END},
	 "show all registers of processor PROC"},
#elif CMD_CODE
{
	struct vpregs *vp;
	int j;
	const char *s;
	UWORD sr;
	
	vp = VirtualProcessor + GET_PAR_OR_DEFAULT(val, 0, AktVP);
	for(j=0;j<32;j+=8)
	{
		printf("R %2i: %08X %08X %08X %08X %08X %08X %08X %08X\n", j,
			   vp->R[0+j], vp->R[1+j], vp->R[2+j], vp->R[3+j], 
			   vp->R[4+j], vp->R[5+j], vp->R[6+j], vp->R[7+j]);
	}
	sr = vp->SR;
	printf("SR: LM LZ IOP IEX IOU FAI FAS OXAIUOZN CVZN H43210 Y K F D P S MA\n");
	for(s="     x  x   x   x   x   x   x xxxxxxxx xxxx xxxxxx x x x x x x  x";*s;s++)
		if(*s=='x')
		{
			printf("%d", sr>>31);
			sr<<=1;
		}
		else
			putchar(*s);
	
	printf("\nMOD=$%08x, A=$%08x, BASE=$%08x, CT=$%08x\n"
		   "ModuloBit=%d, Prot=$%08x\n",
		   vp->pp->MOD, vp->pp->A, vp->BASE, vp->pp->CT, 
		   ModuloBit, vp->PROT);
}
#endif

CMD_NAME(convert)
#if CMD_DESCR
{"c", {ARG_VAL, ARG_END},
	 "show the value VAL val as dez, hex, float, bin"},
#elif CMD_CODE
{
	UWORD i, x = par[0].val;
	union int_float fi;
	fi.i = x;
	printf("#%d = $%x = %f = %%", x, x, fi.f);
	for(i=((UWORD)1<<31); i; i>>=1)
		putchar((i&x)? '1': '0');
	printf("\n");
}
#endif

CMD_NAME(fill)
#if CMD_DESCR
{"f", {ARG_RANGE, MEM_GLOBAL, 0, /*ARG_OPT,*/ ARG_VAL, ARG_END},
	 "fill the memory range MEM with VAL"},
#elif CMD_CODE
{
	UWORD *adr = par[1].adr, *end = par[2].adr, val = par[3].val;
	if(end==adr) end++;
	while(adr<end) *adr++ = val;
}
#endif

CMD_NAME(load)
#if CMD_DESCR
{"l", {/*ARG_OPT,*/ ARG_FILE, ARG_END},
	 "load the program FILE"},
#elif CMD_CODE
{
	char *name = par[0].file;
	FILE *fp = fopen(name, "r");
	if(fp)
	{  /* File korrekt geoeffnet */
		load(fp);		/* File wie normales Prg bearbeiten */
		fclose(fp);		/* File wieder schliessen */
	}
	else
	{
		printf("error while opening the file %s \n", name);
	}
}
#endif

CMD_NAME(init)
#if CMD_DESCR
{"init", {ARG_OPT, ARG_VAL, ARG_VAL, ARG_END},
	 "initialize with VAL PPs and VAL VPs (or with defaults)"},
#elif CMD_CODE
{
	de_init();
	PPnum = GET_PAR_OR_DEFAULT(val, 0, PPnum);
	VPnum = GET_PAR_OR_DEFAULT(val, 1, VPnum);
	
	if(init())
		exit(1);
	read_defaults(1);
	
	if(load_file(load_argc, load_argv))
		exit(1);
	
	IFOPT(OPT_NET)
	{
		DeInitNet();
		InitNet(PPnum, VPnum);
	}

	
	reset();
}
#endif




CMD_NAME(go)
#if CMD_DESCR
{"g", {ARG_END},
	 "start or continue the program"},
#elif CMD_CODE
{
	Simulate(0, options, 1);
	unassemble(VirtualProcessor[AktVP].R[1]);
	break;
}
#endif

CMD_NAME(disas)
#if CMD_DESCR
{"d", {ARG_OPT, ARG_RANGE, MEM_PROGRAM, 1, ARG_END},
	 "disassemble the memory range MEM"},
#elif CMD_CODE
	disass(par[0].adr, par[1].adr, par[2].adr);
#endif

CMD_NAME(memdump)
#if CMD_DESCR
{"m", {ARG_OPT, ARG_RANGE, MEM_GLOBAL, 8, ARG_END},
	 "show the memory area MEM as hex"},
#elif CMD_CODE
{
	UWORD *mem = par[0].adr, *adr = par[1].adr, *end = par[2].adr;
	while (adr<end)
	{
		int j;
		printf("%7X:", adr-mem);
		for (j=0; j<8 && adr<end; j++)
			printf(" %08X", *adr++);
		printf("\n");
	}
}
#endif

CMD_NAME(kascii)
#if CMD_DESCR
{"k", {ARG_OPT, ARG_RANGE, MEM_GLOBAL, 4, ARG_END},
	 "show the memory area MEM as hex and ascii"},
#elif CMD_CODE
{
	UWORD *mem = par[0].adr, *adr = par[1].adr, *end = par[2].adr;
	while (adr<end)
	{
		char buf[70];
		int j;
		for(j=0; j<sizeof(buf); j++) buf[j]=' ';
		printf("%7X: ", adr-mem);
		for (j=0; j<4 && adr<end; j++, adr++)
		{
			sprintf(buf+9*j, "%08X", *adr);
			buf[9*j+8] = ' ';
			buf[38+j] = conv(*adr);
			buf[45+4*j] = conv((*adr>>24)&255);
			buf[45+4*j+1] = conv((*adr>>16)&255);
			buf[45+4*j+2] = conv((*adr>>8)&255);
			buf[45+4*j+3] = conv(*adr&255);
		}
		printf("%.61s\n", buf);
	}
}
#endif

CMD_NAME(register)
#if CMD_DESCR
{"s", {ARG_REG, ARG_OPT, ARG_VAL, ARG_PROZ, ARG_END},
	 "set/show register REG of all Processors"},
#elif CMD_CODE
{
	struct vpregs *vp;
	struct ppregs *pp;
	int vpn, ppn, regnr = par[0].reg.reg;
	
	if(rarg_nr == 1)
	{
		int e;
		if(par[0].reg.is_pp)
		{
			for(ppn=0, pp=PhysicalProcessor; ppn<PPnum;)
			{
				printf("PP %3i:", ppn);
				e = ppn + 8;
				if(PPnum<e) e = PPnum;
				for(; ppn<e; pp++, ppn++)
					printf(" %08X", *(&(pp->CT)+regnr));
				printf("\n");
			}
		}
		else
		{
			for(vpn=0, vp=VirtualProcessor; vpn<VPnum*PPnum;)
			{
				printf("VP%4i:", vpn);
				e = vpn + 8;
				if(VPnum*PPnum<e) e = VPnum * PPnum;
				for(; vpn<e; vp++, vpn++)
					printf(" %08X", (vp->R[regnr]));
				printf("\n");
			}
		}
	}
	else if(rarg_nr == 2)
	{
		if(par[0].reg.is_pp)
			for(ppn=0, pp=PhysicalProcessor; ppn<PPnum; ppn++, pp++)
				*(&(pp->CT)+regnr) = par[1].val;
		else
			for(vpn=0, vp=VirtualProcessor; vpn<VPnum*PPnum; vpn++, vp++)
				vp->R[regnr] = par[1].val;
	}
	else
	{
		if(par[0].reg.is_pp)
			*(&(PhysicalProcessor[par[2].val].CT)+regnr) = par[1].val;
		else
			VirtualProcessor[par[2].val].R[regnr] = par[1].val;
	}	
}
#endif

CMD_NAME(trace)
#if CMD_DESCR
{"t", {ARG_OPT, ARG_VAL, ARG_END},
	 "trace. execute 1 or VAL rounds"},
#elif CMD_CODE
{
	int n = GET_PAR_OR_DEFAULT(val, 0, 1);
	int start;
	while(--n>=0) Simulate(1, options, 0);
	start=VirtualProcessor[AktVP].R[1];
	unassemble(start);
}
#endif

CMD_NAME(setaktp)
#if CMD_DESCR
{"p", {ARG_PROZ, ARG_END},
	 "set the active processor (for r or t)"},
#elif CMD_CODE
	AktVP = par[0].val;
#endif

CMD_NAME(save)
#if CMD_DESCR
{"save", {ARG_RANGE, MEM_GLOBAL, -1, ARG_FILE, ARG_END},
	 "store the memory area MEM in FILE"},
#elif CMD_CODE
{
	UWORD *mem = par[1].adr;
	int len = par[2].adr - mem;
	char *file = par[3].file;
	FILE *fp = fopen(file, "w");
	if(!fp)
		printf("Can't open file %s\n", file);
	else
	{
		fwrite(mem, sizeof(UWORD), len, fp);
		fclose(fp);
	}
}
#endif

CMD_NAME(save_byte)
#if CMD_DESCR
{"save-byte", {ARG_RANGE, MEM_GLOBAL, -1, ARG_FILE, ARG_END},
	 "store only the LSB of every WORD"},
#elif CMD_CODE
{
	UWORD *mem = par[1].adr;
	int len = par[2].adr - mem;
	char *file = par[3].file;
	FILE *fp = fopen(file, "w");
	if(!fp)
		printf("Can't open file %s\n", file);
	else
	{
		int i;
		for(i=0; i<len; i++) putc(mem[i] & 0xff, fp);
		fclose(fp);
	}
}
#endif

CMD_NAME(help)
#if CMD_DESCR
{"help", {ARG_END},
	 "print this help-text"},
#elif CMD_CODE
{
	int i;
	for(i=0; i<COUNT(icmds); i++)
	{
		char buf[40], *bp = buf;
		int *ap;
		sprintf(bp, "%s", icmds[i].cmd);
		bp += strlen(bp);
		for(ap=icmds[i].args; *ap!=ARG_END; ap+=arg_len[*ap])
		{
			sprintf(bp, " %s", arg_name[*ap]);
			bp += strlen(bp);
		}
		printf("%-21s %s\n", buf, icmds[i].help);
	}
	printf("\nall parameters after & are optional\n"
		   "MEM: [MEMORY:]BEGIN[-END]\n"
		   "  memory areas inclusive BEGIN, exclusive END\n"
		   "  MEMORY: G=global, P=programm, Lp=lokal Processor p\n"
		   "decimal: #   sedecimal: 0x $   oktal: 0   binary: %%)\n");
}
#endif

CMD_NAME(opcode_count)
#if CMD_DESCR
{"opcode-count", {ARG_END},
	 "print opcode-countings"},
#elif CMD_CODE
{
	int i;
	extern struct CmdVektor cmd_table[];
	for(i=0;i<128;i++)
		if(strcmp(cmd_table[i].name,""))
			printf("%-7s = $%02x: %d\n",
				   cmd_table[i].name, i<<1, OpcodeCounter[i]);
	break;
}
#endif

CMD_NAME(dump_core)
#if CMD_DESCR
{"dump-core", {ARG_OPT, ARG_FILE, ARG_END},
	 "store the simulator state in FILE (default: pcore)"},
#elif CMD_CODE
	pram_dump_core(GET_PAR_OR_DEFAULT(file, 0, "pcore"));
#endif

CMD_NAME(undump_core)
#if CMD_DESCR
{"undump-core", {ARG_OPT, ARG_FILE, ARG_END},
	 "load a stored simulator state in FILE (default: pcore)"},
#elif CMD_CODE
	pram_undump_core(GET_PAR_OR_DEFAULT(file, 0, "pcore"));
#endif

#ifdef MOD_BENCHMARK
CMD_NAME(bench)
#if CMD_DESCR
{"benchmark", {ARG_END},
	 "do a speed-test for the simulator"},
#elif CMD_CODE
{
	printf("Starting Benchmark, please stand by..\n");
	BenchmarkSimulator();
	printf("Benchmark done.\n");
}
#endif
#endif /* MOD_BENCHMARK */

CMD_NAME(netstat)
#if CMD_DESCR
{"netstat", {ARG_END},
	 "do statistics for the network"},
#elif CMD_CODE
{
	int n, i, j, type;
	char fname[100];
	FILE *fd;
	const char *ntypes[15]={"Alles\n","Load\n","Store\n","MP\n","SYNC\n","Alles privat\n","Load privat\n","Store privat\n","MP privat\n","SYNC privat\n","Alles shared\n","Load shared\n","Store shared\n","MP shared\n","SYNC shared\n"};
		
	sprintf(fname, "gzip -9 >stat.gz");
	fd = popen(fname, "w");
	for(n=0; (n<PPnum*VPnum)&&(n<8); n++)
	{
		fprintf(fd, "Proc #%d:\n", n);
		for(type=0; type<15; type++)
			if(type!=8 && type!=9 && type!=13 && type!=14)
			{
				fprintf(fd, "Prozessor #%d: %s", n, ntypes[type]);
				fprintf(fd, "Access vor Idle, Y-Achse: #Access-Zugriffe, X-Achse: #Idle-Zugriffe\n");
				for(i=31; i>=0; i--)
				{
					for(j=0; j<32; j++)
						fprintf(fd, "%d\t", NetStat[type][n].access_idle[i][j]);
					fprintf(fd, "\n");
				}
				fprintf(fd, "Idle vor Access, Y-Achse: #Access-Zugriffe, X-Achse: #Idle-Zugriffe\n");
				for(i=31; i>=0; i--)
				{
					for(j=0; j<32; j++)
						fprintf(fd, "%d\t", NetStat[type][n].idle_access[i][j]);
					fprintf(fd, "\n");
				}
			}
	}
	pclose(fd);
}
#endif

CMD_NAME(break)                           /* ### */
#if CMD_DESCR
{"break", {ARG_VAL, ARG_END},
	 "set breakpoint at adress VAL"},
#elif CMD_CODE
{
	UWORD adr = par[0].val;
	
	if((ProgramMem[adr]>>OpcodePos)!=CMD_BREAK)
	{
		BreakPoint[NumBreaks].address  = adr;
		BreakPoint[NumBreaks].opcode = ProgramMem[adr];
		BreakPoint[NumBreaks].type =  BRK_ALL;
		ProgramMem[adr] = (CMD_BREAK<<OpcodePos) | (NumBreaks & 1023);
		NumBreaks++;
	}
	else
	{
		fprintf(stderr, "There is already a breakpoint at this adress\n");
	}
}
#endif

CMD_NAME(rmbreak)
#if CMD_DESCR
{"rmbreak", {ARG_VAL, ARG_END},
	 "remove breakpoint number VAL"},
#elif CMD_CODE
{
	UWORD num = par[0].val, adr;
	
	if((num<=NumBreaks) && (BreakPoint[num].type != BRK_NONE))
	{
		adr = BreakPoint[num].address;
		ProgramMem[adr] = BreakPoint[num].opcode;
		BreakPoint[num].type = BRK_NONE;
	}
}
#endif

CMD_NAME(set)
#if CMD_DESCR
{"set", {ARG_OPT, ARG_FILE, ARG_FILE, ARG_END},
	 "set environment variable (pheap, pstack, ...)"},
#elif CMD_CODE
{
  int i;
  
  if(rarg_nr==2)
  {
	  for(i=0;i<last_p_env;i++)
	  {
		  if(p_env[i].name==NULL)
		  {
			  p_env[i].name = strdup(par[0].file);
			  p_env[i].str_val = strdup(par[1].file); 
			  break;
		  }
		  else if(!strcmp(p_env[i].name, par[0].file))
		  {
			  free(p_env[i].str_val);
			  p_env[i].str_val = strdup(par[1].file);
			  break;
		  }
	  }

	  if(i==last_p_env)
	  {
		  p_env[last_p_env].name = strdup(par[0].file);
		  p_env[last_p_env++].str_val = strdup(par[1].file);
	  }
	  
  }
  else if(rarg_nr == 0)
  {
	  for(i=0;i<last_p_env;i++)
		if(p_env[i].name)
		  sim_print(IO_NOTICE, "%s = %s\n", p_env[i].name, p_env[i].str_val);
  }
}
#endif
CMD_NAME(unset)
#if CMD_DESCR
{"unset", {ARG_FILE, ARG_END},
	 "delete environment variable"},
#elif CMD_CODE
{
  int i;
  
  if(rarg_nr==1)
  {
	  for(i=0;i<last_p_env;i++)
	  {
		  if(p_env[i].name!=NULL && !strcmp(p_env[i].name, par[0].file))
		  {
			  free(p_env[i].name);
			  free(p_env[i].str_val);
			  p_env[i].name = (char *)NULL;
			  break;
		  }
	  }
  }
}
#endif



CMD_NAME(ende)
#if CMD_DESCR
{"q", {ARG_END},
	 "leave the simulator"},
#elif CMD_CODE
	return 2;
#endif

#undef CMD_DESCR
#undef CMD_NAME
#undef CMD_CODE
