/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

#ifndef __PROCESSOR_H
#define __PROCESSOR_H

#include "prozflags.h"
#include <sys/types.h>

/* Word must be 32 Bit */
typedef int WORD;
typedef unsigned UWORD;
/* LWord must be 64 Bit */
typedef long long LWORD;
typedef unsigned long long ULWORD;
typedef unsigned char UCHAR;

union int_float
{
	WORD i;
	float f;
};

struct fpgaregs
{
	UWORD IR;                    /* Interruptregister */
	UWORD MR;                    /* Maskenregister    */
	UWORD AR;                    /* Alarm-Register    */
	UWORD PR;                    /* PPIRQ-Register    */
};

struct uartregs
{
	UCHAR RBR, THR;                /* For further info ask pb@cs */
    UCHAR IER, IIR;
	UCHAR FCR, LCR;
	UCHAR MCR, LSR;
	UCHAR MSR, SCR;
	UCHAR DLL, DLM;
	int fd;                        /* descriptor to use for r/w actions */
	pid_t pid;
};

#define UART_RBR 0
#define UART_THR 0
#define UART_IER 1
#define UART_LCR 3
#define UART_LSR 5
#define UART_DR  1
#define UART_DLAB 128

struct ppregs
{
	UWORD CT;
	UWORD MOD, MOD2;
	UWORD A;
	UWORD NR;
	WORD ctex;
	/* Reihenfolge der Register bis hier muss beibehalten werden,
	   oder die Registernamen in PPRegName muessen geaendert werden. */
	UWORD *LocalMem;
	struct fpgaregs FpgaRegs;
	struct uartregs UartRegs;
	int ExtEx, testex;
};

struct vpregs
{
	WORD R[32]; /* R[0]=0, R[1]=PC */
	UWORD SR;
	WORD BASE;
	UWORD PROT;
	UWORD LOG, LD;
	WORD dl_regno;
	WORD dl_val;
	/* Reihenfolge der Register bis hier muss beibehalten werden,
	   oder die Registernamen in VPRegName muessen geaendert werden. */
	int nr;
	int testex;
	struct ppregs *pp;
};

enum bkpttest {BP_RANGE, BP_MASK};

struct breakpt
{
	enum bkpttest test;
	int regno;
	UWORD val1, val2;
};

#define COMMAND(MNE, TYPE, VAL, P1, P2, P3) CMD_##MNE=((UWORD)VAL)>>25,
enum command 
{
#include "commands.h"
CMD_AFTER_LAST = 128
};
#undef COMMAND

/*  1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0  */
/* | Opcode      |   Rd    |   R2    |1|S|    I13                  | */
/* | Opcode      |   Rd    |   R2    |0|   ---           |   R1    | */
/* | Opcode      |   Rd    |S|                I19                  | */
#define R1Pos 0
#define R2Pos 15
#define RdPos 20
#define OpcodePos 25
#define GetI13 (((WORD)(Command)<<18)>>18)
#define GetI19 (((WORD)(Command)<<12)>>12)
#define GetR1Num ((UWORD)Command & 31)
#define GetR2Num (((UWORD)Command >> R2Pos) & 31)
#define GetRdNum (((UWORD)Command >> RdPos) & 31)

#define Set(a, b) ((a)|=(b))
#define Clear(a, b) ((a)&=~(b))
#if 1
#define NEGATIV(a) ((WORD)(a)<0)
#else
#define NEGATIV(a) ((a)&(1<<31))
#endif

#endif /* __PROCESSOR_H */
