/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

/* @(#)net.h	1.5 */

#ifndef __NET_H
#define __NET_H

enum net_mod
{
	MOD_LD, MOD_ST, MOD_MP, MOD_SY,
	MOD_GH, MOD_EOR, MOD_ERRO, MOD_ERRM
};

enum net_op
{
	OP_AND, OP_MPOPDIFF, OP_OR, OP_NETERR,
	OP_MAX, OP_NA, OP_ADD, OP_ALUOF
};

#define OP_NONE OP_AND

extern void EmitNetPack(enum net_mod mod, enum net_op op, UWORD vaddr,
						UWORD paddr, UWORD data, struct vpregs *vp);
extern void SimulateNetRound(int modulobit);
extern int InitNet(int ppn, int vpn);
extern int DeInitNet(void);

extern void Ext_EmitNetPack(enum net_mod, enum net_op, UWORD addr, WORD data,
							struct vpregs *vp, int ppn, int modulobit);
extern void Ext_SimulateNetRound(int modulobit);
extern int Ext_InitNet(int ppn, int vpn);

extern int compare_dl_val(struct vpregs *vp, WORD val);

#endif /* __NET_H */
