/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

static const char sccsid[] = "@(#)net.c	1.5";

#include <malloc.h>
#include <stdio.h>

#include "glovars.h"
#include "simul.h"
#include "net.h"

static int *GlobalOperationNonzeroStack;
static int *GlobalOperationNonzeroSP;
static signed char *GlobalOperation;

#define OPC_UNINITIALIZED -1
#define OPC_NOOP -2

static const char *mod_name[] =
{
	"LD", "ST", "MP", "SY",	"GH", "EOR", "ERRO", "ERRM"
};

static const char *op_name[] =
{
	"AND", "MPOPDIFF", "OR", "NETERR",
	"MAX", "NA", "ADD", "ALUOF"

};

#ifdef MOD_EXTERN_NET
int compare_dl_val(struct vpregs *vp, WORD val)
{
	if(vp->dl_regno<0)
	{
		fprintf(stderr, "NET: Unexpected load packet. val = $%08x, pc = $%08x\n", val, vp->R[1]);
		return 2;
	}
	if(vp->dl_val != val)
	{
		fprintf(stderr,
				"NET: Wrong value in load packet. val = $%08x, should be $%08x, pc = $%08x\n",
				val, vp->dl_val, vp->R[1]);
		return 1;
	}
	IFOPT(OPT_NET_DEBUG)
		printf("NETD: testing. val = $%08x\n", val);
	return 0;
}
#endif

void EmitNetPack(enum net_mod mod, enum net_op op, UWORD vaddr, UWORD paddr,
				 UWORD data, struct vpregs *vp)
{
	struct ppregs *pp = vp->pp;
	int ppn = pp - PhysicalProcessor;
	int vpn = vp - VirtualProcessor;
	IFOPT(OPT_NET_DEBUG)
	{
		printf("NETD: %s %s %08x %08x %d %d\n",
			   mod_name[mod], op_name[op], paddr, data, ppn, ModuloBit);
	}
	IFOPT(OPT_EXTERN_NET)
	{
		Ext_EmitNetPack(mod, op, paddr, data, vp, ppn, ModuloBit);
	}
	IFOPT(OPT_OP_TEST)
	{
		int opc = GlobalOperation[paddr];
		int nopc = mod | (op<<3);
		if(opc == OPC_UNINITIALIZED)
		{
#if 0 /* Solange read() nicht initialisiert */
			if(mod != MOD_ST)
				printf("uninitialized memory cell $%08x, proc=%d, PC=$%08x\n",
					   paddr, vp-VirtualProcessor, vp->R[1]);
#endif
			opc = OPC_NOOP;
		}
		if(opc != OPC_NOOP && opc != nopc && vp)
		{
			printf("different operations ($%02x & $%02x) same round\n"
				   "  pc=$%08x, proc=%d, paddr=%08x\n",
				   nopc, opc, vp->R[1], vp-VirtualProcessor, paddr);
		}
		IFOPT(OPT_ER_TEST)
			if(opc != OPC_NOOP && mod==MOD_LD && vp)
				printf("concurrent read same round:"
					   "  pc=$%08x, proc=%d, paddr=%08x\n",
					   nopc, opc, vp->R[1], vp-VirtualProcessor, paddr);
		IFOPT(OPT_EW_TEST)
			if(opc != OPC_NOOP && mod==MOD_ST && vp)
				printf("concurrent write in same round:"
					   "  pc=$%08x, proc=%d, paddr=%08x\n",
					   nopc, opc, vp->R[1], vp-VirtualProcessor, paddr);

		if(opc == OPC_NOOP)
			*GlobalOperationNonzeroSP++ = paddr;
		GlobalOperation[paddr] = nopc;
	}
#define Stat NetStat[type][vpn]
#define IdleNr Stat.idle_nr<=32?Stat.idle_nr:32
	IFOPT(OPT_NET_STAT)
		if(vpn < 8)
		{
			int i, j, type;
			
			for(i=0; i<=mod+1; i+=mod+1)
			{
				for(j=0;j<=1;j++)
				{
					type=i;
					if(j==1)
						if(NEGATIV(vaddr)) type+=5;
						else type+=10;
					
					if(pp->CT == (Stat.last_ct + 1))
						Stat.access_nr++;
					else
					{
						int AccessNr = Stat.access_nr<=32? Stat.access_nr: 32;
						Stat.idle_access[(AccessNr)-1][(IdleNr)-1]++;
						Stat.idle_nr = pp->CT - Stat.last_ct - 1;
						Stat.access_idle[(AccessNr)-1][(IdleNr)-1]++;
						Stat.access_nr = 1;
					}
					Stat.last_ct = pp->CT;
				}
			}
		}
}

void SimulateNetRound(int modulobit)
{
	IFOPT(OPT_NET_DEBUG)
	{
		printf("NETD: End of Round\n");
	}
	IFOPT(OPT_EXTERN_NET)
	{
		Ext_SimulateNetRound(modulobit);
	}
	IFOPT(OPT_OP_TEST)
	{
		while(GlobalOperationNonzeroSP > GlobalOperationNonzeroStack)
			GlobalOperation[*--GlobalOperationNonzeroSP] = OPC_NOOP;
	}
}

int InitNet(int ppn, int vpn)
{
	IFOPT(OPT_NET_DEBUG)
	{
		printf("NETD: init ppn=%d, vpn=%d\n", ppn, vpn);
	}
	IFOPT(OPT_EXTERN_NET)
	{
		if(Ext_InitNet(ppn, vpn))
			return 1;
	}
	IFOPT(OPT_OP_TEST)
	{
		int i;
		GlobalOperationNonzeroStack = malloc(sizeof(int) * ppn * vpn);
		GlobalOperationNonzeroSP = GlobalOperationNonzeroStack;
		GlobalOperation = malloc(GlobalMemLen);
		if(!GlobalOperationNonzeroStack || !GlobalOperation) return 1;
		for(i=0; i<GlobalMemLen; i++)
		{
			GlobalOperation[i] = OPC_UNINITIALIZED;
		}
	}
	return 0;
}

int DeInitNet()
{
	free(GlobalOperationNonzeroStack);
	free(GlobalOperation);
}
