/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

#include <stdio.h>
#include <stdarg.h>


enum io_class {IO_STDIO, IO_REG, IO_DISASS, IO_STDERR, IO_NOTICE, IO_DEBUG };

static int sim_print(enum io_class class, const char *format, ... )
{
	va_list arg;
	va_start(arg, format);

	switch(class)
	{
	case IO_STDIO:
		return vprintf(format, arg);
		break;
	case IO_REG:
		return vprintf(format, arg);
		break;
	case IO_DISASS:
		return vprintf(format, arg);
		break;
	case IO_STDERR:
		return vfprintf(stderr, format, arg);
		break;
	case IO_NOTICE:
		return vfprintf(stderr, format, arg);
		break;
	case IO_DEBUG:
		return vprintf(format, arg);
		break;
	default:
		fprintf(stderr, "Oops wrong IO-class\n");          /* #### */
		return -1;
		break;
	}
	
	va_end(arg);
}
