/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

#include <stdio.h>
#include <setjmp.h>
#include "processor.h"
#include "simul.h"

#ifdef DEFINE_VARS
static const char sccsid_glovars_h[] = "@(#)glovars.h	1.39";
#define extern
#endif

extern struct ppregs *PhysicalProcessor;
extern struct vpregs *VirtualProcessor;
extern UWORD *ProgramMem;
extern UWORD *GlobalMem;
extern UWORD *LocalMem; /* to access use pp->LocalMem */
extern WORD *ExternalInterrupts;

extern int VPnum, PPnum, KRnum;
extern unsigned ProgramMemLen;
extern unsigned GlobalMemLen;
extern unsigned LocalMemLen;

extern int OpcodeCounter[128];
extern int TimeCounter[128];
extern int CondCounter[32];
extern int FCondCounter[32];
extern struct NetStatistics NetStat[15][8];

extern int ModuloBit;
extern unsigned break_flags;
extern struct breakpt bkpt;

extern FILE *TraceFile;

extern struct descriptor desc[FILEANZ];
extern struct descriptor *(*ldesc)[LFILEANZ];
extern int pnummap[4096];
extern int killpramsim;

extern void SimulateNStepsFast(struct vpregs *vp, int len, unsigned options);
extern void SimulateNStepsSlow(struct vpregs *vp, int len, unsigned options);
extern int init(void);
extern void Simulate(unsigned single, unsigned options, int out_steps);
extern int SYSCSimul(struct vpregs *vp);
extern void sysc_reset(void);
extern int load(FILE *fp);
extern void disassemble(UWORD cmd, UWORD pc, char *out_buf);
extern void dostop_error(struct vpregs *vp, const char *s);
extern void dostop_break(struct vpregs *vp);
extern void dostop_illegal(struct vpregs *vp, const char *s);
extern void dostop_exit(struct vpregs *vp);
extern void trace_log(UWORD pc);
extern void pram_dump_core(const char *fname);
extern void pram_undump_core(const char *fname);
extern WORD pram_std_open(WORD fd);
extern void do_cmd(void);
extern void BenchmarkSimulator(void);
extern double get_time(void);
extern short VPReg_Search(const char *name);
extern short PPReg_Search(const char *name);
extern int LocMemLoad(struct ppregs *pp, struct vpregs *vp,
					  UWORD SR, UWORD addr);
extern void LocMemStore(struct ppregs *pp, struct vpregs *vp, UWORD SR, 
						UWORD addr, WORD data);

/* shadowed by SimulateNSteps{Fast,Slow} and Simulate */
extern unsigned options;

enum argument 
{ A_RX,A_RY,A_RZ,A_RD,A_S2,A_I19,A_SI19,A_I13,A_NIX,A_SPEC,A_RI19,A_RL, A_ICC, A_FCC };

struct CmdVektor
{
	char name[20];
	UWORD opcode;
	enum argument arg[3];
};

enum breaktype { BRK_NONE, BRK_ALL, BRK_VP, BRK_PP, BRK_VROW };

struct BreakPointStructure
{
	UWORD opcode;
	UWORD address;
	enum breaktype type;
	UWORD proznum;
};

#define BREAK_TAB_LEN 1024
#define GetBreak ((UWORD)(Command) & (BREAK_TAB_LEN - 1))

extern struct BreakPointStructure BreakPoint[BREAK_TAB_LEN];
extern int NumBreaks;

extern char *textstart, *datastart;

struct LoadEnv
{
  char *name, *str_val;
};

#define LOAD_ENV_TAB_LEN 100

extern struct LoadEnv p_env[LOAD_ENV_TAB_LEN];
extern int last_p_env;

extern int load_argc;
extern char **load_argv;
