/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

#include "config.h"

static const char sccsid[] = "@(#)filemapping.c	1.4";

#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include "interface.h"

#define error(S) sim_print(IO_STDERR, S"\n")

char *pram_fmap(unsigned size, const char *device)
{
	int fd;
	char *shared_mem;
	
	if(!strcmp(device, "/dev/zero"))
	{
		if((fd = open(device, O_RDWR, 0666)) == -1)
			error("open failed");
	}
	else
		if((fd = open(device, O_RDWR | O_CREAT | O_EXCL | 
					  O_TRUNC, 0666)) == -1)
			error("open failed");

	if(lseek(fd, size+1, SEEK_SET) == -1)
		error("lseek error");
	if(write(fd, "", 1) != 1)
		error("write error\n");

	lseek(fd, 0, SEEK_SET);
	write(fd, &size, sizeof(int));    /*    ### not reached!!!    */

	if(!strcmp(device, "/dev/zero"))
	{
		if((shared_mem = mmap(0, size, PROT_READ | PROT_WRITE, 
						   MAP_PRIVATE | MAP_NORESERVE, fd, 0)) == (char *)-1)
			perror("mapping failed");
		else
			sim_print(IO_NOTICE, "Mapped %s, good.\n", device);
	}
	else
		if((shared_mem = mmap(0, size, PROT_READ | PROT_WRITE, 
							  MAP_SHARED, fd, 0)) == (char *)-1)
			perror("mapping failed");
		else
			sim_print(IO_NOTICE, "Mapped %s, good.\n", device);
	
	close(fd);

	return(shared_mem);
}

void pram_funmap(void *ptr, const char *device)
{
	int size, fd;

	if((fd = open(device, O_RDWR | O_CREAT | O_TRUNC, 0666)) == -1)
		error("open failed");
	read(fd, &size, sizeof(int));
	if(munmap(ptr, size+1) == -1)
		error("unmapping failed");
	close(fd);
	unlink(device);
}

