/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

static const char sccsid[] = "@(#)disassemble.c	1.17";

#include <stdio.h>

#include "processor.h"
#include "glovars.h"

const char *intcc[]={
"RA", "MI", "EQ", "VS", "CS", "LS", "LE", "LT",
"NP", "PL", "NE", "VC", "CC", "HI", "GT", "GE",
"MS", "FS", "NS", "SS", "LZ", "LM", "DS", "KS",
"MC", "FC", "NC", "SC", "LN", "LP", "DC", "KC"};

const char *fltcc[]={
"MI", "EQ", "INF", "NAN", "IEX", "IOP", "UF", "OF",
"PL", "NE", "NIN", "GLE", "NIE", "NIO", "NUF", "NOF",
"OGT", "OGE", "OLT", "OLE", "OGL", "FXS", "ASS", "AIS", 
"ULE", "ULT", "UGE", "UGT", "UEQ", "FXC", "ASC", "AIC"};
	

#ifdef BUILD_TABLE
struct CmdVektor cmd_table[128];
#else
struct CmdVektor cmd_table[] =
{
#include"cmd_table.h"
};

#endif

#define buf_printf(a, b)\
do \
{ \
	  sprintf(out_buf, a, b); \
	  out_buf+=strlen(out_buf); \
} \
while(0)    /*### */

void disassemble(UWORD Command, UWORD PC, char *out_buf_start)
{
	int arg_ptr;
	struct CmdVektor *cmd = &cmd_table[Command>>OpcodePos];
	char *out_buf = out_buf_start;
	
	buf_printf("%s", cmd->name);
	switch(cmd->arg[0])
	{
	case A_ICC:
		buf_printf("%s", intcc[GetRdNum]);
		break;
	case A_FCC:
		buf_printf("%s", fltcc[GetRdNum]);
		break;
	default:
		break;
	}
	for(out_buf_start += 8; out_buf<out_buf_start; out_buf++)
		*out_buf = ' ';
	
	for(arg_ptr=0; arg_ptr<3; arg_ptr++)
	{
		if((arg_ptr!=0) && (cmd->arg[arg_ptr]!=A_NIX) &&
			(((arg_ptr==1) && (cmd->arg[0]!=A_ICC) &&
			 (cmd->arg[0]!=A_FCC)) || arg_ptr!=1))
			buf_printf("%s", ", ");
		switch(cmd->arg[arg_ptr])
		{
		case A_RX:
			buf_printf("R%d", GetR2Num);
			break;
		case A_RY:
			buf_printf("R%d", GetR1Num);
			break;
		case A_RZ:
		case A_RD:
			buf_printf("R%d", GetRdNum);
			break;
		case A_S2:
			if(Command&(1<<14))
				buf_printf("%x", GetI13);
			else
				buf_printf("R%d", GetR1Num);
			break;
		case A_I19:
		case A_SI19:
			buf_printf("%x", GetI19);
			break;
		case A_RI19:
			buf_printf("%x", PC + GetI19);
			break;
		case A_I13:
			buf_printf("%x", GetI13);
			break;
		case A_RL:
		case A_SPEC:
			fprintf(stderr,"Wrong command in internal table = 0x%x\n", 
					Command>>OpcodePos);
			break;
		case A_ICC:
		case A_FCC:
		case A_NIX:
			break;
		}
	}
	return;
}



#ifdef BUILD_TABLE
void init_cmd_table()
{
#define COMMAND(MNE, TYPE, VAL, P1, P2, P3) strcpy(cmd_table[VAL>>25].name, #MNE); cmd_table[VAL>>25].opcode = VAL;	cmd_table[VAL>>25].arg[0] = A_##P1;	cmd_table[VAL>>25].arg[1] = A_##P2;	cmd_table[VAL>>25].arg[2] = A_##P3;
#include "commands.h"
#undef COMMAND
}

int main()
{
	int i;
	
	init_cmd_table();
	for(i=0; i<128; i++)
	{
		if(cmd_table[i].name)
			printf("{\"%s\", 0x%x, {%d, %d, %d}},\n",
				   cmd_table[i].name,
				   cmd_table[i].opcode,
				   cmd_table[i].arg[0],
				   cmd_table[i].arg[1],
				   cmd_table[i].arg[2]);
		else
			printf("{\"\", 0, 0, 0, 0},\n");
	}
	return 0;
}
#endif /* BUILD_TABLE */
