/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

#include "config.h"

static const char sccsid[] = "@(#)core.c	1.3";

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>

#include "processor.h"
#include "simul.h"
#include "glovars.h"
#include "net.h"

const char *VPRegName[] =
{
	"R0",  "R1",  "R2",  "R3",  "R4",  "R5",  "R6",  "R7",
	"R8",  "R9",  "R10", "R11", "R12", "R13", "R14", "R15",
	"R16", "R17", "R18", "R19", "R20", "R21", "R22", "R23",
	"R24", "R25", "R26", "R27", "R28", "R29", "R30", "R31",
	"SR", "BASE", "PROT", "LOG", "LD", "dl_regno", "dl_val"
};

const char *PPRegName[] =
{
	"CT", "MOD", "MOD2", "A", "NR", "ctex"
};

struct GlobalVars
{
	const char *name;
	WORD *val;
}
GlobalVars[] =
{
#define bla(a) {#a, &a},
bla(GlobalMemLen)
bla(PPnum)
bla(VPnum)
bla(KRnum)
bla(ModuloBit)
#undef bla
};

#define COUNT(a) (sizeof(a)/sizeof(*(a)))

short VPReg_Search(const char *name)
{
	short i;
	for(i=0; i<COUNT(VPRegName); i++)
		if(!strcasecmp(name, VPRegName[i]))
			return i;
	if(!strcasecmp(name, "pc"))
		return 1;
	return -1;
}

short PPReg_Search(const char *name)
{
	short i;
	for(i=0; i<COUNT(PPRegName); i++)
		if(!strcasecmp(name, PPRegName[i]))
			return i;
	return -1;
}

void pram_dump_core(const char *fname)
{
	int i, j, vpn, ppn;
	struct vpregs *vp;
	struct ppregs *pp;
	FILE *fp;
	char *fname2 = alloca(strlen(fname)+30);

	printf("dumping core...");
	fflush(stdout);
	sprintf(fname2, "%s.regs", fname);
	fp = fopen(fname2, "w");
	if(!fp)
	{
		fprintf(stderr, "Couldn't open register-core-file %s\n", fname2);
		return;
	}

	for(i=0; i<COUNT(GlobalVars); i++)
		fprintf(fp, "%s %d\n", GlobalVars[i].name, *GlobalVars[i].val);
	for(i=3; i<FILEANZ; i++)
		if(desc[i].opencnt)
		{
			fprintf(fp, "FileDescriptor %d 0x%x %ld %s\n", i,
					desc[i].mode, (long)lseek(desc[i].fd, 0, SEEK_CUR),
					desc[i].name);
		}
	for(ppn=0, pp=PhysicalProcessor; ppn<PPnum; pp++, ppn++)
	{
		fprintf(fp, "PP %d\n", ppn);
		for(i=0; i<COUNT(PPRegName); i++)
			fprintf(fp, "Reg %s %d\n", PPRegName[i], ((WORD *)pp)[i]);
	}
	for(vpn=0, vp=VirtualProcessor; vpn<VPnum*PPnum; vp++, vpn++)
	{
		fprintf(fp, "VP %d\n", vpn);
		for(i=0; i<32; i+=8)
		{
			fprintf(fp, "Reg R%d", i);
			for(j=i; j<i+8; j++)
				fprintf(fp, " %d", vp->R[j]);
			fprintf(fp, "\n");
		}
		for(i=32; i<COUNT(VPRegName); i++)
			fprintf(fp, "Reg %s %d\n", VPRegName[i], vp->R[i]);
		fprintf(fp, "FDP");
		for(i=0; i<LFILEANZ; i++)
		{
			if(ldesc[vpn][i]) fprintf(fp, " %d", ldesc[vpn][i]-desc);
			else fprintf(fp, " -");
		}
		fprintf(fp, "\n");
	}
	fclose(fp);

	sprintf(fname2, "gzip -9 >%s.glbl.gz", fname);
	fp = popen(fname2, "w");
	if(!fp)
	{
		fprintf(stderr, "Couldn't open global-core-file %s\n", fname2);
		return;
	}
	fwrite(GlobalMem, sizeof(WORD), GlobalMemLen, fp);
	pclose(fp);
	printf(" done.\n");
}

#define TS " \n\t"
#define getnum(val) sscanf(strtok(NULL, TS), "%i", &val)

void pram_undump_core(const char *fname)
{
	int i, vpn, ppn;
	struct vpregs *vp = NULL;
	struct ppregs *pp = NULL;
	FILE *fp;
	char *fname2 = alloca(strlen(fname)+30);
	char buf[1000];

	printf("undumping core...");
	fflush(stdout);
	sprintf(fname2, "%s.regs", fname);
	fp = fopen(fname2, "r");
	if(!fp)
	{
		fprintf(stderr, "Couldn't open register-core-file %s\n", fname2);
		return;
	}

	while(fgets(buf, sizeof(buf), fp))
	{
		char *cmd;
		cmd = strtok(buf, TS);
		for(i=0; i<COUNT(GlobalVars); i++)
			if(!strcmp(cmd, GlobalVars[i].name))
			{
				getnum(*GlobalVars[i].val);
				break;
			}
		if(!strcmp(cmd, "FileDescriptor"))
		{
			int fd, mode, fpos;
			char *name;
			getnum(fd);
			getnum(mode);
			getnum(fpos);
			name = strtok(NULL, TS);
			if(!strcmp(name, "-"))
			{
				pram_std_open(fd);
			}
			else
			{
				i = open(name, mode & ~(O_CREAT|O_TRUNC));
				if(i<0)
				{
					fprintf(stderr, "Can't reopen %s\n", name);
				}
				else
				{
					desc[fd].fd = i;
					printf("%d %x %d\n", fd, mode, fpos);
					if(fpos!=lseek(i, fpos, SEEK_SET))
						fprintf(stderr, "Can't lseek to original Position %d in file %s\n", fpos, name);
					strcpy(desc[fd].name, name);
					desc[fd].mode = mode;
					desc[fd].isatty = isatty(fd);
					desc[fd].opencnt = 0;
				}
			}
		}
		else if(!strcmp(cmd, "VP"))
		{
			getnum(vpn);
			vp = VirtualProcessor + vpn;
			pp = NULL;
		}
		else if(!strcmp(cmd, "PP"))
		{
			getnum(ppn);
			pp = PhysicalProcessor + ppn;
			vp = NULL;
		}
		else if(!strcmp(cmd, "Reg"))
		{
			cmd = strtok(NULL, TS);
			if(pp)
			{
				for(i=0; i<COUNT(PPRegName); i++)
					if(!strcmp(PPRegName[i], cmd)) break;
				while(i<COUNT(PPRegName) && (cmd=strtok(NULL, TS)))
					sscanf(cmd, "%i", &((WORD *)pp)[i++]);
			}
			if(vp)
			{
				for(i=0; i<COUNT(VPRegName); i++)
					if(!strcmp(VPRegName[i], cmd)) break;
				while(i<COUNT(VPRegName) && (cmd=strtok(NULL, TS)))
					sscanf(cmd, "%i", &vp->R[i++]);
			}
		}
		else if(!strcmp(cmd, "FDP"))
		{
			for(i=0; i<LFILEANZ; i++)
			{
				char *s;
				int j;
				s = strtok(NULL, TS);
				if(!strcmp("-", s))
				{
					ldesc[vpn][i] = NULL;
				}
				else
				{
					sscanf(s, "%i", &j);
					ldesc[vpn][i] = &desc[j];
					desc[j].opencnt++;
				}
			}
		}
	}
	fclose(fp);

	sprintf(fname2, "gzip -d <%s.glbl.gz", fname);
	fp = popen(fname2, "r");
	if(!fp)
	{
		fprintf(stderr, "Couldn't open global-core-file %s\n", fname2);
		return;
	}
	fread(GlobalMem, sizeof(WORD), GlobalMemLen, fp);
	pclose(fp);
	printf(" done.\n");
}
