/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

static const char sccsid[] = "@(#) bench.c 1.12@(#)";

#include "processor.h"
#include "glovars.h"
#include "simul.h"

#include <sys/time.h>
#include <sys/resource.h>

#define MAX_ROUNDS 5000000

void BenchmarkSimulator()
{
	int pc_ptr, rounds; 
	struct rusage usage_start, usage_end;
	struct vpregs *test_vp;
	extern struct CmdVektor cmd_table[];
	
	test_vp = VirtualProcessor;

	for(pc_ptr=0; pc_ptr<ProgramMemLen && !break_flags; pc_ptr++)
	{
		rounds=0;
		test_vp->R[1]=0;
		
		getrusage(RUSAGE_SELF, &usage_start);
		while(rounds++<MAX_ROUNDS)
		{
			test_vp->R[1]=pc_ptr;
			test_vp->SR=0;
			SimulateNStepsFast(test_vp, 1, 0);
		}
		getrusage(RUSAGE_SELF, &usage_end);
		if(test_vp->R[1]!=-1)
		{
			TimeCounter[pc_ptr] =
				(usage_end.ru_utime.tv_sec - 
				 usage_start.ru_utime.tv_sec) * 1000 +
					 (usage_end.ru_utime.tv_usec - 
					  usage_start.ru_utime.tv_usec) / 1000;
			printf("Usage of %-8s= 0x%x: %d msecs\n",
				   cmd_table[ProgramMem[pc_ptr]>>25].name,
				   ProgramMem[pc_ptr], TimeCounter[pc_ptr]);
		}
		else
		{
			/* Warning? */
		}
		
		
	}
}
