/* FILE:        coff.h
   DESCRIPTION: defines for coff.c
   AUTHOR:      Stefan Franziskus
   DATE:        DEC 14, 1993
*/

#define STYP_REG         (0x0000)       /* "regular": allocated, relocated, loaded */
#define STYP_DSECT       (0x0001)       /* "dummy":  relocated only*/
#define STYP_NOLOAD      (0x0002)       /* "noload": allocated, relocated, not loaded */
#define STYP_GROUP       (0x0004)       /* "grouped": formed of input sections */
#define STYP_PAD         (0x0008)       /* "padding": not allocated, not relocated, loaded */
#define STYP_COPY        (0x0010)       /* "copy": for decision function used by field update;  not allocated, not relocated,
                                                                             loaded; reloc & lineno entries processed normally */
#define STYP_TEXT        (0x0020)       /* section contains text only */
#define S_SHRSEG         (0x0020)       /* In 3b Update files (output of ogen), sections which appear in SHARED segments of the Pfile
                                                                             will have the S_SHRSEG flag set by ogen, to inform dufr that updating 1 copy of the proc. will
                                                                             update all process invocations. */
#define STYP_DATA        (0x0040)       /* section contains data only */
#define STYP_BSS         (0x0080)       /* section contains bss only */
#define S_NEWFCN         (0x0100)       /* In a minimal file or an update file, a new function (as compared with a replaced function) */

#define STYP_INFO        (0x0200)       /* comment: not allocated not relocated, not loaded */
#define STYP_OVER        (0x0400)       /* overlay: relocated not allocated or loaded */
#define STYP_LIB         (0x0800)       /* for .lib: same as INFO */
#define STYP_MERGE       (0x2000)       /* merge section -- combines with text, data or bss sections only */
#define STYP_REVERSE_PAD (0x4000)       /* section will be padded with no-op instructions wherever padding is necessary and there is a

                                                                             word of contiguous bytes
                                                                             beginning on a word boundary. */

#define STYP_LIT        0x8020  /* Literal data (like STYP_TEXT) */


struct filehdr
{
	unsigned short    f_magic;      /* magic number */
	unsigned short    f_nscns;      /* number of sections */
	long              f_timdat;     /* time & date stamp */
	long              f_symptr;     /* file pointer to symtab */
	long              f_nsyms;      /* number of symtab entries */
	unsigned short    f_opthdr;     /* sizeof(optional hdr) */
	unsigned short    f_flags;      /* flags */
};

#define   FILHDR  struct filehdr
#define   FILHSZ  20

/* Bits for f_flags:
 *      F_RELFLG        relocation info stripped from file
 *      F_EXEC          file is executable (no unresolved external references)
 *      F_LNNO          line numbers stripped from file
 *      F_LSYMS         local symbols stripped from file
 *      F_AR16WR        file is 16-bit little-endian
 *      F_AR32WR        file is 32-bit little-endian
 *      F_AR32W         file is 32-bit big-endian
 *      F_DYNLOAD       rs/6000 aix: dynamically loadable w/imports & exports
 *      F_SHROBJ        rs/6000 aix: file is a shared object
 */

#define F_RELFLG        (0x0001)
#define F_EXEC          (0x0002)
#define F_LNNO          (0x0004)
#define F_LSYMS         (0x0008)
#define F_AR16WR        (0x0080)
#define F_AR32WR        (0x0100)
#define F_AR32W         (0x0200)
#define F_DYNLOAD       (0x1000)
#define F_SHROBJ        (0x2000)

struct aouthdr
{
	short             magic;        /* magic number */
	short             vstamp;       /* version stamp */
	long              tsize;        /* text size in bytes */
	long              dsize;       /* initialized data size */
	long              bsize;        /* uninitialized data size */
	long              entry;        /* entry point */
	long              text_start;   /* base of text used for this file */
	long              data_start;   /* base of data used for this file */
}; 

#define AOUTHDR struct aouthdr
#define AOUTHSZ 28

struct scnhdr
{
	char              s_name[8];    /* section name */
	long              s_paddr;      /* physical address */
	long              s_vaddr;      /* virtual address */
	long              s_size;       /* section size */
	long              s_scnptr;     /* file ptr to raw data for section */
	long              s_relptr;     /* file ptr to relocation */
	long              s_lnnoptr;    /* file ptr to line numbers */
	unsigned short    s_nreloc;     /* number of relocation entries */
	unsigned short    s_nlnno;      /* number of line number entries */
	long              s_flags;      /* type and content flags */
};

#define SCNHSZ 40

/********************** STORAGE CLASSES **********************/

/* This used to be defined as -1, but now n_sclass is unsigned.  */
#define C_EFCN          0xff    /* physical end of function     */
#define C_NULL          0
#define C_AUTO          1       /* automatic variable           */
#define C_EXT           2       /* external symbol              */
#define C_STAT          3       /* static                       */
#define C_REG           4       /* register variable            */
#define C_EXTDEF        5       /* external definition          */
#define C_LABEL         6       /* label                        */
#define C_ULABEL        7       /* undefined label              */
#define C_MOS           8       /* member of structure          */
#define C_ARG           9       /* function argument            */
#define C_STRTAG        10      /* structure tag                */
#define C_MOU           11      /* member of union              */
#define C_UNTAG         12      /* union tag                    */
#define C_TPDEF         13      /* type definition              */
#define C_USTATIC       14      /* undefined static             */
#define C_ENTAG         15      /* enumeration tag              */
#define C_MOE           16      /* member of enumeration        */
#define C_REGPARM       17      /* register parameter           */
#define C_FIELD         18      /* bit field                    */
#define C_AUTOARG       19      /* auto argument                */
#define C_LASTENT       20      /* dummy entry (end of block)   */
#define C_BLOCK         100     /* ".bb" or ".eb"               */
#define C_FCN           101     /* ".bf" or ".ef"               */
#define C_EOS           102     /* end of structure             */
#define C_FILE          103     /* file name                    */
#define C_LINE          104     /* line # reformatted as symbol table entry */
#define C_ALIAS         105     /* duplicate tag                */
#define C_HIDDEN        106     /* ext symbol in dmert public lib */


#define SCNHDR struct scnhdr
#define SCNHZS sizeof(SCNHDR)
#define COFF_BLK_SIZE 128

struct reloc
{
	long                   r_vaddr;      /* address of reference */
	long                   r_symndx;     /* index into symbol table */
	unsigned long          r_offset;
	unsigned short         r_type;       /* relocation type */
	short                  r_stuff;
	struct syment          *r_syment;
};
#define RELOC_SIZE 16

struct lnno 
{
  union 
  {
    int l_symndx;    /* function name symbol index, iff l_lnno == 0*/
    int l_paddr;     /* (physical) address of line number    */
  } l_addr;
  int l_lnno;          /* line number          */
};
#define LNNO_SIZE  8

/* Funny relocation types and other stuff */

#define R_13REL    0x01
#define R_13ABS    0x02
#define R_19REL    0x04
#define R_19ABS    0x08
#define R_32DAT    0x10

#define REL_MASK13 0xFFFF1000
#define REL_MASK19 0xFFF00000
#define SYMMLEN    8

struct syment
{
	union
	{
		char _n_name[SYMMLEN];           /* Symbol name */
		struct                           /* if _n_name[0-3] == 0 */
		{
			long _n_zeroes;              /* then _n_name [4-7] is an */
			long _n_offset;              /* offset into string table */
		} _n_n;
		char *_n_ptr[2];                 /* allows for overlaying */
	} _n;
	long              n_value;           /* value of symbol */
	short             n_scnum;           /* section number */
	unsigned short    n_type;            /* type and derived type */
	char              n_sclass;          /* storage class */
	char              n_numaux;          /* number of aux. entries */
	int		  value;
	char		  *name;             /* Zeiger auf namen (entweder _n_name oder strtbl) */
};

#define n_name    _n._n_name
#define n_ptr     _n._n_nptr[1]
#define n_zeroes  _n._n_n._n_zeroes
#define n_offset  _n._n_n._n_offset
#define SYMENT_SIZE 18

