/* -*-mb0-c-*- */

char *infilename="default", *outfilename;   /* names of files */
int debugflag=0;
int textstart=0, datastart=0;
int message_key;

#ifdef EXPORT

char *loaderrc="/local/fork/fork/lib/ldrc.fork\0";

#else /* if stefran */

char *loaderrc=".ldrc\0";

#endif /* EXPORT */

char **sbp_argv;
int sbp_argc=1, sbp_arglen=3;
unsigned options;

int ldvalue_set(int num, char *arg[]);

#define OPT_HOST_COM 0x1
#define OPT_SYSV_MSG 0x2
#define OPT_FORKDEBUG 0x4
#define OPT_PRAMSIM 0x8

struct option_desc command_opt[]=
{
    {'h', "help",         O_HELP, {},        ""},
	{'o', "outfile",      I_STRING(outfilename),
          "Name of the output file"},
	{'D', "debugflags",   I_INT(&debugflag),
          "debugflags"},
	{'t', "textstart",    I_INT(&textstart),
          "Start of the text-section in the program memory"},
	{'d', "datastart",    I_INT(&datastart),
          "Start of the data-sections in the global memory"},
	{'l', "loaderrc",     I_STRING(loaderrc),
		  "name and path of loaderrc"},
	{'L', "ldvalue",      I_FUNCTION(ldvalue_set),
          "Set a new value in lddata"},
    {'F', "forkdebug",    I_FLAG(OPT_FORKDEBUG),
		  "Omit directives for the Fork Simulator/Debugger"},
    {' ', "host-com",     I_FLAG(OPT_HOST_COM),
		  "Communicate with the SB-PRAM-Host"},
    {' ', "host-msg-key", I_INT(&message_key),
		  "Descriptor for the message queue"},
	{'V', "version",      I_FUNCTION(print_version),
          "Print the current version"},
	{' ', "sysv-messages", I_FLAG(OPT_SYSV_MSG),
		  "Use System V Messages instead of shared Memory"},
};

int command_opt_len = (sizeof(command_opt)/sizeof(*command_opt));

struct environ_desc environ_opt[]=
{
	{"SBP_LOADERRC",      &loaderrc},
};

int environ_opt_len = (sizeof(environ_opt)/sizeof(*environ_opt));

