/* -*-mb0-c-*- */
/* 
  FILE:        loader.c
  DESCRIPTION: loader for coff-files
  AUTHOR:      Stefan Franziskus
  DATE:        JAN 15, 1993
*/

#include "define.h"
#include "loader.h"
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<sys/wait.h>
#include"coff.h"
#include <unistd.h>
#include "init.h"
#include "loaderinit.h"

#ifdef HOST
int _mptr_, dev_pram, *GlobalMem;
#endif

#ifdef HOST
#ifndef LOADER
#define LOADER
#endif
#include "../host/shmem_com.h"
#include "../host/communication.h"
#endif

char version[]="Version 0.8 (c) 1994 by stefran@cs.uni-sb.de";

FILE *infile, *outfile, *dumpfile, *configfile;     /* corresp. file descr */

int quietflag;

struct section *sct;           /* Sectionliste */
struct section *sct_beg;       /* Pointer auf Anfang der Sectionliste */
struct syment_blk *symtab;
struct syment_blk *symtab_beg;
struct filehdr file_head;
struct aouthdr aout_head;
int p_addr[10], v_addr[10];
int p_size[10];

struct lditem ld_data[20];
struct lditem *ldptr = ld_data;

int filenr;
extern int dev_prog, dev_pram;
extern char *section_mem[];			

void print_version()
{
	printf("%s\n", version);
	exit(0);
}

int ldvalue_set(int num, char *arg[])
{
	int i=0;
	
/*	if(num<2)
		errexit("Wrong Arguments"); */
	
	while(ld_data[i].name != NULL)
	{
		if(!strcmp(ld_data[i].name, arg[1]))
		{
			sscanf(arg[2], "%i", &ld_data[i].value);
			return(2);
		}
		i++;
	}

	return(2);
}

#define OP_GET 1
#define OP_PUT 2
#define get_size(name) lddata_size(OP_GET, name, 0)
#define put_size(name, val) lddata_size(OP_PUT, name, val)
inline int lddata_size(int op, char *name, int value)
{
	int i=0;
	while(ld_data[i].name != NULL)
	{
		if(!strcmp(ld_data[i].name, name))
			if(op==OP_GET)
				return(ld_data[i].value);
			else if(op==OP_PUT)
			{
				ld_data[i].value = value;
				return(0);
			}
		i++;
	}
	return(-1);
}

inline int get_typesize(char type)
{
	int i=0, size=0;
	while(ld_data[i].name != NULL)
	{
		if(ld_data[i].type == type)
			size += ld_data[i].value;
		i++;
	}
	return(size);
}

inline int get_section_size(int type)
{
	int size=0;
	
	sct=sct_beg;
	
	while(sct!=NULL)
	{
		if(type == SBP_SHARED || type == SBP_PRIVATE)
		{
			if(sct->sbp_flags == type)
				size += sct->head.s_size/4;
		}
		else if(sct->head.s_flags == STYP_TEXT)
			size += sct->head.s_size/4;
		sct = sct->next;
	}
	return(size);
}

int get_textsize()
{
	int i=0;
	char sct_name[8];
	int textsize=0;
	
	fseek(infile, 0, 0);
	fread(&file_head.f_magic, sizeof(short), 2, infile);
	fread(&file_head.f_timdat, sizeof(long), 3, infile);
	fread(&file_head.f_opthdr, sizeof(short), 2, infile);
	
	fread(&aout_head.magic, sizeof(short), 2, infile);
	fread(&aout_head.tsize, sizeof(long), 6, infile);

	sct=sct_beg;
	
	fseek(infile, FILHSZ + file_head.f_opthdr, 0);
	*sct_name=(char)"";
	i=0;
	
	while(i<file_head.f_nscns && strcmp(sct_name,".text"))
	{
		fread(sct_name, sizeof(char), 8, infile);
		fseek(infile, SCNHSZ-8, 1);
		i++;
	}
	
	if(!strcmp(sct_name,".text"))
	{
		fseek(infile, 16-SCNHSZ, 1);
		fread(&textsize, sizeof(long), 1, infile);
	}
	
	return(textsize/4);	
}

void scan_coff_file()
{
	int i=0;
	long block_ptr;
	char sct_name[8];

	fseek(infile,0,0);
	fread(&file_head.f_magic, sizeof(short), 2, infile);
	fread(&file_head.f_timdat, sizeof(long), 3, infile);
	fread(&file_head.f_opthdr, sizeof(short), 2, infile);
	
	fread(&aout_head.magic, sizeof(short), 2, infile);
	fread(&aout_head.tsize, sizeof(long), 6, infile);

	if(debugflag==1)
	{
	    printf("f_magic  %x\n",file_head.f_magic);
	    printf("f_nscns  %x\n",file_head.f_nscns);
	    printf("f_timdat %lx\n",file_head.f_timdat);
	    printf("f_symptr %lx\n",file_head.f_symptr);
	    printf("f_nsyms  %lx\n",file_head.f_nsyms);
	    printf("f_opthdr %x\n",file_head.f_opthdr);
	    printf("f_flags  %x\n",file_head.f_flags);
	    printf("\n");
	
	    printf("magic   %x\n",aout_head.magic);
	    printf("vstamp  %x\n",aout_head.vstamp);
	    printf("tsize   %lx\n",aout_head.tsize);
	    printf("dsize   %lx\n",aout_head.dsize);
	    printf("bsize   %lx\n",aout_head.bsize);
	    printf("entry   %lx\n",aout_head.entry);
	    printf("text_st %lx\n",aout_head.text_start);
	    printf("data_st %lx\n",aout_head.data_start);
	    printf("\n");
	}
	
	sct=sct_beg;
	
	while(sct!=NULL)
	{
		fseek(infile, FILHSZ + file_head.f_opthdr, 0);
		*sct_name=(char)"";
		i=0;
		
		while(i<file_head.f_nscns && strcmp(sct_name,sct->head.s_name))
		{
			fread(sct_name, sizeof(char), 8, infile);
			fseek(infile, SCNHSZ-8, 1);
			i++;
		}

		if(!strcmp(sct_name,sct->head.s_name))
		{
			fseek(infile, 16-SCNHSZ, 1);
			fread(&sct->head.s_size, sizeof(long), 1, infile);
			fread(&sct->head.s_scnptr, sizeof(long), 1, infile);
			fread(&sct->head.s_relptr, sizeof(long), 1, infile);
			fread(&sct->head.s_lnnoptr, sizeof(long), 1, infile);
			fread(&sct->head.s_nreloc, sizeof(short), 2, infile);
			fread(&sct->head.s_flags, sizeof(long), 1, infile);
		}
		
		fseek(infile, sct->head.s_relptr,0);
		
		sct->relocate=malloc(sizeof(struct reloc_data));
		sct->reloc_start=sct->relocate;
		for(block_ptr=0;block_ptr<sct->head.s_nreloc;block_ptr++)
		{
			fread(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_vaddr, sizeof(long), 3, infile);
			fread(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_type, sizeof(short), 2, infile);
			
			if (block_ptr % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
			{
				sct->relocate->next=malloc(sizeof(struct reloc_data));
				sct->relocate=sct->relocate->next;
				sct->relocate->next=NULL;
			}
		}
		
		IFOPT(OPT_FORKDEBUG)
		{
			sct->lnno = malloc(COFF_BLK_SIZE * sizeof(struct lineno));
			fseek(infile, sct->head.s_lnnoptr,0);
			for(block_ptr=0;block_ptr<sct->head.s_nreloc;block_ptr++)
			{
				fread(&sct->lnno[block_ptr].l_addr.l_symndx, 
					  sizeof(long), 2, infile);
				if (block_ptr % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
					sct->lnno = realloc(sct->lnno, 
										(block_ptr + COFF_BLK_SIZE) 
										* sizeof(struct lineno));
			}
		}
		
		if(!strcmp(sct_name,".args") && !strcmp(sct->head.s_name,".args"))
			sct->head.s_size=sbp_arglen*4;
		
		sct=sct->next;
	}
	
	fseek(infile, file_head.f_symptr, 0);
	symtab=malloc(sizeof(struct syment_blk));
	symtab_beg=symtab;	
	for(block_ptr=0;block_ptr<file_head.f_nsyms;block_ptr++)
	{
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE]._n._n_name, sizeof(char), 8, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_value, sizeof(long), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_scnum, sizeof(short), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_type, sizeof(short), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_sclass, sizeof(char), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_numaux, sizeof(char), 1, infile);
		symtab->entry[block_ptr % COFF_BLK_SIZE].n_value/=sizeof(long);
		
		if (block_ptr % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
		{
			symtab->next=malloc(sizeof(struct syment_blk));
			symtab=symtab->next;
			symtab->next=NULL;
		}
	}
}

int set_startoffsets()
{
	int i=0, j=0;
	char sct_name[8];

	int start[4], org[4]={0,0,0,0}, orgstart[4]={0,0,0,0};
	int mem_num;

	sct=sct_beg;
	start[0]=datastart;
	start[1]=0;
		
	while(sct!=NULL)
	{
		fseek(infile, FILHSZ + file_head.f_opthdr, 0);
		*sct_name=(char)"";
		i=0;
		
		while(i<file_head.f_nscns && strcmp(sct_name,sct->head.s_name))
		{
			fread(sct_name, sizeof(char), 8, infile);
			fseek(infile, SCNHSZ-8, 1);
			i++;
		}
		
		if(!strcmp(sct_name,sct->head.s_name))
		{
			if(sct->head.s_flags==STYP_TEXT)
			{
				sct->head.s_paddr=sct->head.s_vaddr=textstart;
				j=0;
				while(ld_data[j].name != NULL)
				{
					if(!strcmp(ld_data[j].name, "textlen"))
						ld_data[j].value = sct->head.s_size/sizeof(long);
					j++;
				}
			}
			else
			{
				mem_num = sct->m_num;
				if(sct->head.s_paddr==-1)
				{
					start[mem_num]=0;
					sct->head.s_paddr=0;
					sct->head.s_vaddr=0;
				}
				if(sct->head.s_paddr==0)
				{
					org[mem_num]=0;
					sct->head.s_paddr=sct->head.s_vaddr=start[mem_num];
					start[mem_num]+=sct->head.s_size/4;
				}
				else
				{
					if(orgstart[mem_num]!=sct->head.s_vaddr)
					{
						orgstart[mem_num]=sct->head.s_vaddr;
						org[mem_num]=orgstart[mem_num];
					}
					sct->head.s_paddr=start[mem_num];
					sct->head.s_vaddr=org[mem_num];
					start[mem_num]+=sct->head.s_size/4;
					org[mem_num]+=sct->head.s_size/4;
				}
			}
			v_addr[i-1]=sct->head.s_vaddr;
		}
		sct=sct->next;
	}
	return(0);
}

inline void get_dbg(long dbgptr, struct lineno **l_lnno)
{
	**l_lnno = sct->lnno[dbgptr];
}

inline void get_reloc(long rel_ptr, struct reloc **l_rel)
{
	if ((rel_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
		sct->relocate=sct->relocate->next;
  
	**l_rel=sct->relocate->reloc_item[rel_ptr % COFF_BLK_SIZE];
	
	if(debugflag==1)
    {
		printf("Adresse     : %lx\n",(*l_rel)->r_vaddr);
		printf("Offset      : %lx\n",(*l_rel)->r_offset);
		printf("Symtabeintr : %lx\n",(*l_rel)->r_symndx);
		printf("Typ         : %x\n",(*l_rel)->r_type);
		printf("Stuff       : %x\n\n",(*l_rel)->r_stuff);
    }	
}

inline void get_symtab(long s_index, struct syment **l_sym)
{
	symtab=symtab_beg;
	while (s_index  >= COFF_BLK_SIZE)
	{
		symtab=symtab->next;
		s_index=s_index-COFF_BLK_SIZE;
	}
	**l_sym=symtab->entry[s_index % COFF_BLK_SIZE];
}

void do_relocation()
{
	long relptr=0, dbgptr=0;
	long sct_ptr;
	struct reloc *load_rel;
	struct syment *load_sym, *load_sym2;
	struct lineno *load_dbg;

	long rel_mask=0xffffffff;
	long sign_mask=0x0;
	long rel_value;
	long sct_long;
	int host_blk[BUFSIZE];
	int i=0, j;
	char *src;
	struct section *sct_p;
	struct lditem *ld_ptr;
	
	ld_ptr = ld_data;
	
	load_rel=malloc(sizeof(struct reloc));
	load_sym=malloc(sizeof(struct syment));
	fseek(infile, FILHSZ + file_head.f_opthdr + SCNHSZ*file_head.f_nscns, 0);

	sct=sct_beg;	
	symtab=symtab_beg;
	
	while(sct!=NULL)
	{
		sct_ptr=0;
		relptr=0;
		sct->relocate=sct->reloc_start;
		switch(sct->head.s_flags)
		{
		case STYP_TEXT:   

			fprintf(dumpfile,".CODE\n");
			fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
			break;
		case STYP_DATA:
			if(!strcmp(sct->head.s_name,".lsdata") ||\
			   !strcmp(sct->head.s_name,".lpdata") ||\
			   !strcmp(sct->head.s_name,".LDATA"))
			{
				fprintf(dumpfile,"%s\n",".LDATA");
				fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
			}
			else
			{
				fprintf(dumpfile,"%s\n",".GDATA");
				fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
			}
			break;
		case STYP_BSS:
			if(!strcmp(sct->head.s_name,".lddata"))
			{
				fprintf(dumpfile,"%s\n",".GDATA");
				fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
				while(ld_ptr->name != NULL)
					fprintf(dumpfile,"0x%x\n", ld_ptr++->value);
				sct_p=sct;
				while(sct_p!=NULL)
				{
					fprintf(dumpfile,"0x%x\n",
							(int)sct_p->head.s_size/sizeof(long));
					sct_p=sct_p->next;
				}
			}

		default:
			break;
		}
		
		if(sct->head.s_flags!=STYP_BSS && strcmp(sct->head.s_name, ".args"))
		{
			fseek(infile, sct->head.s_scnptr, 0);
			if(sct->head.s_nreloc>0)
			{		
				get_reloc(relptr, &load_rel);
				get_symtab(load_rel->r_symndx, &load_sym);
				relptr++;
				IFOPT(OPT_FORKDEBUG)
					if(sct->head.s_flags==STYP_TEXT)
					{
						do
							get_dbg(dbgptr, &load_dbg);
						while(load_dbg->l_lnno!=0);
						
						get_symtab(load_dbg->l_addr.l_symndx, &load_sym2);
						relptr++;
					}
			}
			i=0;
			while(sct_ptr<(sct->head.s_size/sizeof(long)))
			{
				fread(&sct_long, sizeof(long), 1, infile);
				if(sct_ptr==load_rel->r_vaddr && relptr <= sct->head.s_nreloc \
				   && sct->head.s_nreloc>0 )
				{
				/*	rel_value=load_sym->n_value+load_rel->r_offset;  */
					rel_value=load_rel->r_offset;
					switch(load_rel->r_type)
					{
					case R_13ABS:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_mask=REL_MASK13;
						sign_mask=SIGN_13;
						break;
					case R_13REL:
						rel_value-=sct_ptr;
						rel_mask=REL_MASK13<<1;
						sign_mask=0x0;
						break;
					case R_19ABS:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_mask=REL_MASK19;
						sign_mask=SIGN_19;
						break;
					case R_19REL:
						rel_value-=sct_ptr;
						rel_mask=REL_MASK19<<1;
						sign_mask=0x0;
						break;
					case R_GETHI:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_value>>=13;
						rel_mask=REL_MASK19;
						sign_mask=SIGN_19;
						break;
					case R_32DAT:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_mask=REL_MASK32;
						sign_mask=0x0;
						break;
					default:
						break;
					}

					sct_long=((sct_long & rel_mask & ~sign_mask) | 
							  (rel_value & ~rel_mask));
					
					get_reloc(relptr, &load_rel);
					get_symtab(load_rel->r_symndx, &load_sym);
					relptr++;
				}

				fprintf(dumpfile,"0x%lx\n",sct_long);

				IFOPT(OPT_FORKDEBUG)
					if(sct->head.s_flags==STYP_TEXT && 
					   sct_ptr==load_sym2->n_value && 
					   dbgptr <= sct->head.s_nlnno && sct->head.s_nlnno>0 )
					{
						if(!strncmp(load_sym2->n_name, "IBP", 3)
						   && load_sym2->n_sclass == C_LINE)
							fprintf(dumpfile,"%s\n", load_sym2->n_name);
						
						do
							get_dbg(dbgptr, &load_dbg);
						while(load_dbg->l_lnno!=0);

						get_symtab(load_dbg->l_addr.l_symndx, &load_sym2);
						dbgptr++;
					}
				
				sct_ptr++;
			}
		}
		if(!strcmp(sct->head.s_name, ".args") && (sct->head.s_size !=0))
		{
			fprintf(dumpfile,"%s\n",".GDATA");
			fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);

			host_blk[0]=sbp_argc;
			host_blk[1]=sct->head.s_vaddr+3;
			host_blk[2]=sct->head.s_vaddr+sbp_arglen;
			host_blk[3]=host_blk[1]+sbp_argc;
			for(i=0;i<sbp_argc-1;i++)
				host_blk[i+4]=host_blk[i+3]+strlen(sbp_argv[i])+1;
			src=sbp_argv[0];
			i+=4;
			sbp_arglen-=i;
			while(src-sbp_argv[0]<sbp_arglen)
			{
				if(i<BUFSIZE)
					host_blk[i++]=*src++;
				else
				{
					for(i=0;i<BUFSIZE;i++)
						fprintf(dumpfile,"0x%x\n",host_blk[i]);
					i=0;
					host_blk[i++]=*src++;
				}
			}
			for(j=0;j<i;j++)
				fprintf(dumpfile,"0x%x\n",host_blk[j]);
			i=0;
		}
		sct=sct->next;
	}
}

#ifdef HOST
void communicate_host(int ret)
{
	int message_buffer[256];
	
	attach_queue(message_key, 1);
	message_buffer[0] = ret;
	if(ret<0)
	{
		send_msg(message_key, (char *)message_buffer, 1*sizeof(int));
		exit(0);
	}
	else
	{
		message_buffer[1] = get_section_size(0);
		put_size("textlen", message_buffer[1]);       /* Wozu ???? */
		message_buffer[2] = get_typesize(LD_PRIVATE) * get_typesize(LD_NUM)
			+ get_typesize(LD_SHARED)
			+ get_section_size(SBP_PRIVATE) * get_typesize(LD_NUM)
			+ get_section_size(SBP_SHARED)
		    + 515 * get_typesize(LD_NUM) + 1000;      /* istacksize ### */
		message_buffer[3] = get_typesize(LD_NUM);
	}
	send_msg(message_key, (char *)message_buffer, 4*sizeof(int));
	receive_msg(message_key, (char *)message_buffer);
	textstart = message_buffer[1];
	datastart = message_buffer[2];
	put_size("vpmask", message_buffer[3]);
}
#endif

int ld_data_calculate()
{
	int i=0;
	int gmem_size;
	
	while(strcmp(ld_data[i].name, "sheap"))
		i++;
	gmem_size = get_typesize(LD_PRIVATE) * get_typesize(LD_NUM)
		    + get_typesize(LD_SHARED)
			+ get_section_size(SBP_PRIVATE) * get_typesize(LD_NUM)
			+ get_section_size(SBP_SHARED)
			+ 515 * get_typesize(LD_NUM);      /* istacksize ### */
	ld_data[i].value = gmem_size;
	return 0;
}

void emit_memsize()
{
  int ProgramMemLen, GlobalMemLen;
  
  ProgramMemLen = textstart + get_section_size(0);

  GlobalMemLen = datastart + get_typesize(LD_PRIVATE) * get_typesize(LD_NUM)
	+ get_typesize(LD_SHARED)
	+ get_section_size(SBP_PRIVATE) * get_typesize(LD_NUM)
	+ get_section_size(SBP_SHARED)
	+ 515 * get_typesize(LD_NUM) + 1000;      /* istacksize ### */

  fprintf(dumpfile,".CODE\n");
  fprintf(dumpfile,".ORIGIN 0x%x\n", ProgramMemLen);
  fprintf(dumpfile,".GDATA\n");
  fprintf(dumpfile,".ORIGIN 0x%x\n", GlobalMemLen);
}


int main(int argc, char *argv[])
{
	int ret, i;

	get_environment();

	for(i=0;i<10;i++) p_addr[i]=0;
	if((configfile=fopen(".ldrc", "r"))==NULL)
	    configfile=fopen(loaderrc,"r");
	if(configfile==NULL)
	{
	    fprintf(stderr,"Warning couldn't open loaderrc %s\n", loaderrc);
		exit(1);
	}
	else
	    get_mem_values();

	eval_params(argc,argv);

	if(!(infile=fopen(infilename,"r")))
	{
	    printf("Error, couldn't open inputfile: %s\n", infilename);
#ifndef HOST
		exit(-1);
#else
		ret = -1;
#endif
	}
	dumpfile=fopen(outfilename,"w");

	if(ret!=-1)
		scan_coff_file();
		
#ifdef HOST	
	IFOPT(OPT_HOST_COM)
		communicate_host(ret);
#endif

	emit_memsize();
	ld_data_calculate();
	
	set_startoffsets();
	do_relocation();
	fclose(dumpfile);
	sync();
	
#ifdef HOST	
	IFOPT(OPT_HOST_COM)
		send_msg(message_key, argv[0], 1);
#endif
	
	return(0);
}
