/* -*-mb0-c-*- */
/********************************************
*                                           *
*           The PRAM-to-Host Interface      *
*         (c) 1994 by Stefan Franziskus     *
*                   Version 0.1             *
*                                           *
*********************************************/

struct variable
{
	char **string_val;
	int *int_val;
};

struct option_desc
{
    char short_opt;
    char *long_opt;
    int type;
    union val
    {
        int *int_val;
        char **string_val;
        int flags;
        int (*function)(int, char **);
		struct variable var;
    } val;
    const char *comment;
};

enum option_types{O_INT, O_STRING, O_FLAG, O_FUNCTION, O_HELP, O_IGNORE};
#ifdef SERVER
enum option_classes{C_ALL, C_SERVER, C_CHILD};
#endif

#define I_INT(a) O_INT, {int_val: (a)}
#define I_STRING(a) O_STRING, {string_val: &(a)}
#define I_FLAG(a) O_FLAG, {flags: (a)}
#define I_FUNCTION(a) O_FUNCTION, {function: (a)}
#define I_IGNORE(a) O_IGNORE, {int_val: (a)}

#define STDINCODE "--"

#define IFOPT(a) if(options & (a))

struct environ_desc
{
    char *env_name;
    char **env_value;
};

extern char **environ;

int eval_params(int argc, char *argv[]);
void get_environment(void);
