/* -*-mb0-c-*- */
#include"define.h"
#include "init.h"
#include "loader.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdarg.h>
#include "coff.h"

extern char *infilename;   /* Namen fuer Ausgabefile ohne suffix */
extern char *outfilename;   /* Namen fuer Ausgabefile ohne suffix */

extern FILE *infile, *outfile, *dumpfile, *configfile;
extern long p_addr[10];
extern char *loaderrc;

extern struct section *sct;           /* Sectionliste */
extern struct section *sct_beg;       /* Pointer auf Anfang der S.liste */
extern struct lditem ld_data[];

#define strget if((ld_entry = strtok(NULL, "\t \n")) == NULL) \
                 { if((success=fgets(string, 512, configfile))==NULL) break;\
						 ld_entry = strtok(string , "\t \n"); }

extern int sbp_arglen, sbp_argc;
extern char **sbp_argv;
extern int options;

void free_sct(struct section *sct)
{
    if(sct->next!=NULL)
		free_sct(sct->next);
	else
		free(sct);
}

void get_mem_values()
{
	char *ld_entry;
	char *success;
	int org=0;
	int orgflag=0;
	int mem_num=0;
	char string[512];
	struct lditem *ld_ptr;
	
	ld_ptr = ld_data;
	if(sct!=NULL)
		free_sct(sct);

	sct=malloc(sizeof(struct section));
	sct->next=NULL;
	sct_beg=sct;
	strcpy(sct->head.s_name,".text");
	
	ld_entry=malloc(20*sizeof(char));
	
	success=fgets(string, 512, configfile);
	ld_entry = strtok(string , "\t \n");
	while(success!=NULL && ld_entry!=NULL)
	{
		if(!strcmp(ld_entry, "sctdata"))
		{
			strget;
			while(strcmp(ld_entry, "{") && success!=NULL) strget;
			strget;
			while(strcmp(ld_entry, "}") && success!=NULL)
			{
				if(!strcmp(ld_entry, "org"))
				{
					strget;
					if(!strcmp(ld_entry, "new"))
						orgflag=-1;
					else
						if(!strcmp(ld_entry, "*"))
							orgflag=0;
						else
						{
							sscanf(ld_entry,"%i",&org);
							orgflag=1;
						}
					strget;
				}
				
				if(success && strlen(ld_entry)>0)
				{
					sct->next=malloc(sizeof(struct section));
					sct=sct->next;
					sct->next=NULL;
					strcpy(sct->head.s_name, ld_entry);
					sct->m_num = mem_num;
					sct->head.s_paddr=orgflag;
					sct->head.s_vaddr=org;
					sct->head.s_size=0;
					strget;
					if(!strcmp(ld_entry,"s") || !strcmp(ld_entry,"S"))
						sct->sbp_flags=SBP_SHARED;
					if(!strcmp(ld_entry,"p") || !strcmp(ld_entry,"P"))
						sct->sbp_flags=SBP_PRIVATE;
					if(orgflag==-1)
						orgflag=0;
				}
				strget;
			}
			mem_num++;
		}
		if(!strcmp(ld_entry, "lddata"))
		{
			strget;
			while(strcmp(ld_entry, "{") && success!=NULL) strget;
			strget;
			while(strcmp(ld_entry, "}") && success!=NULL)
			{
				ld_ptr->name = strdup(ld_entry);
				strget;
				sscanf(ld_entry, "%i", &ld_ptr->value);
				strget;
				ld_ptr++->type = ld_entry[0];      /* error in file ? */
				strget;
			}
		}
		strget;
	}
}


extern struct option_desc command_opt[];
extern struct environ_desc environ_opt[];
extern int command_opt_len;
extern int environ_opt_len;

void usage(const char *format, ...)
{
    int i;
    va_list arg;
    struct option_desc *co;
    
	fprintf(stderr, "SB-PRAM(TM) coff(TM)-loader\n\nusage:\n");
    if(format)
    {
        va_start(arg, format);
        vfprintf(stderr, format, arg);
        va_end(arg);
    }
    else
    {
        for(co=command_opt, i=0; i<command_opt_len; i++, co++)
        {
            fprintf(stderr, "%c  %c%c --%-15s  %s\n",
                    (co->type==O_FLAG && !co->val.flags)? 'd': ' ',
                    co->short_opt==' '? ' ': '-',
                    co->short_opt, co->long_opt, co->comment);
        }
    }
	i=0;
	fprintf(stderr, "\nCurrent ldvalues for lddata are:\n");
		while(ld_data[i].name != NULL)
		{
			fprintf(stderr, "%10s: %8d\n", ld_data[i].name, ld_data[i].value);
			i++;
		}
	
    exit(format? 1: 0);
}

int first_run = 1;

int eval_params(int argc, char *argv[])
{ 
    int par, i;
    
    if(first_run)
    {
        options = 0;
        first_run = 0;
    }
        
    for(par=1; par<argc; par++)
    {
        if(argv[par][0] != '-') break;
        
        if(argv[par][1] == '-')
        {
            for(i=0; i<command_opt_len; i++)
                if(!strcmp(argv[par]+2, command_opt[i].long_opt))
                    break;
        }
        else
        {
            for(i=0; i<command_opt_len; i++)
                if(argv[par][1]==command_opt[i].short_opt)
                    break;
        }
        if(i>=command_opt_len)
            usage("unknown option '%s'\n", argv[par]);
        else
        {
			switch(command_opt[i].type)
			{
			case O_INT:
				if(1!=sscanf(argv[++par], "%i",
							 command_opt[i].val.int_val))
					usage("Option --%s expects a number\n",
						  command_opt[i].long_opt);
				break;
			case O_STRING:
				*command_opt[i].val.string_val = strdup(argv[++par]);
				break;
			case O_FLAG:
				if(!command_opt[i].val.flags)
					usage("Option --%s disabled\n",
						  command_opt[i].long_opt);
				else if(command_opt[i].val.flags > 0)
					options |= command_opt[i].val.flags;
				else
					options &= command_opt[i].val.flags;
				break;
			case O_FUNCTION:
				par+=(command_opt[i].val.function)(argc - par, &argv[par]);
				break;
			case O_IGNORE:
				++par;
				break;
			case O_HELP:
				usage(NULL);
				break;
            }
        }
    }
	
	if(outfilename == NULL)
		outfilename = strdup("default.cod\0");
	else
	{
		outfilename = realloc(outfilename, strlen(outfilename)+5);
		strcat(outfilename, ".cod\0");
	}
	
	if(par<argc)
		infilename = strdup(argv[par]);   /* !!! Noch Error ausgeben */
	
	sbp_argv=malloc((argc-par+2)*sizeof(int));
	sbp_argc=argc-par;
	i=0;
	while(par<argc)
	{
		sbp_arglen+=strlen(argv[par])+2;
		sbp_argv[i++]=argv[par++];
	}
	
    return par;
}

void get_environment()
{
    int i;
    char *env;
    
    for(i=0;i<environ_opt_len;i++)
    {
        if((env = getenv(environ_opt[i].env_name)) != NULL)
            *environ_opt[i].env_value = strdup(env);
    }
}

void syserr(char *msg)
{
  extern int errno, sys_nerr;
  extern char *sys_errlist[];
  
  fprintf(stderr, "ERROR: %s (%d", msg, errno);
  if(errno >0 && errno <sys_nerr)
	fprintf(stderr, ": %s)\n", sys_errlist[errno]);
  else
	fprintf(stderr, ")\n");
  exit(1);
}

