/* -*-mb0-c-*- */
#include <stdio.h>
#include <time.h>		/* Used for ctime function */

/* Headers for working with COFF files */

#include "define.h"
#include "init.h"
#include "internal.h"
#include "sh.h"
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>


#define scan_syment(off, sym) bcopy(glob_se + symptr + off*SYMESZ, &sym, SYMESZ);
#define scan_lineent(ptr, off, sym) bcopy(glob_se + ptr + off*LINESZ, &sym, LINESZ);

/* Global variables */

long	num_sections;	/* Number of section */
long	section_seek;   /* Used to seek to first section */

long	symptr;		/* File pointer to symbol table entries */
long	num_symbols;	/* Number of symbols */

char 	*str_tab;	/* Pointer to start of string char. array */
long 	str_length;	/* Length in bytes of string array */

char    infilename[80];
char    outfilename[80];

caddr_t glob_se, se_ptr;
SYMENT g_se;

FILE 	*fd;		/* COFF file descriptor */
int debugflag;
int f_example, f_dbg, f_path, f_head;

struct option_desc command_opt[]=
{
   {'o', "outfile", "%s", O_VALUE, &outfilename},
	{'D', "debug", "%d", O_VALUE, &debugflag},
	{'H', "headers", "", O_FLAG, (int *)&f_head},
	{'e', "example", "", O_FLAG, (int *)&f_example},
	{'d', "dbg", "", O_FLAG, (int *)&f_dbg},
	{'p', "path", "", O_FLAG, (int *)&f_path},
	{0, "", "", O_VALUE, (int *)NULL}
};

struct line_info
{
	int pc;
	int line;
	int l_file;
	int l_func
} LINE_INFO;

#define MAXLINES 100000

struct line_info lif[MAXLINES];
struct line_info *lif_ptr;
int nof_lines=0;
int text_size;

main(argc,argv)
int	argc;
char	*argv[];
{
	int pc;
	int index;
	char filename[256];
	int i, success=1;
	int fdesk;
	char s;
	
	eval_params(argc,argv);
	debugflag |= (f_example << S_EXA) | (f_dbg << S_DBG) | (f_head << S_HEAD);
	
	fd = fopen(infilename, "r");
	if (fd == 0) exit(0);

	fdesk=open(infilename, O_RDONLY);
	read_headers();
	glob_se = mmap(0, symptr+num_symbols*SYMESZ+1000, PROT_READ, 
							 MAP_SHARED, fdesk, 0);
	close(fdesk);

	xif(S_DBG)
		read_strings();
	read_sections();
	xif(S_EXA)
		read_strings();
	read_symbols();
	xif(S_DBG)
		while(success!=EOF)
		{
			printf("pc: ");
			fflush(stdout);
			success=scanf("%i", &pc);
			if(success==0)
			{
				printf("Error\n");
				gets(&s);
			}
			else
				if(pc > text_size)
					printf("pc too large!!!\n");
				else
				{
					index = search_sline(pc, 0, nof_lines-1); 
					printf("pc# 0x%x, real=0x%x, source line=%d,in file ",
						   pc, lif[index].pc, lif[index].line);
					search_sym(lif[index].l_file, 1);      /* Name of File */
					if(lif[index].l_func!=0)
					{
						printf(", in function ");
						search_sym(lif[index].l_func, 1);
					}
					printf("\n");
				}
		}
	exit(0);
}

int search_sline(int adress, int lower, int upper)
{
   int median;
   
   while(upper - lower > 1)
   {
      if(lif[median = (lower+upper)/2].pc <= adress)
      {
         lower = median;
      }
      else
      {
         upper = median - 1 ;
      }

   } /* while */

   if(lif[upper].pc > adress)
   {
      return lower;
   }
   else
   {
      return upper;
   }

} /* search_line */

int search_sym(offset, print)
	int offset;
	int print;
{
	int i;
	
	scan_syment(offset, g_se);
	if(print)
		if(g_se.e_zeroes) 
		{
			for ( i = 0; i < 8; i++) 
				if ((g_se.e_name[i] > 0x1f) && (g_se.e_name[i] < 0x7f))
					printf("%c", g_se.e_name[i]);
		} 
		else
			printf("%s",&str_tab[(g_se.e_offset-4)]);
	
	return 1;
	
} /* search_sym */


read_headers()
{
	FILHDR  file_header;	/* File header structure */
	AOUTHDR	optional_header;/* Optional header structure */

	fread(&file_header, FILHSZ, 1, fd);

	xprintf(S_EXA)("FILE HEADER VALUES\n");
   xprintf(S_EXA)("f_magic  = 0%o\n", file_header.f_magic);
	if(file_header.f_magic!=SH_ARCH_MAGIC)
		xprintf(S_EXA)("WARNING: WRONG MAGIC NUMBER, example may dump core!!!\n");
	xprintf(S_EXA)("f_nscns  = %d\n",file_header.f_nscns);
	xprintf(S_EXA)("f_timdat = %s",ctime(&file_header.f_timdat));
	xprintf(S_EXA)("f_symptr = %d\n",file_header.f_symptr);
	xprintf(S_EXA)("f_nsyms  = %d\n",file_header.f_nsyms);
	xprintf(S_EXA)("f_opthdr = %d\n",file_header.f_opthdr);
	xprintf(S_EXA)("f_flags  = 0%o\n",file_header.f_flags);

	/* Save the global values */

	num_sections = file_header.f_nscns;
	num_symbols  = file_header.f_nsyms;
	symptr	     = file_header.f_symptr;

	if (file_header.f_opthdr)
	{ 
		fread(&optional_header,AOUTSZ,1,fd);
	
		xprintf(S_EXA)("OPTIONAL HEADER VALUES\n");
		xprintf(S_EXA)("magic      = 0%o\n", optional_header.magic);
		xprintf(S_EXA)("vstamp     = %d\n",optional_header.vstamp);
		xprintf(S_EXA)("tsize      = %d\n",optional_header.tsize);
		xprintf(S_EXA)("dsize      = %d\n",optional_header.dsize);
		xprintf(S_EXA)("bsize      = %d\n",optional_header.bsize);
		xprintf(S_EXA)("entry      = 0x%x\n",optional_header.entry);
		xprintf(S_EXA)("text_start = 0x%x\n",optional_header.text_start);
		xprintf(S_EXA)("data_start = 0x%x\n",optional_header.data_start);
		xprintf(S_EXA)("flags      = 0x%x\n",optional_header.flags);
	}

	/* File offset for first section headers */
	section_seek = FILHSZ + file_header.f_opthdr;
}

read_sections()
{
	SCNHDR	sh; /* Section header structure */
	RELOC	re; /* Relocation entry structure */
	LINENO	le; /* Line number entry structure */
	SYMENT  *se;
	
	char 	*raw_data;
	int i,j;
	int tmp_symdx=0;
	int file_symdx=0, func_symdx=0;
	struct line_info *lif_ptr_func;
	
	lif_ptr=lif;
	
	for (i = 0; i < num_sections; i++) 
	{
		fseek(fd,section_seek,0);
		fread(&sh,SCNHSZ,1,fd);
		section_seek += SCNHSZ;
		
		if(sh.s_flags==STYP_TEXT)
			text_size=sh.s_size/4;
		
		xprintf(S_EXA)("\n %s - SECTION HEADER - \n",sh.s_name); 
		xprintf(S_EXA)("s_paddr   = 0x%x\n",sh.s_paddr);
		xprintf(S_EXA)("s_vaddr   = 0x%x\n",sh.s_vaddr);
		xprintf(S_EXA)("s_size    = %d\n",sh.s_size);
		xprintf(S_EXA)("s_scnptr  = %d\n",sh.s_scnptr);
		xprintf(S_EXA)("s_relptr  = %d\n",sh.s_relptr);
		xprintf(S_EXA)("s_lnnoptr = %d\n",sh.s_lnnoptr);
		xprintf(S_EXA)("s_nreloc  = %d\n",sh.s_nreloc);
		xprintf(S_EXA)("s_nlnno   = %d\n",sh.s_nlnno);
		xprintf(S_EXA)("s_flags   = 0x%x\n",sh.s_flags);

		/* for Section-Header Output */
		xprintf(S_HEAD)("%s\t: size %10d\n", sh.s_name, sh.s_size);
		
		/* Output raw data only for text and data sections */
		if (strcmp(sh.s_name,".bss") && (sh.s_flags!=STYP_BSS))
		{
			raw_data = (char *)malloc(sh.s_size);
			fseek(fd,sh.s_scnptr,0);
			fread(raw_data,sh.s_size,1,fd);
   
			xprintf(S_EXA)("RAW DATA\n");
			j=0;
   			while(j<sh.s_size) 
			  {
			    xprintf(S_EXA)("%02x ",(*raw_data&0xFF));
			    *raw_data++; j++;
			    if (j%16==0) xprintf(S_EXA)("\n");
			  }
			xprintf(S_EXA)("\n");
			free(raw_data-j);
		}
	
		if (sh.s_nreloc) 
			{	
			xprintf(S_EXA)("\nRELOCATION ENTRIES\n");
			fseek(fd,sh.s_relptr,0);
			j=0;	
			while(j<sh.s_nreloc) 
				{
				fread(&re,RELSZ,1,fd);
				xprintf(S_EXA)("r_vaddr = 0x%x",re.r_vaddr);
				xprintf(S_EXA)(" r_symndx = 0x%x",re.r_symndx);
				xprintf(S_EXA)(" r_offset = 0x%x\n",re.r_offset);
				j++;
				}
			}

		if (sh.s_nlnno) 
			{
			xprintf(S_EXA)("\nLINE NUMBER ENTRIES \n");
			fseek(fd,sh.s_lnnoptr,0);
			j=0;	
			while(j<sh.s_nlnno) 
			{
				scan_lineent(sh.s_lnnoptr, j, le); 
				if (le.l_lnno == 0)
				{
					xprintf(S_EXA)("function address 0x%x\n",le.l_addr.l_symndx);
													  
					scan_syment(le.l_addr.l_symndx, g_se);
					
					xif(S_DBG)
					switch(g_se.e_sclass)
					{
					case C_FILE:
						file_symdx=le.l_addr.l_symndx;
						/* printf("Function: 0x%x\n", file_symdx); */
						break;
					case C_EFCN:
						lif_ptr->l_func=0;
						lif_ptr_func=lif_ptr;
						while(--lif_ptr_func!=NULL && lif_ptr_func->l_func==0)
							lif_ptr_func->l_func=le.l_addr.l_symndx;
						func_symdx=le.l_addr.l_symndx;
						/* printf("Function: 0x%x\n", tmp_symdx); */
						break;
					default:
						break;
					}
				}
				else 
				{
					xprintf(S_EXA)("line# %d at address 0x%x\n",le.l_lnno,le.l_addr.l_paddr);
					lif_ptr->pc=le.l_addr.l_paddr;
					lif_ptr->line=le.l_lnno;
					lif_ptr->l_file=file_symdx;
					lif_ptr->l_func=0;
					lif_ptr++;
					nof_lines++;
				}
				j++;
				}
			}

	}
}

read_strings()
{
	int 	strings;
	char	*str_ptr;
	
	strings = symptr+SYMESZ*num_symbols;
	fseek(fd,strings,0);
	fread(&str_length,4,1,fd);
	if (str_length) {
		xprintf(S_EXA)("\nSTRING TABLE DUMP\n");
		str_length-=4;
		str_tab = (char *)malloc(str_length);
		fseek(fd,(strings+4),0);
		fread(str_tab,str_length,1,fd);
		str_ptr=str_tab;
		do	{
			xprintf(S_EXA)("%s\n",str_ptr);
			while(*str_ptr++ !='\0');
		}
		while(str_ptr<(str_tab+str_length));
	}
}

read_symbols()
{
	SYMENT	se;
	AUXENT  ae;
	int	i;
	int	j;
	
	xprintf(S_EXA)("\nSYMBOL TABLE ENTRIES\n");
	i = 0;
	while (i  != num_symbols) 
	{
		scan_syment(i, se);
		xprintf(S_EXA)("0x%05x ", i);
		print_se(&se); i++;
		for (j = 0; j < se.e_numaux; j++) 
			{
			fread(&ae,AUXESZ,1,fd);
			print_ae(&ae);
			i++;
			}
		}
}


print_se(se)
SYMENT  *se;
{
int i;
	if (se->e_zeroes) 
		{
		for ( i = 0; i < 8; i++) 
			{
		    	if ((se->e_name[i] > 0x1f) && (se->e_name[i] < 0x7f))
		       		xprintf(S_EXA)("%c",se->e_name[i]);
		    	else 
				xprintf(S_EXA)(" ");
			}
		} 
	else
		 xprintf(S_EXA)("%s",&str_tab[(se->e_offset-4)]);

	xprintf(S_EXA)(" n_scnum=%d ",se->e_scnum);

	switch (se->e_type & 0xf) 
		{
	 	case T_CHAR:   xprintf(S_EXA)("T_CHAR"); break;
		case T_SHORT:  xprintf(S_EXA)("T_SHORT"); break;
	 	case T_INT:    xprintf(S_EXA)("T_INT"); break;
	 	case T_LONG:   xprintf(S_EXA)("T_LONG"); break;
	 	case T_FLOAT:  xprintf(S_EXA)("T_FLOAT"); break;
	 	case T_DOUBLE: xprintf(S_EXA)("T_DOUBLE"); break;
	 	case T_STRUCT: xprintf(S_EXA)("T_STRUCT"); break;
	 	case T_UNION:  xprintf(S_EXA)("T_UNION"); break;
	 	case T_ENUM:   xprintf(S_EXA)("T_ENUM"); break;
	 	case T_MOE:    xprintf(S_EXA)("T_MOE"); break;
	 	case T_UCHAR:  xprintf(S_EXA)("T_UCHAR"); break;
	 	case T_USHORT: xprintf(S_EXA)("T_USHORT"); break;
	 	case T_UINT:   xprintf(S_EXA)("T_UINT"); break;
	 	case T_ULONG:  xprintf(S_EXA)("T_ULONG"); break;
	 	default:       xprintf(S_EXA)("n_type=%d",se->e_type&0xf); break;
		}

	if (ISFCN(se->e_type))       
		xprintf(S_EXA)(",DT_FCN ");
	else 
		if (ISPTR(se->e_type))  
			xprintf(S_EXA)(",DT_PTR ");
	else 
		if (ISARY(se->e_type))  
			xprintf(S_EXA)(",DT_ARY ");

	switch (se->e_sclass)  
		{
	 	case C_NULL   : xprintf(S_EXA)(" C_NULL=0x%x",se->e_value); break;
	 	case C_STAT   : xprintf(S_EXA)(" C_STAT=0x%x",se->e_value); break;
	 	case C_EXT    : xprintf(S_EXA)(" C_EXT=0x%x",se->e_value); break;
	 	case C_AUTO   : xprintf(S_EXA)(" C_AUTO=0x%x",se->e_value); break;
	 	case C_FILE   : xprintf(S_EXA)(" C_FILE"); break;
	 	case C_STRTAG : xprintf(S_EXA)(" C_STRTAG"); break;
	 	case C_EOS    : xprintf(S_EXA)(" C_EOS=0x%x",se->e_value); break;
	 	case C_FCN    : xprintf(S_EXA)(" C_FCN=0x%x",se->e_value); break;
	 	case C_EFCN   : xprintf(S_EXA)(" C_EFCN=0x%x",se->e_value); break;
	 	default       : xprintf(S_EXA)(" n_sclass=0x%x",se->e_sclass); break;
		}

	xprintf(S_EXA)(" n_numaux=%d\n",se->e_numaux);
}

print_ae(ae)
char	*ae;
{
int i;
	xprintf(S_EXA)(" Aux. = ");
	for( i = 1; i <= AUXESZ; i++ ) 
		{
		xprintf(S_EXA)("%1x",(*ae>>4)&0xF);
		xprintf(S_EXA)("%1x ",(*ae&0xF));
		*ae++; 
		}

	xprintf(S_EXA)("\n");
}

