/*****************************************************************************
   Testprogramm fuer die Platinen SBusInt und PRAMInt
   PRAM Hostanbindung (c)1994 jfriedr
   
   V1.0 05.08.94
   Joerg Friedrich
   jf@cs.uni-sb.de
   in11wpjf@rz.uni-sb.de                                             
*****************************************************************************/

#include <string.h>
#include <sys/file.h>
#include <stdio.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <string.h>
#include <sys/errno.h>
#include <fcntl.h>
#include <unistd.h>

#define	TRUE	        1
#define	FALSE	        0
#define	YES	        1
#define	NO	        0
#define	Fehler   	2

/* aber nur bei SS10 & SS20 !!!!!                       */
#define	SBUSSIZE	0xfffffff 

#define	MAXSLOTS	4              /* optimistisch! */

#define	SLOT_DEFAULT	1
#define	OFFSET_DEF	0
#define	SIZE_DEFAULT	32

/* jetzt kommen die Adressen fuers SBus-Int             */
#define IMASK_ADR	0x800000
#define CENTR_ADR	0x800000  /*	0x1000000 */
#define EPROM_ADR       0x0

/* Adressen fuers PRAM-Int                               */
#define PAGESB_ADR	0x3000000    /* halfword Zugriff */
#define PREGSB_ADR	0x1000000    /* halfword Zugriff */
#define PREGPB_ADR	0x7000000    /* halfword Zugriff */
#define HREG_ADR	0x3000000
#define SPBUS_ADR	0x8000000
#define PRBUS_ADR	0x4000000

/* ------------------------------------------------------*/

void schreiben(io_adr,wert)
u_long     io_adr;		
u_long     wert;
{ 
  *(u_long*)io_adr = wert;
}

u_long lesen(io_adr)
u_long	io_adr;	
{
  return(*(u_long*)io_adr);
}

int devopen(slotnum)
int slotnum;
{
  int fd;
  char    open_argument[15];
  char    *open_arg;

  open_arg = &open_argument[0]; 
  sprintf(open_arg, "/dev/sbus%d", slotnum);
  if ((fd = open(open_arg, O_RDWR)) < 0)
  {
    perror(open_arg);
    exit(Fehler);
  }
#ifdef DEBUG
  printf("fd von sbus%d ist %d\n", slotnum, fd);
#endif DEBUG
  return(fd);
}


/* ------------------------------------------------------*/
int main(argc,arg)
int argc;
char *arg[];
{
  FILE    *dp, *lp, *logfile;
  int	  fd, write_flg,du;	
  char	  ascii_string[15], datei[100];
  char	  *ascii;			
  int	  slotnum, address_offset=0, page_offset=0, size, page_size;		
  off_t	  page_start;		
  caddr_t page_address, address, base;		
  int	  i=100, bm=0,l, j=0, delay=0, sl=0, bcount=0, lw=0 ,loops=0;
  int     prams_wert[256], pregs_wert=0, pregp_wert=0, in_wert=0;
  int     ep_wert=0, par_wert=0, pr_wert=0;
  int     zeichen, line, nummer;
  int     pradr, prsadr, prpadr;
  u_long  loopl, looph, hashadr, hr_wert, loc_adr, WERT ,ADR ,count ; 

 if (argc!=2) nummer=0;
 else nummer = atoi(arg[1]);

 while (i!=99)
 { 
 /* printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");*/
  printf("\n\n                      Hardwaretest PRAM--Hostinterface\n");
  printf("                          by Joerg Friedrich 6/94\n\n");
  printf(" Mapping\n");
  printf(" -------\n\n");  
  printf("  0  Logfile laden & Init\n");  
  printf("  1  SBus--Slot waehlen und oeffnen\n");
  printf("  2  SBus--Interface einmappen\n\n");
  printf(" SBus-Int                       PRAM-Int\n");
  printf(" --------                       --------\n\n"); 
  printf("  3 -- Interrupt--Mask setzen    10 -- Page Speicherbus schreiben \n");
  printf("  4 -- ParPort lesen             11 --  PageRegister Speicherbus schreiben\n");
  printf("  5 -- ParPort schreiben         12 -- Page Prozessorbus schreiben\n");
  printf("  6 -- BootEprom auslesen        13 -- HashRegister schreiben\n");
  printf("  7 -- Binaerzaehler             14 -- HashMul-Test\n");
  printf("  8 -- Lauflicht                 15 -- Speicherbus schreiben\n");
  printf("  9 -- Drucken                   16 -- Speicherbus lesen\n");
  printf("                                 17 -- Prozessorbus schreiben\n");
  printf("                                 18 -- Prozessorbus lesen\n");
  printf("                                 20 -- Prozessorbus LoopTest\n");
  printf("                                 21 -- Speicherbus  LoopTest\n");
  printf("                                 99 -- Ende\n\n");
  scanf("%d",&i);
  if (i==0)
  {
    if (lp = fopen("testlog","rw"))
    {
       fscanf(lp,"%d %d %d %d %d %d",
             &sl, &pr_wert, &par_wert, &pregp_wert, &pregs_wert, &hr_wert);
       for (j=0;j<256;j++)
       {
          fscanf(lp,"%d", &WERT);
          prams_wert[j] = WERT;
       }          
       close(lp);
       devopen(sl);
    }
  }
  if ((i==1))
  {
    if (logfile = fopen("errlog","w")) printf("Errlog opened!\n");

    printf("Slot (0-3): ");scanf("%d",&sl);
    if ((sl>=0)&&(sl<4))
    {
      fd = devopen(sl);
      printf("\nOK....\n");

/*      sprintf(open_arg, "/dev/sbus%d", sl);
      if ((fd = open(open_arg, O_RDWR)) < 0)
      {
        perror(open_arg);
        exit(Fehler);
      }
*/
    }
  }
  if ((i==2)||(i==1))
  {
     page_size   = sysconf(_SC_PAGESIZE);
     page_start  = (address_offset/page_size) * page_size;
     page_offset = (address_offset % page_size);

#ifdef DEBUG
 printf("pagesize is 0x%x, page_start is 0x%x, ",
	 page_size, page_start);
 printf("page_offset is 0x%x\n", page_offset);
#endif DEBUG
	
     page_address = mmap((caddr_t)0, SBUSSIZE,
		    PROT_READ|PROT_WRITE, MAP_SHARED,
		    fd, page_start);
     
#ifdef DEBUG
 printf("Virtuelle Adresse der Page ist 0x%x\n", page_address);
#endif DEBUG

     if (page_address == (caddr_t)-1)
     {
	perror("mmap Fehler");
	exit(Fehler);
     }
  }
  if (i==3)
  {
     printf("Bit: [00..03] (%d) -- \n",pr_wert&0xF);
     printf("     [04..07] (%d) -- \n",pr_wert&0xF0);
     printf("     [08..14] (%d) -- Interruptmaskierung\n",pr_wert&0x7F00);
     printf("     [15    ] (%d) -- \n",pr_wert&0x8000);
     printf("     [00..15] (%d) -- Summe\n\n",pr_wert);
     printf("neuer Wert: ");scanf("%i",&pr_wert);
     address = (page_address + page_offset + IMASK_ADR);
     schreiben(address, pr_wert);
  }
  if (i==4)
  {
     address = (page_address + page_offset + CENTR_ADR);
     in_wert=lesen(address);
     printf("gelesener Wert: %d\n",in_wert);
     printf("Busy: %d    Strobe: %d     Daten: %d\n",
             in_wert&0x200,in_wert&0x100,in_wert&0x0FF);
  }
  if (i==5)
  {
     printf("alter Wert: %d\n",par_wert);
     printf("neuer Wert: ");scanf("%i",&par_wert);
     address = (page_address + page_offset + CENTR_ADR);
     schreiben(address, par_wert);
  }
  if (i==6)
  { 
     printf("Wieviele Bytes: ");scanf("%i",&bcount);
     address = (page_address + page_offset + EPROM_ADR);       
     ascii = &ascii_string[0];
     *ascii = NULL;
     printf("\n    SUN          SBus\n");
     if ((line = (u_int)address % 8) != 0)
     {
	printf(" 0x%08x,  ", address);
	for (i = 0; i < line; i++)
        {
	   printf("    ");	
	   (*(ascii++) = ' ');	
	}
     }
     for (j=1;j <  bcount+1; j++ ,address++)
     {
	if (((int)address % 8) == 0) 
        {
	   *ascii = '\0';
	   printf("%s", &ascii_string[0]);
	   printf("\n 0x%08x,  ", address);
	   printf("0x%08x ", j-1);
           ascii = &ascii_string[0];
	}
	printf(" %02x ", (u_char)*address);
	if (*address < ' ' || *address >  '~')
	    *(ascii++) = '.';
	else
	    *(ascii++) = *address;
     }
     if ((line = (u_int)address % 8) != 0)
     {
	for (i = 0; i < (8 - line); i++)
        {
	   printf("    ");	
           (*(ascii++) = ' ');
        }
     }
     *ascii = '\0';
     printf("%s", &ascii_string[0]);
     printf("\n");
  }

  if ((i==7)||(i==8))
  {
    printf("Loops: ");scanf("%d",&bcount);
    printf("Delay: ");scanf("%d",&delay);
    address = (page_address + page_offset + CENTR_ADR);
    for (j=0;j<bcount*256;j++)
    {
      sleep(delay);
     if (i==8) bm = (1 << (j%8)); else bm = j;
     schreiben(address, (bm&0xff)|0x300);
    }
  }   
  if (i==9)
  {   
    printf("\nDateiname: ");
    scanf("%s",datei);
    if (dp = fopen(datei,"r"))
    {
        address = (page_address + page_offset + CENTR_ADR); 
        do
        {
           zeichen = fgetc(dp);
           if (zeichen != EOF)
           {
               schreiben(address,(int)zeichen|0x100);
               schreiben(address,(int)zeichen&0xFF);
               do {} while(!(lesen(address)&0x200));
               putchar(zeichen); 
           }
        }  while(zeichen != EOF);
        close(dp);
    }
    else
    {
        printf("\nDatei--Ladefehler\n\n");
    }
  }
  if (i==10)
  {
     printf("Eintrag im Page--RAM (0..255): ");scanf("%i",&pradr);
     printf("Wert: ");scanf("%i",&WERT);
     prams_wert[pradr] = WERT;
     address = (page_address + page_offset + PREGSB_ADR);
     *(u_short*)address = (pradr & 0x7);
     address = (page_address + page_offset + PAGESB_ADR + (pradr & 0xF8));
     *(u_short*)address = WERT; 
     printf("%4x\n\n",address);
  }
  if (i==11)
  {
     printf("Register Wert: ");scanf("%i",&pregs_wert);
     address = (page_address + page_offset + PREGSB_ADR);
     *(u_short*)address = pregs_wert;           
  }
  if (i==12) 
  {  
     printf("Page-Register Wert: ");scanf("%i",&pregp_wert);
     address = (page_address + page_offset + PREGPB_ADR);
     *(u_short*)address = pregp_wert;           
  }     
  if (i==13)
  {
     printf("Hash-Register Wert: ");scanf("%i",&hr_wert);  
     address = (page_address + page_offset + HREG_ADR);
     schreiben(address, hr_wert);     
  }
  if (i==14)
  {
     printf("\n\n Testen von Hashmul und Speicherbus\n\n");
     base = (page_address + page_offset + SPBUS_ADR);
     for(looph=0;looph <0x3ff;looph++)
     {
       address = (page_address + page_offset + PREGSB_ADR);
       *(u_short*)address = 0;
       address = (page_address + page_offset + PAGESB_ADR + 2*nummer);
       *(u_short*)address = looph;     /* Eintrag nummer enthaelt Offset! */

       for(loopl=0;loopl <0x400000;loopl++)
       {
         count = loopl + looph *  0x400000;
         if ((count % 1000000) == 0) { printf("\n %lu - ",
                                       count/1000000);fflush(stdout);}
         if ((loopl % 100000) == 0) { printf("*");fflush(stdout);}

         loc_adr = (loopl << 2);                      
         hashadr = lesen(base + (loc_adr | (nummer * 0x1000000)));                

         if ((count * hr_wert) != (hashadr))
         {
            schreiben(page_address + page_offset + PRBUS_ADR, 0);
            fprintf(logfile,"S - Error LOC=%d   Hex=%0x   PAD=%d Hex=%0x\n",loopl,loopl,looph,looph);
            fprintf(logfile,"S - soll: %0x  ist: %0x  delta: %lu\n",(loopl + looph * 0x400000) * hr_wert,
                    hashadr,abs(((loopl + looph * 0x400000) * hr_wert) - (hashadr)));           
            fflush(logfile);
            printf("Error LOC=%d Hex=%0x  PAD=%d Hex=%0x\n",loopl,loopl,looph,looph);
            printf("soll: %lu    ist: %lu   delta: %lu\n",(loopl + looph * 0x400000) * hr_wert,
                    hashadr,abs(((loopl + looph * 0x400000) * hr_wert) - (hashadr)));
            printf("soll: %0x    ist: %0x   delta: %0x\n",(loopl + looph * 0x400000) * hr_wert,
                    hashadr,abs(((loopl + looph * 0x400000) * hr_wert) - (hashadr)));
         }       
       }   
       printf("/"); 
    }   
  }   
  if (i==15)
  {   
     printf("Adresse: ");scanf("%i",&ADR);

     address = (page_address + page_offset + PREGSB_ADR);
     *(u_short*)address = 0xa0;
     address = (page_address + page_offset + PAGESB_ADR + 0);
     *(u_short*)address = ADR / 0x400000;       /* Eintrag 0 enthaelt Offset! */

     printf("Wert   : ");scanf("%i",&WERT);
     address = (page_address + page_offset + SPBUS_ADR + (( ADR % 0x400000)<<2)); 
     schreiben(address, WERT);
  }
  if (i==16)
  {   
     printf("Adresse       : ");scanf("%i",&ADR);

     address = (page_address + page_offset + PREGSB_ADR);
     *(u_short*)address = 0xa0;
     address = (page_address + page_offset + PAGESB_ADR + 0);
     *(u_short*)address = ADR / 0x400000;       /* Eintrag 0 enthaelt Offset! */

     base = (page_address + page_offset + SPBUS_ADR + (( ADR % 0x400000)<<2)); 
     lw=lesen(base);
     printf("gelesener Wert: %lu   Hex %4x\n",lw,lw);
   /*  printf("Differenz     : %lu   Hex %0x\n",abs(lw-ADR * hr_wert),
        abs(lw-ADR * hr_wert)); */
  }  
  if (i==17)
  {   
     printf("Adresse: ");scanf("%i",&ADR);
     printf("Wert   : ");scanf("%i",&WERT);
     address = (page_address + page_offset + PREGPB_ADR);
     schreiben(address, ADR / 0x1000000); 
     address = (page_address + page_offset + PRBUS_ADR + ((ADR % 0x1000000 <<2))); 
     schreiben(address, WERT);
  } 
  if (i==18)
  {   
     printf("Adresse       : ");scanf("%i",&ADR);
     address = (page_address + page_offset + PREGPB_ADR);
     schreiben(address, ADR / 0x1000000);     
     address = (page_address + page_offset + PRBUS_ADR + ((ADR % 0x1000000) <<2 )); 
     lw=lesen(address); 
     printf("gelesener Wert: %lu  Hex %0x\n",lw,lw);
     printf("Differenz     : %lu  Hex %0x\n",abs(lw-ADR ),        
                                             abs(lw-ADR )); 
  } 
  if (i==20) 
  {  
     printf("\n\n Testen von Prozessorbus\n");
     base = (page_address + page_offset + PRBUS_ADR);
     address = (page_address + page_offset + PREGPB_ADR);
     for(looph=0;looph <0xff;looph++)
     {
       *(u_short*)address = looph;

       for(loopl=0;loopl <0x1000000;loopl++)
       {
         if (((loopl + looph *  0x1000000) % 1000000) == 0) { printf("\n %lu -",
             ((loopl + looph *  0x1000000)/1000000));fflush(stdout);}
         if ((loopl % 100000) == 0) { printf("*");fflush(stdout);}
         loc_adr = (loopl << 2);
         hashadr = lesen(base + (loc_adr));                
         if ((( loopl + looph * 0x1000000)) != (hashadr))
         {
            fprintf(logfile,"P - Error LOC=%d   Hex=%0x  PAD=%d Hex=%0x\n",loc_adr>>2,loc_adr>>2,looph,looph);
            fprintf(logfile,"P - soll:     %lu  ist: %lu   delta: %lu\n",(loopl + looph * 0x1000000),
                    hashadr,abs(((loopl + looph * 0x1000000)) - (hashadr)));
            fflush(logfile);
            printf("Error LOC=%d Hex=%0x  PAD=%d Hex=%0x\n",loc_adr>>2,loc_adr>>2,looph,looph);
            printf("soll: %lu    ist: %lu   delta: %lu\n",(loopl + looph * 0x1000000),
                    hashadr,abs(((loopl + looph * 0x1000000)) - (hashadr)));
         }       
       }   
     }       
  }     

  if (i==21)
  {   
     printf("Adresse       : ");scanf("%i",&ADR);
     printf("Loops         : ");scanf("%i",&loops);
     address = (page_address + page_offset + PREGSB_ADR);
     *(u_short*)address = 0;
     address = (page_address + page_offset + PAGESB_ADR + 0);
     *(u_short*)address = ADR / 0x400000;       /* Eintrag 0 enthaelt Offset! */

     base = (page_address + page_offset + SPBUS_ADR + (( ADR % 0x400000)<<2)); 
     for (j=0;j < loops;j++)
     {
       lw=lesen(base);
       printf("Zugriff Nr.: %lu gelesener Wert: %lu   Hex %4x\n",j,lw,lw);
     }
  }

 }




 exit(0);
}  
