#include <syscall.h>
#include <sbp/sbp_gop.h>
#include <stdio.h>
#include <sbp/sbp_multiproc.h>
#include <sbo/sbo.h>
#include <fcntl.h>

#define FPGA_CNT_PER_US (16000000/1e6)    /* 14 MHz / 32 */

/* --------------------------------------------------------------------- */

struct tg_timer_typ
{
  long magic1;
  long magic2;
  long ct_0;
  long ct_1;
  long et_0[2];
  long et_1[2];
  float et_diff;
  float ct_diff;
};

#define TG_TIM_INIT	0
#define TG_TIM_START	1
#define TG_TIM_STOP	2
#define TG_TIM_TIME	3
#define TG_TIM_ROUND	4
#define TG_TIM_OVERHEAD	7

static inline int tgt_init_struct(addr)
struct tg_timer_typ *addr;
		/* Init counters and magic values, return 1 on success */
{
  addr->magic1  = 0x13578642;
  addr->magic2  = 0x86421357;
  addr->ct_0    = addr->ct_1    = 0;
  addr->et_0[0] = addr->et_0[1] = 0;
  addr->et_1[0] = addr->et_1[1] = 0;
  addr->et_diff = addr->ct_diff = 0.0;
  return 1;
}

float tg_timer(function, address)
int function;
void *address;
{
  static struct tg_timer_typ *p =NULL;

  if((function>0)&&((void*)p==NULL))
  { fprintf(stderr,"tg_timer: not initialized\n");
    return 0.0;
  }

  switch(function)
    {
    case -4:                    /* Return base address of current 
				   tg_timer_typ structure */
      /* not implemented yet */
      return 0;
      break;
      
    case -3:			/* Switch to new timer at addr address,
				   check magic, return 0.0 on success */
      p = (struct tg_timer_typ *)address;
      if((void*)p==NULL)
      { fprintf(stderr,"tg_timer(-3): no address specified\n");
        p = (void*)0;
        return 0.0;
      }
      if((p->magic1!=0x13578642) || (p->magic2!=0x86421357))
      { fprintf(stderr,"tg_timer(-3): wrong timer magic\n");
        p = (void*)0;
        return 0.0;
      }
      return 0.0;
      break;
    case -2:			/* Allocate shared struct; Return addr */
      p=shmalloc(sizeof(struct tg_timer_typ));
      if((void*)p==NULL)
      { fprintf(stderr,"tg_timer(-2): shmalloc failed\n");
        p = (void*)0;
        return 0.0;
      }
      if( tgt_init_struct(p) != 0)
        *(long*)address = (long)p;
      return 0.0;
      break;
    case -1:			/* Allocate private struct; Return addr */
      p=(struct tg_timer_typ*) malloc(sizeof(struct tg_timer_typ));
      if((void*)p==NULL)
      { 
        fprintf(stderr,"tg_timer(-1): malloc failed\n");
        p = (void*)0;
        return 0.0;
      }
      if( tgt_init_struct(p) != 0)
        if((void*)address!=NULL)
	  *(long*)address = (long)p;
      return 0.0;
      break;
    case 0:			/* Init; set Lag; Return 0.0 */
      tg_timer(-1, NULL);
      tg_timer(1, NULL);
      tg_timer(2, NULL);
      tg_timer(5, NULL);
      return 0.0;
      break;
    case 1:			/* Start = Now */
      sys_get_extimer((void*)(p->et_0));
      p->ct_0=sys_getct();
    case 2:			/* Stop = Now */
      sys_get_extimer((void*)(p->et_1));
      p->ct_1=sys_getct();
    case 3:			/* Return Elapsed Time */
      return (1e-6*
               (  (p->et_1[0]*65536.*65536.+p->et_1[1])
		 -(p->et_0[0]*65536.*65536.+p->et_0[1]) ) 
              -p->et_diff);
      break;
    case 4:			/* Return Instruction Rounds */
      return (float)(unsigned int)(p->ct_1 - p->ct_0) - p->ct_diff;
      break;
    case 5:			/* Adjust lag between 2 calls by (..1-..0) */
      p->et_diff =  (1e-6*
               (  (p->et_1[0]*65536.*65536.+p->et_1[1])
		  -(p->et_0[0]*65536.*65536.+p->et_0[1]) ) );
      p->ct_diff = (float)(unsigned int)(p->ct_1 - p->ct_0);
      return 0.0;
      break;
    case 6:			/* Adjust lag by (*address) rounds */
      /* not implemented yet */
      break;
      
    case 7:			/* Return overhead in percent */
      {
	int mod;
	float fac[]={ 1., 2., 4., 4./3.};
      				/* Warning: default of simulator is 24 VP */
	mod=(getmod()>>20)&3;	/* #VPs is coded in mode */
	return ((tg_timer(3)*(fac[mod])/4.*FPGA_CNT_PER_US)/tg_timer(4))-1.;
      }
      break;
    default:
      { fprintf(stderr,"tg_timer(???): invalid function [%d]called\n",
			function);
        return 0.0;
      }
  }
}
