/* $Id: syscall.h,v 1.13 1998/05/19 15:33:59 rock Exp $ */

/* Syscall interface */

#ifndef __SYSCALL_H__
#define __SYSCALL_H__

#if defined(KERNEL) || defined(_ASM) || defined(SYSCALL)
#define __BEGIN_DECLS
#define __END_DECLS
#else
/* for C++ freaks - contains definition of __BEGIN_DECLS and __END_DECLS */
#include<features.h>
#endif

__BEGIN_DECLS

#ifndef SYSCALL
#define SYSCALL(NR, RETTYPE, NAME, PROTO, PARM) \
extern RETTYPE NAME PROTO;
#endif

/* SYSCALL_D(sysc...) prevents definition of a prototype and automatic
   generation of a stub for sysc in the libc */

#ifndef SYSCALL_D
#define SYSCALL_D(a...)
#endif

/* SYSCALL_NP(sysc...) prevents definition of a prototype for sysc but
   generates a stub for sysc in the libc */

#ifndef SYSCALL_NP
#define SYSCALL_NP(a...)
#endif

#undef sys_start_synchron
#undef sys_end_synchron

#ifndef _ASM
struct service_request; /* XXX defined in poll.h */
typedef void(void_func_t)(void);
#endif

#if defined(KERNEL)
SYSCALL(-1, int, set_prog_start, (unsigned ps), (ps))
#endif
SYSCALL_D( 0, int,  open, (const char *file, int mode, int flags), (file, mode, flags))
SYSCALL( 1, int,  read, (int fd, void *buffer, int number), (fd, buffer, number))
SYSCALL( 2, int,  write, (int fd, const void *buffer, int number), (fd, buffer, number))
SYSCALL( 3, int,  close, (int fd), (fd))
SYSCALL( 4, int,  lseek, (int fd, int offset, int origin), (fd, offset, origin))
SYSCALL( 5, int,  sys_std_open, (int fd), (fd))
SYSCALL( 6, int,  sys_abort, (int pc, int reason), (pc, reason))
SYSCALL( 7, int,  sys_getnr, (void), ())
SYSCALL( 8, int,  sys_exit, (void), ())
SYSCALL( 9, int,  sys_getct, (void), ())
SYSCALL(10, int,  sys_get_extimer, (unsigned *time_64_bit), (time_64_bit))
SYSCALL(11, int,  sys_fork, (int ppid), (ppid))
SYSCALL(12, int,  sys_getbas, (void), ())
SYSCALL(13, void, sys_putbas, (int base), (base))
SYSCALL(14, int,  sys_getpr, (void), ())
SYSCALL(15, char *, getty, (void),())
SYSCALL(16, int,  dup, (int fd), (fd))
SYSCALL(17, int,  getuid, (void), ())
SYSCALL(18, int,  getportid, (void), ())
SYSCALL(19, void, setuid, (int id), (id))
SYSCALL(20, void, setportid, (int id), (id))
SYSCALL(21, void, send_errmsg, (char *), (msg))
SYSCALL(22, int,  getmod, (void), ())
SYSCALL(23, int,  accept, (int, void *, int *), (s, addr, addrlen))
SYSCALL(24, int,  socket, (int, int, int), (domain, type, protocol))
SYSCALL(25, int,  bind, (int, void *, int), (s, name, namelen))
SYSCALL(26, int,  listen, (int, int), (s, backlog))
SYSCALL(27, int,  ioctl, (int, int, int), (fd, request, arg))
/* prototype of gettimeofday is defined in sys/time.h */
SYSCALL_NP(28, int, gettimeofday, (struct timeval *, struct timezone *), (addr, addr))
SYSCALL(29, int, getct_64, (unsigned *), (getct_64_bit))
SYSCALL(30, void, set_pstat, (char *, int), (str, mask))
SYSCALL(31, int, scsirw, (unsigned ppnr, struct service_request *sr), (ppnr, sr))
SYSCALL(32, int, mkdir, (char *, int), (path, mode))
SYSCALL(33, int, rmdir, (char *), (path))
SYSCALL(34, int, getdents, (int, void *, int, int), (fd, buf, off, nbyte))
SYSCALL(35, int, sysconf, (void *, int, int), (buffer, nbytes, arg))
SYSCALL(36, int,  sys_procend, (void), ())
SYSCALL(37, int,  sys_get_fpga_cnt, (unsigned *time_64_bit), (time_64_bit))
SYSCALL(38, void, sys_test, (void), ())
SYSCALL(39, int, sys_get_vp_per_pp, (void), ())
SYSCALL(40, int, dup2, (int fd, int fd2), (fd, fd2))
SYSCALL(41, void_func_t *, individual_exception_hook, (void_func_t *), (new_handler))
#define sys_start_synchron()
#define sys_end_synchron()

__END_DECLS

#endif /* __SYSCALL_H__ */
