/* sbp_gop.h */

/* (c) 1994 by bird@cs.uni-sb.de */

/* $Id: sbp_gop.h,v 1.1.1.1 1997/07/03 13:12:02 bird Exp $ */

/* 
 * C-interface to the global operations of the PRAM processor
 *
 */


/*
 * the following global operations are provided:
 * 
 * (MODULO is the modulo bit which toggels on each round)
 * 
 * ANY32TYPE is any type which is represented by a 32 bit word
 *

 load global on MODULO == 0:

    typeof(cell) sbp_ldg_m0(ANY32TYP *cell)

 load global on MODULO == 1:

    typeof(cell) sbp_ldg_m1(ANY32TYPE *cell)


 store global on MODULO == 0:

    void sbp_stg_m0(ANY32TYPE *cell, ANY32TYPE value)

 store global on MODULO == 1:

    void sbp_stg_m1(ANY32TYPE *cell, ANY32TYPE value)


 sync on any value of MODULO:

    void sbp_syncand(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncor(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncmax(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncadd(ANY32TYPE *cell, ANY32TYPE syncval)

 sync on MODULO == 0:

    void sbp_syncand_m0(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncor_m0(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncmax_m0(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncadd_m0(ANY32TYPE *cell, ANY32TYPE syncval)

 sync on MODULO == 1:

    void sbp_syncand_m1(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncor_m1(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncmax_m1(ANY32TYPE *cell, ANY32TYPE syncval)
    void sbp_syncadd_m1(ANY32TYPE *cell, ANY32TYPE syncval)


 multiprefix any value of MODULO:

    typeof(cell) sbp_mpand(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpor(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpmax(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpadd(ANY32TYPE *cell, ANY32TYPE mpval) 

 multiprefix on MODULO == 0:

    typeof(cell) sbp_mpand_m0(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpor_m0(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpmax_m0(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpadd_m0(ANY32TYPE *cell, ANY32TYPE mpval) 

 multiprefix on MODULO == 1:

    typeof(cell) sbp_mpand_m1(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpor_m1(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpmax_m1(ANY32TYPE *cell, ANY32TYPE mpval) 
    typeof(cell) sbp_mpadd_m1(ANY32TYPE *cell, ANY32TYPE mpval) 

 */

/* The following operations are not native instructions of the SBPRAM
   processor but are very usefull too. They have been introduced in
   J. M. Wilson's thesis (Department of Computer Science/New York
   University) as the so called "test-modify-retest paradigm":

   test-decrement-retest(count, delta, bound) returns

      - TRUE, if "count" can be decrement by "delta" and count >= bound
        after the decrementation;
        as a side effect "count is decremented by "delta"
      - FALSE, otherwise (the value of "count" is not changed) 

   test-increment-retest(count, delta, bound) returns

      - TRUE, if "count" can be increment by "delta" and count <= bound
        after the incrementation;
        as a side effect "count is incremented by "delta"
      - FALSE, otherwise (the value of "count" is not changed) 
      
   Since the two operations can be implemented by using the "mpadd"
   instruction TDR & TIR WORK FULLY PARALLEL - no serialization takes place!

   The following operations are provided:

   CORRECT BEHAVIOR CAN ONLY BE GUARANTEED IF THE USED TYPES ARE SIGNED !!!

   int sbp_tdr(SIG32TYPE *cell, SIG32TYPE delta, SIG32TYPE bound) 
   int sbp_tdr_m0(SIG32TYPE *cell, SIG32TYPE delta, SIG32TYPE bound) 
   int sbp_tdr_m1(SIG32TYPE *cell, SIG32TYPE delta, SIG32TYPE bound) 

   int sbp_tir(SIG32TYPE *cell, SIG32TYPE delta, SIG32TYPE bound) 
   int sbp_tir_m0(SIG32TYPE *cell, SIG32TYPE delta, SIG32TYPE bound) 
   int sbp_tir_m1(SIG32TYPE *cell, SIG32TYPE delta, SIG32TYPE bound) 

   int sbp_tdr1(SIG32TYPE *cell, SIG32TYPE bound)

   sbp_tdr1(cell, bound) is like sbp_tdr_m0(cell, 1, bound) but faster.

   function          uses operation
   -----------------------------------------------
   sbp_t?r           sbp_mpadd
   sbp_t?r_mX        sbp_mpadd_mX
   sbp_tdr1          sbp_mpadd_m0, sbp_syncmax_m1

   EODOKU (for documentation)

*/

/*
   ######################################################################

 			    begin of header file

   ######################################################################
*/

#ifndef _SBP_GOP_H_
#define _SBP_GOP_H_

/* ############### global operations ############### */

/* STGOPDEF is used for definition of stg- and sync-operations */

#define STGOPDEF(operation, modcmd, cell, stval)\
do {\
   asm volatile (modcmd\
		 #operation "\t%0, %1, 0"\
		 : \
		 : "r" (stval),\
		   "r" (cell)\
		 : "cc", "memory"\
		);\
} while(0)

/* LDGOPDEF is used for definition of ldg-operations */

#define LDGOPDEF(operation, modcmd, cell)\
({\
   __typeof__(*(cell)) ___rvalue___;\
   asm volatile (modcmd\
		 #operation "\t%1, 0, %0"\
		 : "=&r" (___rvalue___)\
		 : "r" (cell)\
		 : "cc", "memory"\
		);\
   ___rvalue___;\
})

/* MPGOPDEF is used for definition of mp-operations */

#define MPGOPDEF(operation, modcmd, cell, mpval)\
({\
   __typeof__(*(cell)) ___rvalue___;\
   asm volatile (modcmd\
		 #operation "\t%2, 0, %0"\
		 : "=&r" (___rvalue___)\
		 : "0" (mpval),\
		   "r" (cell)\
		 : "cc", "memory"\
		);\
   ___rvalue___;\
})

/* TMRDEF is used for definition of test-modify-retest-operations */

/*
 * TDR: addcmd1 = sub, addcmd2 = add, brcmd1 = bgt, brcmd2 = ble
 *
 * TIR: addcmd1 = add, addcmd2 = sub, brcmd1 = blt, brcmd2 = bge
 *
 */

#define TMRDEF(addcmd1, addcmd2, brcmd1, brcmd2, modcmd, cell, delta, bound)\
({\
   int ___rvalue___;\
   __typeof__(*(cell)) ___dummy___;\
   asm volatile ("getlo\t0, %0\n\t"\
		 modcmd\
        	 "mpadd\t%2, 0, %0\n\t"\
		 "getlo\t0, %1\n\t"\
        	 #addcmd1 "\t%3, %0, %0\n\t"\
        	 "sub\t%0, %4, r0\n\t"\
        	 #brcmd1 "\t10\n\t"\
		 #addcmd1 "\t%3, r0, %0\n\t"\
        	 "mpadd\t%2, 0, %0\n\t"\
        	 "getlo\t1, %1\n\t"\
        	 #addcmd1 "\t%3, %0, %0\n\t"\
        	 "sub\t%0, %4, r0\n\t"\
        	 #brcmd2 "\t4\n\t"\
		 #addcmd2 "\t%3, r0, %0\n\t"\
        	 "mpadd\t%2, 0, %0\n\t"\
        	 "getlo\t0, %1"\
                 : "=&r" (___dummy___), /* %0 */\
                   "=&r" (___rvalue___) /* %1 */\
                 : "r" (cell),          /* %2 */\
                   "r" (delta),         /* %3 */\
                   "r" (bound)          /* %4 */\
                 : "cc", "memory"\
                );\
   ___rvalue___;\
})

#if 1
extern inline int sbp_tdr1_intern(int *addr, int bound)
{
	int val;
	asm volatile(
		"bmc\t0\n"
		"\tmpadd\t%1, 0, %0\n"
		"\tsyncmax\t%2, %1, 0"
		: "=r" (val)
		: "r" (addr), "r" (bound), "0" (-1)
		: "cc", "memory");
	return val;
}
#else
#define sbp_tdr1_intern(ADDR, BOUND) \
({ \
	int ___sbp_tdr1_val___; \
	asm volatile( \
		"bmc\t0\n" \
		"\tmpadd\t%1, 0, %0\n" \
		"\tsyncmax\t%2, %1, 0" \
		: "=r" (___sbp_tdr1_val___) \
		: "r" (ADDR), "r" (BOUND), "0" (-1) \
		: "cc", "memory"); \
	___sbp_tdr_val___; \
})
#endif


#define M0 "bmc\t0\n\t"
#define M1 "bms\t0\n\t"

#define sbp_ldg_m0(cell)		LDGOPDEF(ldgn, M0 , cell)
#define sbp_ldg_m1(cell)		LDGOPDEF(ldgn, M1 , cell)

#define sbp_stg_m0(cell, stval)		STGOPDEF(stg,    M0, cell, stval)
#define sbp_stg_m1(cell, stval)		STGOPDEF(stg,    M1, cell, stval)

#define sbp_syncand(cell, stval)	STGOPDEF(syncand,   , cell, stval)
#define sbp_syncand_m0(cell, stval)	STGOPDEF(syncand, M0, cell, stval)
#define sbp_syncand_m1(cell, stval)	STGOPDEF(syncand, M1, cell, stval)

#define sbp_syncor(cell, stval)		STGOPDEF(syncor,   , cell, stval)
#define sbp_syncor_m0(cell, stval)	STGOPDEF(syncor, M0, cell, stval)
#define sbp_syncor_m1(cell, stval)	STGOPDEF(syncor, M1, cell, stval)

#define sbp_syncmax(cell, stval)	STGOPDEF(syncmax,   , cell, stval)
#define sbp_syncmax_m0(cell, stval)	STGOPDEF(syncmax, M0, cell, stval)
#define sbp_syncmax_m1(cell, stval)	STGOPDEF(syncmax, M1, cell, stval)

#define sbp_syncadd(cell, stval)	STGOPDEF(syncadd,   , cell, stval)
#define sbp_syncadd_m0(cell, stval)	STGOPDEF(syncadd, M0, cell, stval)
#define sbp_syncadd_m1(cell, stval)	STGOPDEF(syncadd, M1, cell, stval)

#define sbp_mpand(cell, mpval)		MPGOPDEF(mpandn,   , cell, mpval)
#define sbp_mpand_m0(cell, mpval)	MPGOPDEF(mpandn, M0, cell, mpval)
#define sbp_mpand_m1(cell, mpval)	MPGOPDEF(mpandn, M1, cell, mpval)

#define sbp_mpor(cell, mpval)		MPGOPDEF(mporn,   , cell, mpval)
#define sbp_mpor_m0(cell, mpval)	MPGOPDEF(mporn, M0, cell, mpval)
#define sbp_mpor_m1(cell, mpval)	MPGOPDEF(mporn, M1, cell, mpval)

#define sbp_mpmax(cell, mpval)		MPGOPDEF(mpmaxn,   , cell, mpval)
#define sbp_mpmax_m0(cell, mpval)	MPGOPDEF(mpmaxn, M0, cell, mpval)
#define sbp_mpmax_m1(cell, mpval)	MPGOPDEF(mpmaxn, M1, cell, mpval)

#define sbp_mpadd(cell, mpval)		MPGOPDEF(mpaddn,   , cell, mpval)
#define sbp_mpadd_m0(cell, mpval)	MPGOPDEF(mpaddn, M0, cell, mpval)
#define sbp_mpadd_m1(cell, mpval)	MPGOPDEF(mpaddn, M1, cell, mpval)

#define sbp_tdr(c, d, b)		TMRDEF(sub, add, bgt, ble,   , c, d, b)
#define sbp_tdr_m0(c, d, b)		TMRDEF(sub, add, bgt, ble, M0, c, d, b)
#define sbp_tdr_m1(c, d, b)		TMRDEF(sub, add, bgt, ble, M1, c, d, b)

#define sbp_tir(c, d, b)		TMRDEF(add, sub, blt, bge,   , c, d, b)
#define sbp_tir_m0(c, d, b)		TMRDEF(add, sub, blt, bge, M0, c, d, b)
#define sbp_tir_m1(c, d, b)		TMRDEF(add, sub, blt, bge, M1, c, d, b)

#if 1
#define sbp_tdr1(ADDR, BOUND) (sbp_tdr1_intern((int *)(ADDR), (int)(BOUND))>(BOUND))
#else
#define sbp_tdr1(ADDR, BOUND) sbp_tdr(ADDR, 1, BOUND)
#endif

#endif /* ifdef _SBP_GOP_HP */
