/* sbo_startup.types.h */

/* (C) 1995 by bird@cs.uni-sb.de */

#if 0
static char rcsid[] = "@(#)$Id: sbo_types.h,v 1.1.1.1 1997/07/03 09:50:51 bird Exp $"; /* Versionsnummer */
#endif

/*
 * In dieser Datei sind die Typen definiert
 *
 */

/* ###################################################################### */
/* #                                                                    # */
/* # muss mit pgcc-Optionen                                             # */
/* #                                                                    # */
/* #                "-mno-underscores                                   # */
/* #                                                                    # */
/* # compiliert werden                                                  # */
/* #                                                                    # */
/* ###################################################################### */

#ifndef ___SBO_STARTUP_TYPES_H___
#define ___SBO_STARTUP_TYPES_H___

/*
 * timer
 *
 */

typedef struct
{
	unsigned int hi;
	unsigned int lo;
} sbo_time_t;

/*
 * fapex
 *
 */

/* Argumenttyp einer fapex-Funktion */

typedef void *sbo_fapex_fa_t;

/*
 * Typ einer fapex-funktion f()
 *
 * - func_arg ist das letzte Argument von sbo_fapex() und wird von
 *   sbo_fapex() an f() uebergeben;
 *   es ist ein Zeiger auf einen shared (WICHTIG: NICHT PRIVATE) Datenbereich,
 *   der die Argumente fuer f() haelt
 * - fuer "my_id" und "num_procs" gibt es 2 Faelle:
 *
 * my_id liefert fuer den Parent stets 0 und fuer die Kinder eine eindeutige
 *        Zahl zwischen [1..num_procs]
 */

typedef void (* sbo_fapex_f_t)(unsigned int my_id, unsigned int num_procs,
							   sbo_fapex_fa_t func_arg);
	
typedef struct
{
	sbo_fapex_f_t      func;       /* function to execute */
	sbo_fapex_fa_t func_arg;  /* argument for func() */
	unsigned int  num_procs;  /* #procs executing func() parallely */
	int          child_only;  /* TRUE iff only the children execute func()
								          and the parent exits sbo_fapex()
										  without calling func() and without
										  waiting for the children */
	unsigned int     go_ack;  /* used to tell parent that I have seen its
								 fork request
								 syncadd_m0, ldg_m1 */
	unsigned int    id_count; /* used to get a unique id for each process
								 and to tell the parent that all children
								 have started/ended their fapex
								 mpadd_m0/ldg_m1 */
} fapex_data_t;

#endif /* #ifndef ___SBO_STARTUP_TYPES_H___ */
