/* sbo_shmem.h */

/* (c) 1994 by bird@cs.uni-sb.de */

/* $Id: sbo_shmem.h,v 1.1.1.1 1997/07/03 09:50:52 bird Exp $ */

#ifndef ___SBO_SHMEM_H___
#define ___SBO_SHMEM_H___

/* Prototypes of public funtions of shmem management */

/*
 * void *sbo_sm_alloc(unsigned int size)(PUBLIC!)
 *
 * function:
 *
 * - allocate "size" memory cells of shared memory
 *
 * return:
 *
 * - pointer to the first usable memory cell if allocation was succesfull
 * - NULL otherwise
 *
 */

void *sbo_sm_alloc(unsigned int size);

/*
 * void sbo_sm_free(void *user_block) (PUBLIC!)
 *
 * function:
 *
 * - free memory block B (shared memory) "user_block" points to
 * - B must have been allocated by using "sbo_sm_alloc"
 *
 */

void sbo_sm_free(void *user_block);

/*
 * void *sbo_sm_realloc (void *old_block, unsigned int new_size) (PUBLIC!)
 *
 * function:
 *
 * - if old_block == NULL:
 *   behaves like calling sbo_sm_alloc(new_size)
 * - if old_block != NULL:
 *   tries to allocate a block B of size "new_size";
 *   if B could be allocated: copies the contents of "old_block" into B and
 *                            frees "old_block"
 *
 * return:
 *
 * - pointer to the first memory cell of the newly allocated block if it could
 *   be allocated
 * - NULL otherwise
 *
 */

void *sbo_sm_realloc(void *old_block, unsigned int new_size);

#endif /* #ifndef ___SBO_SHMEM_H___ */
