/* sbo.h */

/* (c) 1994 by bird@cs.uni-sb.de */

/* $Id: sbo.h,v 1.1.1.1 1997/07/03 09:50:52 bird Exp $ */


#ifndef ___SBO_H___
#define ___SBO_H___

#include"sbo_types.h"

/*
 * Funktionsprototypen
 *
 */

#include<features.h> /* for C++ freaks - contains definition of __BEGIN_DECLS
					    and __END_DECLS */

__BEGIN_DECLS /* for C++ freaks */

extern void  sbo_start_barrier(void);
extern int   sbo_fapex(unsigned int min_child, unsigned int max_child,
					   int child_only, sbo_fapex_f_t func,
					   sbo_fapex_fa_t func_arg);
extern int   *sbo_multifork(unsigned int childnum);
extern void  sbo_exit(int rc)   __attribute__ ((noreturn));
extern void  _exit(int rc)   __attribute__ ((noreturn));
extern void  sbo_wait(unsigned int numwait);
extern int   sbo_get_numprocs(void);
extern int   sbo_get_remprocs(void);
extern int   sbo_get_id(void);
extern void *sbo_shmalloc(unsigned int size);
extern void *shmalloc(unsigned int size);
extern void  sbo_shfree(void *ptr);
extern void  shfree(void *ptr);
extern void *sbo_shrealloc(void *old_ptr, unsigned int new_size);
extern void *shrealloc(void *old_ptr, unsigned int new_size);
extern void  sbo_m_time(sbo_time_t *time);
extern void  sbo_u_time(sbo_time_t *time);
extern void  sbo_m_rtime(sbo_time_t *time);
extern void  sbo_u_rtime(sbo_time_t *time);
extern int   sbo_writef(char *format, ...);
extern int   sbo_pwritef(char *format, ...);
extern int   sbo_fwritef(int fd, char *format, ...);
extern int   sbo_fpwritef(int fd, char *format, ...);

#include"sbo_shmem.h"

__END_DECLS /* for C++ freaks */

#include<stdio.h>
#include<syscall.h>

#define sbo_pprintf(f, a...) printf("##%4d: " f, sbo_get_id() , ## a)
#define pprintf(f, a...) printf("##%4d: " f, sbo_get_id() , ## a)

/*
 * ###########################################################################
 *
 * 			  Semantik der Funktionen/Makros
 *
 * ###########################################################################
 *
 */


/*
 * void sbo_start_barrier(void)
 *
 *    DIESE FUNKTION HAT NUR WIRKUNG IN DEM PROGRAMMIERMODELL,
 *    BEI DEM ALLE PROZESSOREN ZU BEGINN LOSLAUFEN 
 *
 * Funktion:
 *
 *    - dient dazu, alle der Anwendung zu Verfuegung stehenden Prozesse
 *       genau einmal zu synchronisieren
 *
 * Vorbedingungen:
 *
 *    - muss von allen Prozessen aufgerufen werden, da sonst die aufrufenden
 *      Prozesse haengenbleiben
 *
 */


/*
 * int *sbo_multifork(unsigned int childnum)
 *
 *
 * Funktion:
 *
 *    - falls childnum > 0:
 *	startet childnum neue Prozesse mit selbem Kontext wie der Parent (d.h.
 *	gleiche Registerinhalte, gleiche Speicherinhalte, gleiche Filedeskrip-
 *	toren usw.)
 *
 *    - falls childnum == 0:
 *      startet die restlichen der Anwendung zu Verfuegung stehenden Prozesse
 *	mit selbem Kontext wie der Parent (d.h. gleiche Registerinhalte, 
 *	gleiche Speicherinhalte, gleiche Filedeskriptoren usw.)
 *
 * Vorbedingungen:
 *
 *    - Prozess laeuft auf dem pstack
 *
 * Ergebniswert (dereferenziert):
 *
 *    >0: erfolgreiches fork (Prozess ist Parent; Ergebnis (dereferenziert)
 *        ist Zahl der geforkten Prozesse; die SBOIDs der Kinder stehen
 *        ab dem zweiten Wort in dem zurueckgelieferten Speicherbereich
 *        (der mit "sbo_shfree()" wieder freigegeben werden kann)
 *
 *     (IN DEN FOLGENDEN FAELLEN KANN DER ZURUECKGELIEFERTE SPEICHERBEREICH
 *      NICHT FREIGEGEBEN WERDEN !!!)
 *
 *     0: erfolgreiches fork (Prozess ist Child); in *(Ergebniswert+1)
 *        steht der Index des Kindes in der an den Parent zurueckgelieferten
 *        Tabelle (Wert zwischen 1 und der Zahl der geforkten Kinder)
 *    -1: es hat kein fork stattgefunden (Prozess ist Parent)
 *        (zu wenig Platz auf dem stack, um die Register zu retten)
 *    -2: es hat kein fork stattgefunden (Prozess ist Parent)
 *        (childnum war 0 und es standen keine freie Prozessoren mehr zu
 *         Verfuegung)
 *    -3: es hat kein fork stattgefunden (Prozess ist Parent)
 *	  (childnum war > 0 und es standen weniger als childnum freie
 *         Prozessoren zu Verfuegung)
 *    -4: es hat kein fork stattgefunden (Prozess ist Parent)
 *        (Kollision sheap-><-pmheap)
 *
 */


/*
 * void sbo_exit(int rc)/void _exit(int rc)
 *
 * Funktion:
 *
 *    - beendet einen Prozess
 *    - falls der Prozess der letzte laufende Prozess der Anwendung ist,
 *      wird die Anwendung beendet und rc an das Betriebssystem uebergeben
 *    - falls der Prozess nicht der letzte laufende Prozess der Anwendung ist,
 *      wird er in eine Warteschlange gehaengt und kann wieder geforkt werden;
 *      rc wird in diesem Fall ignoriert
 */


/*
 * void sbo_wait(unsigned  int numleft)
 *
 * Funktion:
 *
 *    - Wenn numleft > 0 wird gewartet, bis sich alle bis auf maximal numleft
 *      viele Prozesse der Anwendung beendet haben
 *    - Wenn numleft == 0 passiert nichts
 *
 */


/*
 * int sbo_get_numprocs(void)
 *
 * Funktion:
 *
 *    - liefert die Zahl der der Anwendung zu Verfuegung stehenden Prozesse
 *
 *
 */


/*
 * int sbo_get_remprocs(void)
 *
 * Funktion:
 *
 *    - liefert die Zahl der der Anwendung zu Verfuegung stehenden Prozesse
 *    - DER WERT DER FUNKTION STELLT NUR EINE MOMENTAUFNAHME DAR,
 *      d.h. ruft ein Prozess p, die Funktion zweimal auf und erhaelt
 *      Rueckgabewerte r1 und r2 und fuehrt zwischen den beiden Aufrufen ein
 *      anderer Prozess q ein "sbo_multifork()" oder ein "sbo_exit()" aus,
 *      dann ist r1 != r2 !!!
 *
 */


/*
 * int sbo_get_id(void)
 *
 * Funktion:
 *
 *    - liefert die Id des Prozesses, mit Hilfe derer er von jedem anderen
 *      Prozess der Anwendung unterschieden werden kann
 *
 */


/*
 * void *sbo_shmalloc(unsigned int size)/void *shmalloc(unsigned int size)
 *
 * Funktion:
 *
 *    - allokiert "size" konsekutive Speicherzellen im shared Speicher
 *
 * Ergebnis:
 *
 *    - Zeiger auf die erste Zelle des allokierten Speichers, falls genuegend
 *      Speicher vorhanden war
 *    - NULL, falls nicht mehr genuegend Speicher vorhanden war
 *
 */


/*
 * void sbo_shfree(void *ptr)/void sbo_shfree(void *ptr)
 *
 * Funktion:
 *
 *    - gibt den Speicherbereich, auf den "ptr" zeigt,  frei 
 *
 * Vorbedingungen:
 *
 *    - der Speicherbereich wurde mit Hilfe von "sbo_shmalloc()" allokiert
 *
 */ 

/*
 * void *sbo_shrealloc(void *old_ptr, unsigned int new_size)/
 * void *shrealloc(void *old_ptr, unsigned int new_size)
 *
 * Funktion:
 *
 *   - falls old_ptr == NULL: wie sbo_shmalloc()
 *   - falls old_ptr != NULL:
 *     versucht einen neuen Speicherblock NB der Groesse "new_size" zu
 *     allokieren
 *     falls NB allokiert werden konnte, wird der Inhalt des Speicher-
 *     blocks OB  auf den "old_ptr" zeigt nach NB kopiert und OB freigegeben
 *
 * Vorbedingungen:
 *
 *   - falls old_ptr != NULL, dann muss der Speicherblock, auf den "old_ptr"
 *     zeigt, mit "sbo_shmalloc" allokiert worden sein
 *
 * Ergebnis:
 *
 *   - Zeiger auf die erste Speicherzelle des neu allokierten Speicherblocks,
 *     falls dieser allokiert werden konnte
 *   - NULL sonst
 *
 */


/*
 * extern void  sbo_m_time(sbo_time_t *time)
 *
 * Funktion:
 *
 *   - absoluter 64-Bit Millisekundentimer
 *
 * Ergebnis:
 *
 *   - liefert die oberen  32 Bit des Zeitwertes in time->hi
 *             die unteren 32 Bit des Zeitwertes in time->lo zurueck
 *
 */


/*
 * extern void  sbo_u_time(sbo_time_t *time)
 *
 * Funktion:
 *
 *   - absoluter 64-Bit Mikrosekundentimer
 *
 * Ergebnis:
 *
 *   - liefert die oberen  32 Bit des Zeitwertes in time->hi
 *             die unteren 32 Bit des Zeitwertes in time->lo zurueck
 *
 */


/*
 * extern void  sbo_m_rtime(sbo_time_t *time)
 *
 * Funktion:
 *
 *   - relativer 64-Bit Millisekundentimer (Zeit ab Programmstart)
 *
 * Ergebnis:
 *
 *   - liefert die oberen  32 Bit des Zeitwertes in time->hi
 *             die unteren 32 Bit des Zeitwertes in time->lo zurueck
 *
 */


/*
 * extern void  sbo_u_rtime(sbo_time_t *time)
 *
 * Funktion:
 *
 *   - relativer 64-Bit Mikrosekundentimer (Zeit ab Programmstart)
 *
 * Ergebnis:
 *
 *   - liefert die oberen  32 Bit des Zeitwertes in time->hi
 *             die unteren 32 Bit des Zeitwertes in time->lo zurueck
 *
 */


/*
 * int sbo_writef(char *format, ...)
 * int sbo_pwritef(char *format, ...)
 * int sbo_fwritef(int fd, char *format, ...)
 * int sbo_fpwritef(int fd, char *format, ...)
 *
 * THESE FUNCTIONS MAY BE CALLED BY PROCESSES CREATED BY USING sbo_fapex()
 *
 * function:
 *
 *    - writes a formatted sequence S of characters to stdout (sbo_writef()/
 *      sbo_pwritef()) or to the file specified by descriptor fd
 *      (sbo_fwritef/sbo_fpwritef());
 *      fd must have been obtained by using the system call open()
 *    - the p-variants (sbo_pwritef()/sbo_fpwritef()) additionally write
 *      the processor-id (as obtained by calling sbo_get_id()) at the
 *      beginning of S
 *
 *    - formating follows the principles of printf() with some
 *      exceptions (cf. printf()-man page):
 *
 *      + the additional conversion character "b" specifies a conversion  
 *		  to binary representation                                        
 *		+ the flag "#" is not supported                                   
 *		+ the precision field is not supported                            
 *		+ floating point conversion (conversion characters (f, e, E, g, G)
 *        is not supported
 *
 * return:
 *
 *    -  total number of written characters in case of success
 *    -  -1 in case of failure (S may be written partially to stdout (fd))
 *
 * remark:
 *
 *    - these functions use a buffer B of size 160 (2 lines on a 80 column
 *      terminal) to build up the formatted sequence of characters;
 *      this implies that every 160 characters B is written to stdout (fd)
 *      even if S is longer;
 *      therefore S may be truncated in several subsequence which may cause
 *      unexpected effects if several processors write simultaneously to
 *      stdout (fd)
 *
 */


/*
 * int sbo_pprintf(char *format, ...)/int pprintf(char *format, ...)
 *
 * Funktion:
 *
 *    - wie printf(), gibt aber zu Beginn die Nummer des aufrufenden
 *      Prozesses aus
 *
 */ 

/*
 * ###########################################################################
 *
 * 			  Inline Funktionen
 *
 * ###########################################################################
 *
 */

extern inline void *sbo_shmalloc(unsigned int size)
{
	return (void *)sbo_sm_alloc(size);

} /* sbo_shmalloc() */

extern inline void *shmalloc(unsigned int size)
{
	return (void *)sbo_sm_alloc(size);

} /* shmalloc() */

extern inline void  sbo_shfree(void *ptr)
{
	sbo_sm_free(ptr);
	
} /* sbo_shfree */

extern inline void  shfree(void *ptr)
{
	sbo_sm_free(ptr);

} /* shfree */

extern inline void *sbo_shrealloc(void *old_ptr, unsigned int new_size)
{
	return sbo_sm_realloc(old_ptr, new_size);

} /* sbo_shrealloc */

extern inline void *shrealloc(void *old_ptr, unsigned int new_size)
{
	return sbo_sm_realloc(old_ptr, new_size);

} /* shrealloc */

extern inline void  _exit(int rc)
{
	sbo_exit(rc);

} /* _exit */

extern inline void sbo_u_time(sbo_time_t *time)
{
	sys_get_extimer((unsigned *)time);
	
} /* sbo_u_time() */


#endif /* #ifdef ___SBO_H___ */
