#ifndef __PGCC_DEPEND_H__
#define __PGCC_DEPEND_H__

/* Der Compiler braucht maximal soviel Speicherzellen hinter pgcc_sphi */
#define PGCC_STACK_RESERVE (20+30+1)

/* Bei einem Stack-Overflow wird der PC mit diesem Offset vom pgcc_sphi
   gespeichert */
#define PGCC_PC_SAVE_OFFSET (PGCC_STACK_RESERVE-1)

/* Wird beim Rcksprung aus der stack_overflow-Routine auf die vom Compiler
   in pgcc_sphi+PGCC_PC_SAVE_OFFSET gespeicherte Rcksprungadresse addiert. */

/* Mit Wiederholung des Stack-Checks */
#define PGCC_STACK_OVERFLOW_RETURN_OFFSET_CHECK -3

/* Ohne Wiederholung des Stack-Checks */
#define PGCC_STACK_OVERFLOW_RETURN_OFFSET 1

/* Rcksprung aus einer Routine mit x Parametern auf dem Stack
   Vorsicht: x < (1<<13) */
#define PGCC_ASM_RETURN(x) bmc 0; popg pgcc_sp, PC; add pgcc_sp, -x, pgcc_sp

/* Wird von der stack_overflow-Routine benutzt. */

#define PGCC_STACK_OVERFLOW_SAVE_REGS_ASC \
DOREG(pgcc_sc)\
DOREG(pgcc_ret)\
DOREG(pgcc_par1)\
DOREG(pgcc_par2)\
DOREG(pgcc_par3)\
DOREG(pgcc_par4)

#define PGCC_STACK_OVERFLOW_SAVE_REGS_DESC \
DOREG(pgcc_par4)\
DOREG(pgcc_par3)\
DOREG(pgcc_par2)\
DOREG(pgcc_par1)\
DOREG(pgcc_ret)\
DOREG(pgcc_sc)


/* Wird in ppp_multifork benutzt */

#define PGCC_NUM_CALL_SAVED_REGS 20

#define PGCC_CALL_SAVED_REGS_ASC \
DOREG(pgcc_fp)\
DOREG(R13)\
DOREG(R14)\
DOREG(R15)\
DOREG(R16)\
DOREG(R17)\
DOREG(R18)\
DOREG(R19)\
DOREG(R20)\
DOREG(R21)\
DOREG(R22)\
DOREG(R23)\
DOREG(R24)\
DOREG(R25)\
DOREG(R26)

#define PGCC_CALL_SAVED_REGS_DESC \
DOREG(R26)\
DOREG(R25)\
DOREG(R24)\
DOREG(R23)\
DOREG(R22)\
DOREG(R21)\
DOREG(R20)\
DOREG(R19)\
DOREG(R18)\
DOREG(R17)\
DOREG(R16)\
DOREG(R15)\
DOREG(R14)\
DOREG(R13)\
DOREG(pgcc_fp)

/* Usage:
#define DOREG(x) asm("pshg\t" ##x", usp")
PGCC_STACK_OVERFLOW_SAVE_REGS_DESC
#undef DOREG
*/

#ifdef PGCC_STRINGIFY_REGS
#define PGCC_STRINGIFY(x) ##x
#else
#define PGCC_STRINGIFY(x) x
#endif

/* Register, welches ohne gerettet zu werden, von der stack_overflow-Routine
   benutzt werden kann */
#define PGCC_STACK_OVERFLOW_REG PGCC_STRINGIFY(R12)

#endif /* __PGCC_DEPEND_H__ */
