
typedef MD_lock_t p4_lock_t;

#define p4_lock_init(l)  MD_lock_init(l)
#define p4_lock(l)       MD_lock(l)
#define p4_unlock(l)     MD_unlock(l)

struct p4_mon_queue;  /* for c++ folks */
struct p4_monitor {
    p4_lock_t mon_lock;
    struct p4_mon_queue *qs;
};

typedef struct p4_monitor p4_monitor_t;

struct p4_mon_queue {
    int count;
    p4_lock_t delay_lock;
};

/* SBP - CHANGE */

#ifndef SBPRAM

struct p4_getsub_monitor {
    struct p4_monitor m;
    int sub;
};

typedef struct p4_getsub_monitor p4_getsub_monitor_t;

#else /* definition for SBPRAM */

typedef sbp_parloop_t p4_getsub_monitor_t;

extern inline int p4_getsub_init(p4_getsub_monitor_t *gs)
{
	sbp_parloop_init(gs);
	return 0;
	
} /* p4_getsub_init() */

extern inline P4VOID p4_getsubs(gs, s, max, nprocs, stride)
p4_getsub_monitor_t *gs;
int *s, max, nprocs, stride;
{
	*s = sbp_parloop(gs, max, nprocs, stride);
	
} /* p4_getsubs() */

#endif /* ifndef SBPRAM */

/* SBP - END OF CHANGE */

#define p4_getsub(gs,s,max,nprocs) p4_getsubs(gs,s,max,nprocs,1)

/* SBP - CHANGE */

#ifndef SBPRAM

struct p4_barrier_monitor {
    struct p4_monitor m;
};

typedef struct p4_barrier_monitor p4_barrier_monitor_t;

#else /* definition for SBPRAM */

typedef sbp_barrier_t p4_barrier_monitor_t;

extern inline int p4_barrier_init(p4_barrier_monitor_t *b)
{
	sbp_barrier_init(b);
	return 0;

} /* p4_barrier_init() */


extern inline P4VOID p4_barrier(b, nprocs)
p4_barrier_monitor_t *b;
int nprocs;
{
	sbp_barrier(b, nprocs, NULL, NULL);

} /* p4_barrier() */

#endif /* ifndef SBPRAM */

/* SBP - END OF CHANGE */

struct p4_askfor_monitor {
    struct p4_monitor m;
    int pgdone;
    int pbdone;
};

typedef struct p4_askfor_monitor p4_askfor_monitor_t;
