#ifdef GLOBAL
#define PUBLIC
#else
#define PUBLIC extern
#endif

/* SBP - CHANGE */

#ifndef SBPRAM

/* Debugging information */

PUBLIC char procgroup_file[100];
PUBLIC char bm_outfile[100];
PUBLIC char rm_outfile_head[100];
PUBLIC char whoami_p4[100];
PUBLIC int  debug_level, remote_debug_level;
PUBLIC int  logging_flag;

/* Other global data */

PUBLIC char local_domain[100];
PUBLIC int  globmemsize;
PUBLIC int  sserver_port;
PUBLIC int  no_remotes;

#else /* definitions for SBPRAM */

#   ifdef GLOBAL
#   define INIT0 = 0
#   else
#   define INIT0
#   endif

/* Debugging information */

PUBLIC shared  char procgroup_file[100];
PUBLIC shared  char bm_outfile[100];
PUBLIC private char whoami_p4[20]; /* 20 should be enough for us */
PUBLIC private int  debug_level;   /* can't be declared "shared" since this
									  variable can be changed via
									  "p4_set_debug_level" by each process
									  individually */
PUBLIC shared  int  logging_flag;

/* some SBPRAM-specific variables */

PUBLIC shared int sbpp4_smqsize;  /* holds the size of one shared
									 memory message passing queue */
PUBLIC shared int sbpp4_smbqsize; /* holds the size of the broadcast queue
									 for shared	memory message passing */
PUBLIC private int sbpp4_smbq_snr INIT0; /* holds the number of broadcast
											messages the process has sent but
											not yet	received */
PUBLIC shared int sbpp4_slaves_in_procgroup; /* holds the number of slaves in a
												procgroup if no procgroup file
												is specified */
#endif

/* SBP - END OF CHANGE */

#ifdef SYSV_IPC
PUBLIC int sysv_num_shmids;
PUBLIC int sysv_shmid[P4_MAX_SYSV_SHMIDS];
PUBLIC int sysv_semid0;
#endif

#ifdef SP1_EUI
PUBLIC int eui_numtasks;
PUBLIC int eui_mynode;
#endif

#ifdef SP1_EUIH
PUBLIC int euih_numtasks;
PUBLIC int euih_mynode;
#endif

/* SBP - CHANGE */

/*
 * moved the following definitions from "p4_defs.h" to "p4_globals.h"
 * ==> there won't be multiple occurrences of one of these variables in
 * different object files ("p4_defs.h" is included by every "p4_*.c"-file !!!)
 *
 */

#ifndef SBPRAM

PUBLIC struct p4_global_data *p4_global;
PUBLIC struct local_data *p4_local;
PUBLIC struct listener_data *listener_info;

#else

PUBLIC shared  struct p4_global_data *p4_global;
PUBLIC private struct local_data *p4_local;

#endif

/* SBP - END OF CHANGE */
