#ifndef _P4_H_
#define _P4_H_

#include <ctype.h>
#include <stdio.h>

#if defined(RS6000)  ||  defined(SYMMETRY_PTX)
#include <sys/select.h>
#endif

/* SBP - CHANGE */

#include "p4_config.h"

#ifndef SBPRAM

/* for xdr  -  includes netinet/in.h and sys/types.h */
#include <rpc/rpc.h>      

#include <signal.h>

#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* SBP - END OF CHANGE */

#include <errno.h>
#include <sys/time.h>

/* SBP - CHANGE */

#ifndef SBPRAM

#include <pwd.h>

#endif

/* SBP - END OF CHANGE */

#include <fcntl.h>

/* SBP - CHANGE */

/* we need "p4_config.h" before #include <rpc/rpc.h> */

/* #include "p4_config.h" */

/* SBP - END OF CHANGE */

#include "p4_MD.oldqueue.h"
#include "p4_mon.h"
#include "p4_sr.h"

#include "p4_funcs.h"

#ifndef P4_DPRINTFL

#define p4_dprintfl

#endif

#include "alog.h"

#include "usc.h"
#define p4_ustimer() usc_clock()
#define p4_usrollover() usc_MD_rollover_val

/* SBP - CHANGE */

#ifndef SBPRAM

#define HOSTNAME_LEN 64

#else

#define HOSTNAME_LEN 10 /* 10 is enough for us */

#endif

/* SBP - END OF CHANGE */

struct p4_procgroup_entry {
    char host_name[HOSTNAME_LEN];
    int numslaves_in_group;

/* SBP - CHANGE */

#ifndef SBPRAM
/* the following two items aren't used by us, but are referred to somewhere */

    char slave_full_pathname[100];
    char username[10];

#else

    char *slave_full_pathname;
    char *username;

#endif

/* SBP - END OF CHANGE */

};

/* SBP - CHANGE */

#ifdef SBPRAM
#define P4_MAX_PROCGROUP_ENTRIES 1 /* we have only local processes */
#else
#define P4_MAX_PROCGROUP_ENTRIES 256
#endif

/* SBP - END OF CHANGE */


struct p4_procgroup {
    struct p4_procgroup_entry entries[P4_MAX_PROCGROUP_ENTRIES];
    int num_entries;
};

#endif
