/* Syscall interface */

register int callnr asm("pgcc_ret");

#define SYSCALL(NR, RETTYPE, NAME, PROTO, PARM) \
extern inline RETTYPE sys_##NAME PROTO \
{ \
	callnr = NR; \
	return (RETTYPE) internal_syscall PARM; \
}

SYSCALL(0, int, open, (const char *file, int mode, int flags), (file, mode, flags))
SYSCALL(1, int, read, (int fd, void *buffer, int number), (fd, number))
SYSCALL(2, int, write, (int fd, const void *buffer, int number), (fd, buffer, number))
SYSCALL(3, int, close, (int fd), (fd))
SYSCALL(4, int, lseek, (int fd, int offset, int origin), (fd, offset, origin))
SYSCALL(5, int, abort, (int pc, int reason), (pc, reason))
SYSCALL(6, int, getnr, (void), ())
SYSCALL(7, int, exit, (void), ())
SYSCALL(8, void *, shmalloc, (int nwords), (nwords))
SYSCALL(9, int, getct, (void), ())
SYSCALL(10, int, smp, (int address, int wert), (address,wert))
SYSCALL(11, int, get_extimer, (void), ())
