/* -*-mb0-c-*- */
/* FILE:	prass.c
   DESCRIPTION:	Assembler for SB-PRAM, compatible to GNU as
   AUTHOR:	Stefan Franziskus (stefan)
   VERSION:	0.1
   DATE:	Sept 8, 1993
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "define.h"
#include "coff.h"
#include "gstab.h"

/* global vars */

int line;			    /* line number in File */
int quietflag=0;			/* Flag to suppress errors and warns */
int verbose=0;

char *tokenmnem[]={"BEFEHL", "ZAHL","FLOATNUM", "REG", "OPERAT", "CONDIT", "LABEL", "F_ENDE", "RANGE", "DIREC", "STRNG", "DATBEFEHL", "OPER", "KLAUF", "KLZU","SPECBEFEHL","SYMBOL", "DOT", "EQUAL", "EOTOK" };

long operatcodes[]={3L,1L,2L,0L};

char *errstr[]=
{
    #define ERRMSG(a,b,c) a,
    #include "errors.h"
    #undef ERRMSG
};

char outfilename[STRINGLEN], infilename[STRINGLEN];

FILE *infile, *outfile;			/* corresp. file descr */
FILE *dumpfile;                 /* Datei fuer Listing */

char zeile_cp[ZEILELAENG];      /* Kopie dieser Zeile */
char list_strng[ZEILELAENG];    /* String f"ur .LST Ausgabe des opc */

char path_string[STRINGLEN];    /* for degubbing */
int debugflags;

int first_zeile;                /* Flag ob erste Zeile */
int list_flag;                  /* flag ob in list_strng was gueltiges */

int anz_token;                  /* Anzahl der Tokens in der Liste der freien */
struct token *tokens[TOKENANZ]; /* Feld von Zeigern auf freie Tokens */
struct token *token_anf;        /* Anfang des Speicherbereichs der Tokens */
struct token puttoken[10];      
struct token *putptr;

int anz_lab;                    /* Anzahl von Labels in der Liste der freien */
struct label *frelbl[MAXLABELANZ]; /* Feld von Zeigern auf freie labels */
struct label *frelbl_anf;       /* Anfang des Speicherbereichs der Labels */
struct label *lab_list[HASHANZ];/* Liste der definierten Labels */

int z_akt;                      /* Zeilennummer beim parsen */ 
int zeilnr;                     /* Nummer der aktuellen Eingabezeile */
int spaltnr;                    /* Nummer der aktuellen Spalte */
int zeilenende,z_ende=1;        /* Flag fuer Zeilenende */
int file_ende;                  /* Flag fuer Fileende */
int scndrun=0;                  /* Flag fuer ersten/zweiten Pass des Assemblers */ 
int defstring;                  /* Flag fuer getsym: keine Ersetzung; Rueckgabe */ 
int defn;                       /* Ob Ersetzung erlaubt (0) oder nicht */
int errcnt;                     /* Anzahl aufgetretener Fehler */
long codeline,dataline,bssline;  /* Zaehler fuer erzeugten Code */
long codelen,datalen,bsslen;
	       
int komment;                    /* Flag ob innerhalb eines Kommentars */

char sdummy[STR_LAENG];         /* dummy string fuer ersetzungen */
char sdummy2[STR_LAENG];        /* ebenso */

char labelwort[LABELLAENG];     /* String um Labelnamen aufzunehmen */

char strngwort[STRINGLEN];     /* String um einen Strngnamen aufzunehmen */
 
int range;                      /* aktueller Bereich */
long rl;
int ldgn_lock=0;

struct befehl com[]= 
{
	 #define COMMAND(a,b,c,d,e,f) #a,b,c,{A_##d,A_##e,A_##f},
    #include "commands.h"       /* commands.h enthaelt alle Befehle incl. */
    #undef COMMAND              /* Opcodes und Argumente                  */
};

struct stab stab_debug;

extern struct section *sct;
extern struct section *sct_beg;
long akt_sct_num;                  /* Stelle in der Symboltabelle */
long rel_sct_num;

extern int init();
extern void coff_init();
extern int coff_file_out();

/* Error Handling Procedure
*/

void errmsg(num)
ERRORS num;			/* Error number */

{ if(!quietflag && stderr)
  { if(num < ERRNUM)
     fprintf(stderr,"PRASS: Error %2d in Line %4d\n%s\n",num,line,errstr[num]);
    else
     fprintf(stderr,"PRASS: Unknown Error in Line %4d\nError code: %2d\n",line,num);
  }
}

/* Evaluate Command Line Pars, subset of pars for as, -T added
   accepted format [-o <outfilename>] [-T] [-W] <infilename>
   -o sets name of output file to <outfilename>, default is a.out
   -T switches to two pass run, default is one pass run
   -W suppresses Warning/Error messages
   -d Debug messages on
   <infilename> is the name of the input file,1
   can be -- to represent stdin but then -T is forbidden
*/

EVALRESULT eval_params(argc,argv)
int argc;
char *argv[];

{ int par=1;			/* number of actual parameter */
  EVALRESULT result=TWO_PASS_RUN;
  int lastpar=0;		/* flag for last parameter */

  strcpy(infilename,STDINCODE);
  strcpy(outfilename,"a.out");
  quietflag=0;

  while((par<argc) && (!lastpar))
  {
	  if(*argv[par]=='-')
		  switch(*(argv[par]+1))
		  { 
		  case 'o':
			  if((++par)<argc) 
				  strcpy(outfilename,argv[par]);
			  else
			  { 
				  errmsg(TOO_FEW_PARS_ERR);
				  result=PAR_ERROR;
				  lastpar=1;
			  }
			  break;
		  case 'T':
			  result=TWO_PASS_RUN;
			  break;
		  case 'S':
			  result=ONE_PASS_RUN;
			  break;
		  case 'W':
			  quietflag=1;
			  break;
			  
		  case 'd':
			  if((++par)<argc)
				  debugflags=(int)argv[par];
			  if(*argv[par]=='-')
			  {
				  debugflags=1;
				  par--;
			  }
			  break;
		  case 'c':
			  check_commandfile();
			  exit(0);
			  break;
		  case 'v':
			  verbose=1;
			  break;
		  case '-':
			  strcpy(infilename,STDINCODE);
			  lastpar=1;
			  break;

		  default:
			  errmsg(ILL_PAR_ERR);
			  break;
		  }
	  else
	  { 
		  strcpy(infilename,argv[par]);
		  lastpar=1;
	  }
	  par++;
  }
  if((!strcmp(infilename,STDINCODE)) && (result==TWO_PASS_RUN))
  { result=PAR_ERROR;
    errmsg(ILL_TWO_PASS_ERR);
  } 
  return(result);
}

void check_commandfile()
{
	int i;
	for(i=0;i<BEFANZ-1;i++)
	{
		if(strcmp(com[i].name,com[i+1].name)<0)
			printf("%d: %s  Ok\n",i,com[i].name);
		else
			printf("Error at %d: %s\n",i,com[i].name);
	}
	printf("%d: %s  Ok\n",i,com[i].name);
}


/**************************************************************************
 hol_label liefert einen Zeiger auf einen Label Record und haengt diesen
 aus der Liste der freien Labels aus, falls noch welche frei sind, sonst
 wird NULL zurueckgegeben.
 **************************************************************************/
 
struct label *hol_label()
{ if (anz_lab) return(frelbl[--anz_lab]);
  else return(NULL);
}
 
 
/**************************************************************************
 bring_label haengt *zgr in die Liste der freien Labels ein, falls dies
 moeglich ist. Rueckgabewert ist 1 bei Erfolg, 0 sonst.
 **************************************************************************/
 
int bring_label(zgr)
struct label **zgr;
{ register int success=1;         /* Rueckgabewert */
 
  if(*zgr!=NULL)
  { if (anz_lab<MAXLABELANZ)
    { frelbl[anz_lab++]= *zgr;
	  *zgr=NULL; }
    else success=0;
  }
  return(success);
}

/**************************************************************************
 hol_token liefert einen Zeiger auf einen Token Record und haengt diesen
 aus der Liste der freien Tokens aus, falls noch welche frei sind, sonst
 wird NULL zurueckgegeben.
 **************************************************************************/
 
struct token *hol_token(void)
{ if (anz_token) return(tokens[--anz_token]);
  else return(NULL);
}
 
 
/**************************************************************************
 bring_token haengt *zgr in die Liste der freien Tokens ein, falls dies moeg-
 lich ist. Rueckgabewert ist 1 bei Erfolg, 0 sonst.
 **************************************************************************/
 
int bring_token(struct token *zgr)

{ register int success=1;         /* Rueckgabewert */
 
  if(zgr!=NULL)
  { if (anz_token<TOKENANZ) 
	{ 
		tokens[anz_token++]= zgr;
		zgr=NULL; 
	}
    else success=0;
  }
  return(success);
}
 

int calc(vptr,optr)
long **vptr;
char **optr;
	
{
	switch(**optr)
	{
	case '+':
		*((*vptr)-1)= *((*vptr)-1) + **vptr;
		break;
	case '-':
		*((*vptr)-1)= *((*vptr)-1) - **vptr;
		break;
	case '*':
		*((*vptr)-1)= *((*vptr)-1) * **vptr;
		break;
	case '/':
		*((*vptr)-1)= *((*vptr)-1) / **vptr;
		break;
	case '%':
		*((*vptr)-1)= *((*vptr)-1) % **vptr;
		break;
	case '<':
		*((*vptr)-1)= *((*vptr)-1) << **vptr;
		break;
	case '>':
		*((*vptr)-1)= *((*vptr)-1) >> **vptr;
		break;
	case '_':
		**vptr=**vptr * (-1);
		(*vptr)++;		
		break;
	case '~':
		**vptr= ~(**vptr);
		(*vptr)++;
		break;
	case '|':
		*((*vptr)-1)= *((*vptr)-1) | **vptr;
		break;
	case '&':
		*((*vptr)-1)= *((*vptr)-1) & **vptr;
		break;
	case '^':
		
		break;
		
	default:
		break;
	}
	(*vptr)--;
	(*optr)--;
	
	return(1);
	

}

/**************************************************************************
 direc_set verarbeitet einen Direktiven Token der Rueckgabewert ist bla...
**************************************************************************/

int direc_set(struct token *t, PASSMODE runcnt)
	
{
	int success=1;
    struct token *t_expr, *t_expr2, *t_expr3;
	long code;
	int code_line;
	char sct_name[8];
	char *name;
	char *str_ptr;
	int mode;
	int i,align;
	struct section *sct_ptr;
	int symval;
	int syment_ptr, dummy;
	int zero;
	
	t_expr=hol_token();
	t_expr2=hol_token();
	t_expr3=hol_token();
	
	switch(t->wert)
	{
	case D_ASCII:
	case D_ASCIZ:
		zero = 1 && (t->wert==D_ASCII);
		success=getsym(&t_expr);
		if(debugflags)
			printf("%s %d\n",strngwort,(int)strlen(strngwort));
		str_ptr=strngwort;
		for(i=t_expr->wert;i>zero;--i)
		{
			code=*str_ptr;
			if (runcnt==SECOND_RUN || runcnt==SINGLE_RUN)
				success=success && coff_code_out(code);
			str_ptr++;
			sct->head.s_size++;
		}
		break;
	case D_BYTE:
	case D_INT:
	case D_LONG:
	case D_WORD:
		getsym(&t_expr);
		while((mode=parseaus(t_expr, &symval)))
		{
			if(mode==2 && (runcnt==SECOND_RUN || runcnt==SINGLE_RUN))
				create_relocent(sct->head.s_size, rel_sct_num, 
								t_expr->wert, symval,  R_32DAT);
			code=t_expr->wert;

			if (runcnt==SECOND_RUN || runcnt==SINGLE_RUN)
				success=coff_code_out(code);
			sct->head.s_size++;
			success&=getsym(&t_expr);
		}
		break;
	case D_FLOAT:
		mode=getsym(&t_expr);
		while(t_expr->typ==ZAHL)
		{
			if(mode==2 && (runcnt==SECOND_RUN || runcnt==SINGLE_RUN))
				create_relocent(sct->head.s_size, rel_sct_num, 
								t_expr->wert, symval, R_32DAT);
			code=t_expr->wert;

			if (runcnt==SECOND_RUN || runcnt==SINGLE_RUN)
				success=coff_code_out(code);
			sct->head.s_size++;
			success=success && getsym(&t_expr);
		}
		putsym(&t_expr);
		break;
	case D_BLA:
		getsym(&t_expr);
	case D_BLUB:
		getsym(&t_expr);
	case D_SECTION:
		success=getsym(&t_expr);
		name=strngwort;
		success=success && getsym(&t_expr);
		switch (t_expr->wert)
		{
		case D_TEXT: 
			success=success && search_section(name, STYP_TEXT);
			akt_sct_num=range=sct->section_nr;
			success=success && lab_ins(strngwort,sct->head.s_size,akt_sct_num,range,C_STAT);
			break;
		case D_DATA:
			success=success && search_section(name,STYP_DATA);
			akt_sct_num=range=sct->section_nr;
			success=success && lab_ins(strngwort,sct->head.s_size,akt_sct_num,range,C_STAT);
			break;
		case D_BSS:
			success=success && search_section(name,STYP_BSS);
			akt_sct_num=range=sct->section_nr;
			success=success && lab_ins(strngwort,sct->head.s_size,akt_sct_num,range,C_STAT);
			break;
		}
		break;
	case D_GLOBL:
		success=getsym(&t_expr2);
		if (runcnt==FIRST_RUN || runcnt==SINGLE_RUN)
			lab_ins(labelwort, 0, 0, 0, C_EXT);
			break;
	case D_LCOMM:
	case D_COMM:
		getsym(&t_expr);
/*		strcpy(name,labelwort); */
		getsym(&t_expr2);
		parseaus(t_expr2, &symval);
		getsym(&t_expr3);
		sct_ptr=sct;               /* Pointer auf alte Section retten */
		
		if(t_expr3->typ!=EOTOK)
			{
				search_section(strngwort,STYP_BSS);
				lab_ins(strngwort,sct->head.s_size,sct->section_nr,\
						sct->section_nr,C_STAT);
			}
		else
		{
			if(sct->head.s_flags!=STYP_BSS)
			{
				strcpy(strngwort, ".bss");
				search_section(".bss",STYP_BSS);
				lab_ins(".bss",sct->head.s_size,sct->section_nr,\
						sct->section_nr,C_STAT);
			}
			putsym(&t_expr3);
		};
		akt_sct_num=range=sct->section_nr;
		if (runcnt==FIRST_RUN || runcnt==SINGLE_RUN)
			switch(t->wert)
			{
			case D_LCOMM:
				lab_ins(labelwort,sct->head.s_size,sct->\
						section_nr,0,C_STAT);
				break;
			case D_COMM:
				lab_ins(labelwort,sct->head.s_size,sct->\
						section_nr,0,C_EXT);
				break;
			default:
				break;
			}
		sct->head.s_size+=t_expr2->wert;
		if(sct_ptr!=NULL)
			sct=sct_ptr;       /* Und wieder in der alten Section .... */
		break;
	case D_ALIGN:
		getsym(&t_expr);
		while((mode=parseaus(t_expr, &symval)))
		{
			if(mode==2 && (runcnt==SECOND_RUN || runcnt==SINGLE_RUN))
				create_relocent(sct->head.s_size, rel_sct_num, 
								t_expr->wert, symval, R_32DAT);
			align=sct->head.s_size%t_expr->wert; 
			if(debugflags)
				printf("Align: %d \n",align);
			
			if (align && (runcnt==SECOND_RUN || runcnt==SINGLE_RUN) && \
				sct->head.s_flags!=STYP_BSS)
			{
				align=t_expr->wert-align;
				sct->head.s_size+=align;
				while(align--)
					success=coff_code_out(0);
			}
			success&=getsym(&t_expr);
		}
		break;
	case D_SPACE:
		getsym(&t_expr);
		while((mode=parseaus(t_expr, &symval)))
		{
			if(mode==2 && (runcnt==SECOND_RUN || runcnt==SINGLE_RUN))
				create_relocent(sct->head.s_size, rel_sct_num, 
								t_expr->wert, symval, R_32DAT);
			if (runcnt==FIRST_RUN)
				sct->head.s_size+=t_expr->wert; 
			if(debugflags)
				printf("Space: %d \n",(int)t_expr->wert);
			
			if ((runcnt==SECOND_RUN || runcnt==SINGLE_RUN)) 
				while((t_expr->wert)--)
				{
				if(sct->head.s_flags!=STYP_BSS)
					success=coff_code_out(0);
					sct->head.s_size++;
				}
			success&=getsym(&t_expr);
		}
		break;		
	case D_STAB:
		if(sct==NULL)
			search_section(".text", STYP_TEXT);
		akt_sct_num=range=sct->section_nr;
		
		getsym(&t_expr);
		if(t_expr->typ==STRNG)
		{
			strcpy(stab_debug.string,strngwort);
			getsym(&t_expr);
		}
		else
			strcpy(stab_debug.string,"");
		stab_debug.type=t_expr->wert;
		getsym(&t_expr);
		stab_debug.other=t_expr->wert;
		getsym(&t_expr);
		stab_debug.desc=t_expr->wert;
		getsym(&t_expr);
		if(t_expr->typ!=EOTOK)
			stab_debug.value=t_expr->wert;
		else
		{
			stab_debug.value=0;
			putsym(&t_expr);
		}
		if(sct!=NULL)
		{
			code_line=sct->head.s_size;
			strcpy(sct_name, sct->head.s_name);
		}
		else
		{
			code_line=0;
			strcpy(sct_name, "NULL");
		}

		if(sct!=NULL && (runcnt==SECOND_RUN || runcnt==SINGLE_RUN))
			switch(stab_debug.type)
			{
			case N_SLINE:
			case N_DSLINE:
			case N_BSLINE:
				create_lineno_ent(code_line, stab_debug.desc);
				break;
			case N_SO:
			case N_SOL:
				if(strngwort[strlen(strngwort)-1]=='/')
					strcpy(path_string, strngwort);
				else
				{
					if(stab_debug.string[0]!='/')
					{
						strcpy(stab_debug.string, path_string);
						strcat(stab_debug.string, strngwort);
					}
					if(!(syment_ptr=lab_find(stab_debug.string,
											 &syment_ptr, &dummy)))
						syment_ptr=lab_ins(stab_debug.string, 0, range,
										   0, C_FILE);
					create_lineno_ent(syment_ptr-1, 0); 
				}
				break;
			case N_FUN:
				if(!(syment_ptr=lab_find(stab_debug.string,
										 &syment_ptr, &dummy)))
					syment_ptr=lab_ins(stab_debug.string, stab_debug.value, 
									   range, 0, C_EFCN);
				create_lineno_ent(syment_ptr-1, 0); 
				break;
/*
            case N_RSYM:
				if(!(syment_ptr=lab_find(stab_debug.string,
										 &syment_ptr, &dummy)))
					syment_ptr=lab_ins(stab_debug.string, stab_debug.value, 
									   range, 0, C_REG);
				create_lineno_ent(syment_ptr-1, 0); 
				break;
			case N_GSYM:
			case N_STSYM:
			case N_LCSYM:
*/				
			default:
				break;
			}
		
		break;
	default:
		break;
	}
	bring_token(t_expr); 
	bring_token(t_expr2);
	bring_token(t_expr3);
	
	return(success);
}		

/**************************************************************************
 strhash berechnet die Hashnummer eines Strings als Summe seiner Characters
 modulo einer Zweierpotenz, durch die HASHMASK definiert ist. Die Hash-
 nummer wird zurueckgegeben.
 **************************************************************************/
 
int strhash(c)
register char *c;               /* Zu hashender String */
 
{ register int h=0;               /* Hashnummer */
 
  while(*c!='\0')
  h+=(int)(*c++);
  h&=HASHMASK;
  return(h);
}

/**************************************************************************
 lab_find sucht das label w in der Tabelle der Labels. Bei Erfolg besetzt
 es *zzgr mit der Zeile des Labels und gibt 1 zurueck, sonst 0.
 **************************************************************************/
 
int lab_find(w,zzgr,rzgr)
char *w;                        /* Zu findendes Label ohne LABELZEI */
int *zzgr;                      /* Rueckzugebende Codezeile */
int *rzgr;                      /* range des Labels */
 
{
	int success=0;
	register struct label *zgr;
	
	*zzgr=0L;                     /* Wert vorbesetzen */
	strcpy(sdummy2,w);
	zgr=lab_list[strhash(sdummy2)];     /* Richtige Hashliste suchen */
	while(zgr!=NULL && !success)  /* und durchlaufen */
	{ 
		if(!strcmp(sdummy2,zgr->name)) 
		{ 
			*zzgr=zgr->zeil; 
			*rzgr=zgr->rnge; 
			rel_sct_num=zgr->sct_num;
			success=zgr->syment_nr+1;
		}
		zgr=zgr->naechst;
	}
	if(!success)
	{ 
		zgr=lab_list[strhash(w)];     /* Richtige Hashliste suchen */
		while(zgr!=NULL && !success)  /* und durchlaufen */
		{ 
			if(!strcmp(w,zgr->name)) 
			{ 
				*zzgr=zgr->zeil; 
				*rzgr=zgr->rnge; 
				rel_sct_num=zgr->sct_num;
				success=zgr->syment_nr+1;
			}
			zgr=zgr->naechst;
		}
	}
	
	return(success);
}
 
 
/**************************************************************************
 lab_ins haengt das Label w mit seiner Zeile in die Tabelle der labels ein.
 Bei Erfolg, d.h. Wenn es noch nicht dort war, wird 1 zurueckgeliefert,
 sonst 0.
 **************************************************************************/
 
int lab_ins(w,z,r,sct_name,sclass)
char *w;                        /* Label ohne LABELZEI, das eingehaengt
                                   werden soll */
long z;                          /* Codezeile bzw. Adresszeile, in der das Label steht */
int r;                          /* Range, in dem das Label definiert wird */
char sct_name;
char sclass;
 
{ int success=1;                /* Rueckgabewert */
  register struct label *zgr;   /* Zeiger auf zu kreierendes Label */
  register int nr;              /* Hashnummer des Labels */
  int dummy;                    /* Dummy zum Aufruf von lab_find() */
  int ldummy;                   /* dto */
  int patch_flag=0;
  
  if(lab_find(w,&ldummy,&dummy)) 
	  if(dummy==0){ 
		  sclass=C_EXT;patch_flag=1;}
	  else
		  success=0;
  /*  else */
  /*   if(!anz_lab) success=0; */ /*### Error */
  if(success)
  { 
	  zgr=hol_label();           /* Label holen */
	  strcpy(zgr->name,w);       /* Werte besetzen */
	  zgr->sct_num=akt_sct_num;
	  zgr->zeil=z;
	  zgr->rnge=r;
	  if(!patch_flag)
		  zgr->syment_nr=create_syment(w,z,r,sclass);
	  else
		  zgr->syment_nr=patch_syment(w,z,r,sclass);
	  if (r==0)
	  {
		  zgr->zeil=zgr->syment_nr;
		  zgr->sct_num=0;
	  }
	  nr=strhash(zgr->name);     /* Hashnummer berechnen */
	  zgr->naechst=lab_list[nr]; /* In Liste der def. Labels einhaengen*/
	  lab_list[nr]=zgr;
	  /*     if(!hpush(nr,lab_stack,&lab_sp)) success=0; */
	  success=zgr->syment_nr+1;
  }
  return(success);
}


/**************************************************************************
  parseaus versucht einen unvollstaendig geklammerten regulaeren Ausdruck
  zu pasrsen.
**************************************************************************/

int parseaus(struct token *expr, int *symval)

{
	int success=0;
	
	long stack[100];
	long *stptr;
	char opstack[100];
	char *optr;
	struct token *zgr;
	int exit=0;

	zgr=hol_token();
	
	zgr->typ=expr->typ;
	zgr->wert=expr->wert;

	stptr=stack;
	optr=opstack;
	if (zgr->typ==OPERAT || zgr->typ==SYMBOL || zgr->typ==ZAHL || zgr->typ==DOT)
		success=1;
	
	while(zgr->typ==OPERAT || ((zgr->typ==SYMBOL || zgr->typ==ZAHL || zgr->typ==DOT) && !exit))
	{
		while ((zgr->typ==OPERAT) 
			   && (zgr->wert=='-' || zgr->wert=='~' || zgr->wert=='('))
		{
			if(zgr->wert=='-') zgr->wert='_';
			*++optr=(char)zgr->wert;
			if(!getsym(&zgr))
				success=0;
		}
		
		if (zgr->typ==ZAHL || zgr->typ==SYMBOL || zgr->typ==DOT)
		{
			*++stptr=zgr->wert;
			if(zgr->typ==SYMBOL || zgr->typ==DOT)
			{
				success=(1-success)+2;
				*symval=zgr->wert;
			}
			if(!getsym(&zgr))
				success=0;
			if (zgr->typ==ZAHL || zgr->typ==SYMBOL || zgr->typ==DOT)
				exit=1;
		}
		else /* ERROR */
		{
		/*	bring_token(&zgr);  */
			success=0;
		}
		
		if (zgr->typ==OPERAT)
		{
			while(zgr->wert==')') 
				if(*optr!='(') calc(&stptr,&optr);
				else 
				{
					optr--;
					if(!getsym(&zgr))
						success=0;
				}
		}			
		if (zgr->typ==OPERAT)
		{
			while(isop(zgr->wert)<=isop(*optr) && optr>opstack)
				calc(&stptr,&optr);
			*++optr=(char)zgr->wert;
			if(!getsym(&zgr))
				success=0;	
		}
	}

	putsym(&zgr);
	
	while(optr>opstack)
		calc(&stptr,&optr);
		
	expr->wert=*(stptr);
	
	bring_token(zgr);
 
	return(success);
}

/**************************************************************************
 parsebef versucht einen Befehl zu parsen und Code dafuer zu erzeugen.
 Bei Erfolg ist der Rueckgabewert 1 sonst 0.
**************************************************************************/

int parsebef(struct token *t)

{
	int success=1;
	register long code;        /* hier steht der erzeugte Code drin */
    struct token *arg[3];      /* Zeiger auf Tokens fuer verschiedene Faelle */
	int i;                                     
	long opc;
	int mode=0;
	int symval;
	
	long rx,ry,rz,rd,s2,s2r,i13,i19,rln;
	
	rx=ry=rz=rd=s2=i13=i19=rln=-1;
	opc=com[t->wert].opcode;

	arg[0]=arg[1]=arg[2]=NULL;
	
	for(i=0;i<3;i++)
		switch(com[t->wert].arg[i])
		{
		case A_NIX :
			arg[i]=hol_token();
			break;
		case A_SPEC :
			arg[i]=NULL;
			getsym(&arg[i]);
			if (arg[i]->typ==REG)
			{
				rx=arg[i]->wert;
				getsym(&arg[i]);
				if(arg[i]->typ!=REG) 
					mode=parseaus(arg[i], &symval);
				s2=arg[i]->wert;
				if(mode==2)
						create_relocent(sct->head.s_size, rel_sct_num, s2, 
										symval, R_19ABS);
				if(arg[i]->typ!=REG)
					s2=(s2 & ((1<<14)-1)) | (1<<14);
				opc=(opc | (1<<27));
			}
			else
				if ((mode=parseaus(arg[i], &symval)))
				{
					i19=arg[i]->wert;
					if(mode==2)
						create_relocent(sct->head.s_size, rel_sct_num, i19, 
										symval, R_19ABS);
					i19=i19 & ((1<<20)-1);
					opc=opc | (1<<28);
				}
				else 
					errmsg(INV_PAR_ERR);
			break;
		case A_RL:
			arg[i]=NULL;
			mode=getsym(&arg[i]);
			if (arg[i]->typ==REG)
			{ 
				rln=arg[i]->wert;
				ldgn_lock+=2;
				rd=rln;
			}
			else 
				errmsg(INV_PAR_ERR);
			break;
		case A_RX : 
			arg[i]=NULL;
			mode=getsym(&arg[i]);
			if (arg[i]->typ==REG) 
				rx=arg[i]->wert;
			else 
				errmsg(INV_PAR_ERR);
			break; 
		case A_RY :
			arg[i]=NULL;
			mode=getsym(&arg[i]); 
			if (arg[i]->typ==REG) 
				ry=arg[i]->wert;
			else 
				errmsg(INV_PAR_ERR);
			break;			
		case A_RZ : 
			arg[i]=NULL;
			mode=getsym(&arg[i]);
			if (arg[i]->typ==REG) 
				rz=arg[i]->wert;
			else 
				errmsg(INV_PAR_ERR);
			break;
		case A_RD : 
			arg[i]=NULL;
			mode=getsym(&arg[i]);
			if (arg[i]->typ==REG) 
				rd=arg[i]->wert;
			else 
				errmsg(INV_PAR_ERR);
			break;
		case A_S2 :
			arg[i]=NULL;
			mode=getsym(&arg[i]);
			if (arg[i]->typ==REG)
			{
				s2=arg[i]->wert;
				s2r=1;
			}
			
			else 
				if (mode && (mode=parseaus(arg[i], &symval)))
				{
					s2r=0;
					s2=arg[i]->wert;
					if(mode==2)
						create_relocent(sct->head.s_size, rel_sct_num, s2, 
										symval, R_13ABS);
					if (s2 > (1<<20)-1)
						errmsg(OVER_FL_ERR);
					s2=(s2 & ((1<<14)-1)) | (1<<14);
				}
				else 
					errmsg(INV_PAR_ERR);
			if(mode==0)
			{
				success=0;
				errmsg(UNNKOWN_TOK_ERR);
			}
			break;
		case A_SI19:
		case A_I19:
			arg[i]=NULL;
			mode=getsym(&arg[i]);
			if(mode!=0)
				mode=parseaus(arg[i], &symval);
			if (mode)
			{
				i19=arg[i]->wert;
				if(com[t->wert].arg[i]==A_SI19)
				{
					if(mode==2)
						create_relocent(sct->head.s_size, rel_sct_num, i19, 
										symval, R_GETHI);
					i19>>=13;
				}
				else
					if(mode==2)
						create_relocent(sct->head.s_size, rel_sct_num, i19, 
										symval, R_19ABS);
				if (i19 > (1<<20)-1)
					errmsg(OVER_FL_ERR);
				i19=i19 & ((1<<20)-1);
			}
			else 
				errmsg(INV_PAR_ERR);
			if(mode==0)
			{
				success=0;
				errmsg(UNNKOWN_TOK_ERR);
			}
			break;
		case A_I13 :
			arg[i]=NULL;
			mode=getsym(&arg[i]);
			if(mode!=0)
				mode=parseaus(arg[i], &symval);
			if (mode)
				{
					i13=arg[i]->wert;
					if(mode==2)
						create_relocent(sct->head.s_size, rel_sct_num, i13, 
										symval, R_13ABS);
					if (i13 > (1<<14)-1)
						errmsg(OVER_FL_ERR);
					i13=i13 & ((1<<14)-1);
				}
			else 
				errmsg(INV_PAR_ERR);
			break;
		case A_RI19 :
			arg[i]=NULL;
			getsym(&arg[i]);
			mode=parseaus(arg[i], &symval);
			if (mode) 
				{
					if(mode==2)
						create_relocent(sct->head.s_size, rel_sct_num, 
										arg[i]->wert, symval, R_19REL);
					if(mode==1)
						i19=arg[i]->wert;
					else
						i19=arg[i]->wert-sct->head.s_size;

					if (i19 > (1<<20)-1)
						errmsg(OVER_FL_ERR);
					i19=i19 & ((1<<20)-1);

				}
			else 
				errmsg(INV_PAR_ERR);
			break;
	}
 /*	printf("%x, %x, %x, %x, %x, %x, %x, %x \n",opc,rx,ry,rz,rd,s2,i13,i19);  */
	
	if(ldgn_lock==1 || ldgn_lock==3)
	{
		ldgn_lock--;
		if(rl==rx || rl==ry || rl==rz || rl==rd || ((rl==s2)&&s2r) || rl==rln)
		{
			success=success&&coff_code_out(0xB8000000);
			sct->head.s_size++;
		}
	}	
	rl=rln;
	if(rx==-1) rx=0;
	if(ry==-1) ry=0;
	if(rz==-1) rz=0;
	if(rd==-1) rd=0;
	if(s2==-1) s2=0;
	if(i13==-1) i13=0;
	if(i19==-1) i19=0;
	if(rln==-1) rln=0;

	code=opc | (rx<<RX_S) | (ry<<RY_S) | (rz<<RZ_S) 
		| (rd<<RD_S) | (s2<<S2_S) | (i13<<I13_S) | (i19<<I19_S);
	if (debugflags && DEBUG_CODE_MASK)
		printf("%x\n", (int)code);
	success=success&&coff_code_out(code);

	for(i=0;i<3;i++)
		bring_token(arg[i]);
	
	return(success);
}


/**************************************************************************
 lab_create nimmt ein Sprunglabel in die Liste der Labels auf und testet
 dabei doppelte Vorkommen. Rueckgabewert bei erfolgreicher Aufnahme ist 1, sonst 0.
 **************************************************************************/
 
int lab_create(struct token *t, char sclass)
 
{ int success=0;
  long cline;                   /* Berechnung richtiger Labeladresse */
 
  if(!scndrun)                  /* Im zweiten Pass macht lab_create nichts */
  { 
	  if(*(labelwort+strlen(labelwort)-1)!=LABELZEI) errmsg(LAB_NOT_FOUND_ERR);
	  else
	  { 
		  *(labelwort+strlen(labelwort)-1)='\0';
		  if(sct!=NULL)
			  cline=sct->head.s_size;
		  else
			  cline=0;
		  
		  if(!lab_ins(labelwort,cline,(int)t->wert,0,sclass)) 
			  errmsg(LAB_NOT_FOUND_ERR); 
		  else success=1; 
	  }
  }
  return(success);
}


/* parse is main routine to assemble input */

int parse(runcnt)
PASSMODE runcnt;                     /* distinguish between single, first, second run */

{
	int success=1;                  /* Rueckgabewert */
	struct token *t;       /* erstes Token der zu parsenden Sequenz */
	struct token *t2;
	int rtmp;

	t=t2=NULL;
	getsym(&t);
	t2=hol_token();
	
	while(t->typ!=F_ENDE && errcnt<MAXERRCNT && success) 
	{
		t2->typ=t->typ;
		t2->wert=t->wert;
		z_akt=line;

		switch(t2->typ)
		{
		case LABEL:
			if (runcnt==FIRST_RUN || runcnt==SINGLE_RUN)
				success=success&lab_create(t,C_STAT);
			break; 
		case BEFEHL:
			if(runcnt==FIRST_RUN && ldgn_lock)
				while(ldgn_lock && (t->typ!=EOTOK && t->typ!=F_ENDE))
				{
					getsym(&t);         /* success = success  && getsym */
					if(t->typ==REG && t->wert==rl)
					{	
						sct->head.s_size++;
						ldgn_lock=0;
					}
					if(t->typ==REG)
						rtmp=t->wert;
				}
			if(ldgn_lock)
				ldgn_lock--;
			if(com[t2->wert].arg[2]==A_RL && (runcnt==FIRST_RUN || runcnt==SINGLE_RUN))
			{
				ldgn_lock=1;
				rl=rtmp;
			}	
			if (runcnt==SECOND_RUN || runcnt==SINGLE_RUN)
			{
				success=success && parsebef(t);

				getsym(&t);
				if (t->typ!=EOTOK && t->typ!=F_ENDE) 
					errmsg(BEF_ARG_ERR);
			}
			else
				if(ldgn_lock)
					while(t->typ!=EOTOK && t->typ!=F_ENDE)
					{
						rl=t->wert;
						getsym(&t);
					}
			if(sct==NULL)
			{
				errmsg(NO_SCT_ERR);
				return(0);
			}
			else
				sct->head.s_size++;
				
			break;
		case DIREC:
			success=success && direc_set(t,runcnt);
			getsym(&t);
			break;
			
		default:
			if (t->typ!=EOTOK && t->typ!=F_ENDE && runcnt!=FIRST_RUN)
			{
				printf("%s:\n",labelwort);
				errmsg(UNNKOWN_TOK_ERR);
			}
			break;
		}
		if (t->typ!=F_ENDE)
			getsym(&t);
		if (t->typ!=F_ENDE) success=1;
		
	}
	bring_token(t); 
	
	return(success);
}




/**************************************************************************
 scan zerlegt die in der Parameterdatei angegebene Eingabedatei in Tokens
 und gibt diese aus. Der Rueckgabewert ist stets 0.
 **************************************************************************/
 
int scan()
{ struct token *tzgr;
  int success;

  z_ende=1;
  printf("\nScanning the file %s \n\n",infilename);
  tzgr=NULL;
  success = getsym(&tzgr);
  while(tzgr->typ!=F_ENDE) 
  { 
    if (success) printf("%s %ld\n",tokenmnem[tzgr->typ],tzgr->wert);
    if (success) fprintf(outfile,"%s %ld\n",tokenmnem[tzgr->typ],tzgr->wert);

    success = getsym(&tzgr);
  }
  if(infile) fclose(infile);
  if(verbose) 
	  printf("\n\nSuccessfully scanned the file %s\n\n",infilename);
  return(0);
}
 

/* 
   Hauptprogramm
*/

int main(argc,argv)
int argc;
char *argv[];
 
{ int error=0;			/* Error Flag reset */
  int debug=0;
  putptr=puttoken;

  coff_init(FIRST_RUN);
  
  switch(eval_params(argc,argv)) { case ONE_PASS_RUN:
  if(!debug) 
  {
	  if(!(init(SINGLE_RUN) && parse(SINGLE_RUN))) error=1;
  }
  else if(!(init(SINGLE_RUN) && scan())) error=1; 
     break;

    case TWO_PASS_RUN:
     if(!(init(FIRST_RUN) && parse(FIRST_RUN))) error=1;
     else if(!(init(SECOND_RUN) && parse(SECOND_RUN))) error=1;
     break;

    case PAR_ERROR:
     error=1;
     break;

    default:
     error=1;
     errmsg(PAR_ERR);
     break;
  }

  if(!error)
	  coff_file_out();
  de_init(!error);
  return(error);
}

