/* FILE:        define.h
   DESCRIPTION: defines for prass.c
   AUTHOR:      Stefan Franziskus
   DATE:        Sept 8, 1993
*/
#include <stdlib.h>

#define VERSION         "0.1"

#define STDINCODE	"--"		/* coding of stdin as input file */

#define STRINGLEN	8192		/* standard length of string vars */
#define STR_LAENG       8192
#define FILENAMELEN     128

/* result values of CLP evaluation */
typedef enum evalresult { PAR_ERROR, ONE_PASS_RUN, TWO_PASS_RUN } EVALRESULT;

/* distinguish single, 1st 2nd run */
typedef enum passmode { SINGLE_RUN, FIRST_RUN, SECOND_RUN } PASSMODE;

/* listing of error codes */
typedef enum errors 
{
    #define ERRMSG(a,b,c) b,
    #include "errors.h"
    #undef ERRMSG
    ERRNUM
} ERRORS;
/* ERRNUM is number of known errors */

/* types of recognized tokens */

typedef enum tokentyp {
BEFEHL, ZAHL, FLOATNUM, REG, OPERAT, CONDIT, LABEL, F_ENDE, RANGE, DIREC, STRNG,DATBEFEHL, OPER, KLAUF, KLZU, SPECBEFEHL, SYMBOL, DOT, EQUAL, EOTOK } TOKENTYP;

typedef enum dirtyp {D_ALIGN, D_ASCII, D_ASCIZ, D_BLA, D_BLUB, D_BSS, D_BYTE, D_COMM, D_DATA, D_DOUBLE, D_FLOAT, D_GLOBL, D_HWORD, D_INT, D_LCOMM, D_LONG, D_ORG, D_SECTION, D_SPACE, D_STAB, D_TEXT, D_WORD} DIRTYP;

typedef enum argument 
{ A_RX,A_RY,A_RZ,A_RD,A_S2,A_I19,A_SI19,A_I13,A_NIX,A_SPEC,A_RI19,A_RL } ARGUMENT;

#define ZAHLZEI '0'     /* Identifier einer Zahl */
#define HEXZEI  'x'     /* Identifier einer Hex-Zahl */
#define BINZEI  'b'     /* Identifier einer Bin-Zahl */
#define FLOATSIGN 'e'   /* Identifier einer Float-Zahl */
#define LABELZEI ':'    /* Identifier eines Labels */
#define SPECZEI  '.'     /* Identifier fuer Bereiche und andere Direktiven */
#define STRNGZEI '"'    /* Identifier fuer Anfang und Ende eines Strings */
#define KLAUFZEI '('    /* Identifier fuer Klammer auf */
#define KLZUZEI ')'     /* und Klammer zu */
#define PARZEI '%'      /* Identifier fuer Parameternummern */
#define KOM_ON "/*"     /* Identifier fuer Kommentarbeginn */
#define KOM_OFF "*/"    /* Identifier fuer Kommentarende */
#define KOM_LINE "#"    /* Identifier fuer line comment */
#define GLEIZEI '='     /* Identifier fuer Gleichheitszeichen */


#define POSITIV 1       /* Vorzeichen einer Zahl */
#define NEGATIV -1      /* dto */

#define BEFANZ 313
#define MAKROANZ 200    /* Max. Anzahl von Makros */
#define MAKROTEXTANZ 200000 /* Max. Text fuer Makros */
#define MAXANZPAR 10    /* Max. Anzahl von Parametern fuer Makros */
#define TOKENANZ 200    /*>>>100 Laenge der Liste der freien Tokens */
#define MAXERRCNT 10    /* Max. Anzahl von Fehlern, nach denen
                           abgebrochen wird */
#define MAXWARNNUM 2    /* Anzahl der Warnungen */
#define MAXERRNUM 57    /* Anzahl der Fehlermeldungen */
#define SPECREGANZ 12    /* Anzahl der Spezialregisternamen im Feld specregs */
#define CONDITANZ 20    /* Anzahl der Conditions im Feld condits */
#define OPERANZ 4       /* Anzahl der Operatoren im Feld operats */
#define OPRANZ  6       /* Anzahl der Ausdrucksooperatoren im Feld opers */
#define SPECCOMMANZ 4   /* Anzahl der IO-Kommandos im Feld speccomm */
#define TOTALREGANZ 32  /* Gesamtzahl der Register */
#define MAXLABELANZ 3000 /*300>>>200 Gesamtzahl moeglicher Labels */
#define RANGESANZ 4     /* Anzahl der Bereiche */
#define DIRECTIVANZ 22   /* Anzahl der erkannten Direktiven */
#define ERSANZ  3000     /*300>>>200 Anzahl der Ersetzungen */
#define DATACOMMANZ 2   /* Anzahl der Befehle in Datenbereichen */
#define FSTACKMAX 10    /* Groesse des INCLUDE Stacks */
#define MSTACKMAX 10    /* Groesse des MAKRO Stacks */

#define HASHANZ 1      /* Zweierpotenz zum modulo Rechnen beim Stringhash */
#define HASHMASK 0x00000000L    /* Zweierpotenz, modulo der gerechnet wird,
                                   -1 */
#define DEBUG_CODE_MASK 1

#define CODE_W  0       /* Positionen der Bereiche im Feld ranges */
#define DATA_W 1
#define BSS_W  2

/* Maske fuer globalen oder lokalen Zugriff */
#define BIT31           0x80000000L

#define ASS_SUFFIX ".ass" /* Suffix f"ur Assemblercode-file */
#define LOG_SUFFIX ".log" /* Suffix f"ur Logfile */
#define COD_SUFFIX ".o"   /* Suffix f"ur Codefile */
#define LST_SUFFIX ".lst" /* Suffix f"ur Listfile */
#define RAW_SUFFIX ".raw" /* Suffix f"ur Rawfile */
 
#define LABELLAENG 2048  /* Laenge eines Label namens */
#define ZEILELAENG 2048  /* laenge einer Zeile */
 
#define FAILURE -1      /* Rueckgabewert der Binsuche bei Nichtvorkommen */
#define NEWSTAGE -2     /* Neue Stufe auf lokalem Stack, -2 wegen Unterschied zu */
#define isbindigit(c) ((c)=='0' || (c)=='1')
#define ishexdigit(c) (((c)>='0' && (c)<='9') || ((c)>='A' && (c)<='F'))
#define isoctdigit(c) ((c)>='0' &&(c)<='7')
#define nozdigit(c)   ((c)>='1' && (c)<='9')

#define iskomzei(c,c2)  (((c)=='*' && (c2)=='/') || ((c)=='/' && (c2)=='*'))
#define isklzei(c)    ((c)==KLAUFZEI || (c)==KLZUZEI)
#define isdotsym(c,d) ((c)=='.' && (!isalnum(d) && (d)!='.' && (d)!='_' && (d)!='$'))
#define isbreak(c)    ((c)=='\0' || (c)=='\n' || (c)==';' || (c)=='#' || (c)=='!' || (c)==' ' || (c)==',') 

#define RX_S 15
#define RY_S 0
#define RZ_S 20
#define RD_S 20
#define S2_S 0
#define I13_S 0
#define I19_S 0

struct token    /* Record mit Typ und Wert eines Tokens */
{ int typ;      /* Typ des Tokens */
  long wert;    /* Wert falls vorhanden */
};

struct label    /* Record mit Name und Zeile eines Labels und Zeiger auf
                   naechstes */
{ 
	char name[LABELLAENG];        /* Name des Labels */
	long sct_num;    /* Nummer der Section */
	long zeil;                     /* Zeile des Labels */
	struct label *naechst;        /* Zeiger auf naechstes */
	int rnge;                   /* Range, in dem Label definiert wird */
	long syment_nr;
};

 
struct befehl   /* Struct mit Befehlsname,  Opcode, und Argumenten */
{                   /* + Direktiven und Registern */
	char *name;
	long type;
	long opcode;
	long arg[3];
};

struct stab
{
	char string[STR_LAENG];
	int type;
	int other;
	int desc;
	int value;
};

void errmsg(ERRORS num);
void coff_init(PASSMODE runcnt);
struct token *hol_token(void);
int lab_ins(char *w, long z, int r, char sc,char scl);
int getsym(struct token **tzgr);
int putsym(struct token **tzgr);
int coff_code_out(long code);
int parseaus(struct token *expr, int *a);
int create_relocent(long v, long s, long sy, int adr, unsigned short t);
int create_syment(char *name, long val, short scn, char scl);
int search_section(char *name, long type);
void check_commandfile(void);
void create_lineno_ent(int l_paddr, int l_lnno);
void de_init(int success);
int lab_find(char *w, int *zzgr, int *rzgr);
int patch_syment(char *name,long value,short scnum,char sclass);
int isop(char c);

static inline void *new_malloc(size_t size)
{
	char *ret;
	if(!(ret=malloc(size)))
	{
		errmsg(MALLOC_ERR);
		exit(-1);
	}
	else
		return(ret);
}

#define malloc new_malloc 
