/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

static char sccsid[] = "@(#)simulate.c	1.20";

#include <signal.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "processor.h"
#include "glovars.h"
#include "simul.h"

static void CoreHandler()
{
	break_flags |= BRK_DUMP;
	signal(SIGHUP, CoreHandler);
}

static void KillHandler()
{
	break_flags |= BRK_DUMP|BRK_STOP|BRK_EXIT;
}

static void BreakHandler()
{
	break_flags |= BRK_STOP;
	signal(SIGINT, BreakHandler);
}

void dostop_error(struct vpregs *vp, const char *s)
{
	break_flags |= BRK_STOP;
	fprintf(stderr, "error: vp=#%d, pc=$%08x, reason=%s\n",
			vp-VirtualProcessor, vp->R[1], s);
}

void dostop_illegal(struct vpregs *vp, const char *s)
{
	break_flags |= BRK_STOP;
	fprintf(stderr, "ILLEGAL: vp=#%d, pc=$%08x, reason=%s\n",
			vp-VirtualProcessor, vp->R[1], s);
}

void dostop_break(struct vpregs *vp)
{
	break_flags |= BRK_STOP;
	fprintf(stderr, "BREAKPOINT: vp=#%d, pc=$%08x\n",
			  vp-VirtualProcessor, vp->R[1]);
}

void dostop_exit(struct vpregs *vp)
{
	break_flags |= BRK_STOP;
	fprintf(stderr, "EXIT: vp=#%d, pc=$%08x\n",
			  vp-VirtualProcessor, vp->R[1]);
}

static void NiceHandler()
{
	if(getpriority(PRIO_PROCESS, 0) < 15)
		nice(1);
}

void trace_log(UWORD pc)
{
	fwrite(&pc, sizeof(UWORD), 1, TraceFile);
}

void Simulate(unsigned single, unsigned options, int out_steps)
{
	long long steps = 0;
	struct itimerval value = {{3600, 0}, {3600, 0}};
	fflush(stdout);
	fflush(stderr);

	
	signal(SIGHUP, CoreHandler);
	signal(SIGTERM, KillHandler);
	signal(SIGINT, BreakHandler);

#ifdef AUTONICE
/*
	if(getpriority(PRIO_PROCESS, 0) < 5)
		nice(5 - getpriority(PRIO_PROCESS, 0));
*/
	signal(SIGALRM, NiceHandler); /* for special guests like aksel, zorn.. */
	setitimer(ITIMER_REAL, value, (struct itimerval *)NULL);
#endif

	(void)get_time();
	break_flags = single;
	do
	{
		do
		{
			int ppn;
			struct ppregs *pp;
			WORD GlobalExternalInterrupt = ExternalInterrupts[-1];
			for(pp=PhysicalProcessor, ppn=0; ppn<PPnum; ppn++, pp++)
			{
				int e, ExNR = -1;
				UWORD MOD = pp->MOD2;
				UWORD ct;
				ct = ++(pp->CT);
				if(!ct) pp->ctex = 1;
				if(GlobalExternalInterrupt>=0)
					ExternalInterrupts[ppn] = GlobalExternalInterrupt;
				if(!(MOD & GLMASK))
				{
					e = ExternalInterrupts[ppn];
					if(!ModuloBit && e>=0 && !((MOD>>(20-e)) & 1))
					{
						if(e >= 8)
							fprintf(stderr,
									"Bescheuerte Exception %d vom Host\n", e);
						else ExNR = e;
						ExternalInterrupts[ppn] = -1;
					}
					else if(pp->ctex && !(MOD & COUNTERmsk))
					{
						pp->ctex = 0;
						ExNR = 8;
					}
					else if((MOD & VPEX1) && !(MOD & VPEX1msk)) ExNR=9;
					else if((MOD & VPEX2) && !(MOD & VPEX2msk)) ExNR=10;
					if(ExNR>=0)
					{
						fprintf(stderr, "Exception #%d\n", ExNR);
						pp->MOD = MOD | GLMASK|GLSUPER;
					}
				}
				pp->MOD2 = pp->MOD;
				pp->ExtEx = ExNR;
			}
			if(GlobalExternalInterrupt>=0) ExternalInterrupts[-1] = -1;
			if(options & OPT_SLOW)
				SimulateNStepsSlow(VirtualProcessor, VPnum*PPnum, options);
			else
				SimulateNStepsFast(VirtualProcessor, VPnum*PPnum, options);
			ModuloBit ^= 1;
			steps++;
		}
		while(!break_flags);
		
		if(break_flags & BRK_DUMP)
		{
			pram_dump_core("pcore");
			break_flags &= ~BRK_DUMP;
		}
	}
	while(!(break_flags & BRK_STOP));
	if(out_steps)
	{
		if(steps>=(1LL<<32))
			fprintf(stderr, "Stop nach $%x%08x Runden, ",
				   (unsigned)(steps>>32), (unsigned)steps);
		else		
			fprintf(stderr, "Stop nach %u Runden, ", (unsigned)steps);

		fprintf(stderr, "%.3f kIps\n", VPnum*PPnum*steps/get_time()/1000);
	}
	if(break_flags & BRK_EXIT) exit(1);
}
