/* -*-mb0-c-*-

   SB-PRAM simulator

   (C) 1994 by Michael Bosch (hirbli@cs.uni-sb.de)
   and Stefan Franziskus (stefran@cs.uni-sb.de)

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies.
*/

struct option_desc
{
        char short_opt;
        const char *long_opt;
        int type;
		union val
		{
			int *int_val;
			char **string_val;
			int flags;
			void (*function)(char *);
		} val;
		const char *comment;
};

enum option_types{O_INT, O_STRING, O_FLAG, O_FUNCTION, O_HELP};

#define I_INT(a) O_INT, {int_val: (a)}
#define I_STRING(a) O_STRING, {string_val: &(a)}
#define I_FLAG(a) O_FLAG, {flags: (a)}
#define I_FUNCTION(a) O_FUNCTION, {function: (a)}

#define STDINCODE "--"
