/* ld: Linker fr PRAM
 * Version: V0.20
 * Autor: Daniel Rock
 * Datum: 19.08.94
 * (c) 1994
 */
/* History:
 28.01.94: Auftrag angenommem,
           Erster Test zum Auslesen des Objectfiles
 10.02.94: Erstellung eines Ablaufgersts (1. Versuch)
 12.02.94: Gruendliche berarbeitung des Linkablauf, komplette
           Neustrukturierung des Codes.
 16.02.94: Grundskelett zum Programmablauf steht (2. Versuch)
 17.02.94: Erstellung von Datentypen zum Gerst
 18.02.94: Implementation von wichtigsten Funktionen
 07.03.94: (06.59 MET) Er macht zum erstenmal was richtiges!
 08.03.94: Minor bug removed.
 13.03.94: Major bug removed.
 26.04.94: First fully functional Release
 29.04.94: Inconsistencies in Stringtable removed
 17.05.94: Fehlermeldungen in stderr
 08.06.94: Fehler im partial link removed
 09.07.94: Line Number Info aufgenommen
 19.08.94: Umkehrfunktion eingefhrt.
 24.08.94: Unntiger Krimskrams rausgeschmissen
 18.09.94: Kleinerer Bug in LineInfo-Code entfernt.
*/

/* Noch zu machende nderungen sind mit !!! im Kommentar markiert */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <time.h>
#include <sys/time.h>
#include "coff.h"

#define HASH_SIZE 257
#define MAX_SECTIONS 100

/*!!! Errorliste noch besser machen (interner Zusammenhang zwischen errtype
 * und err_codes und errmsg, als array[E_OK..E_PARSE] of struct errtype, errmsg end */


typedef enum
{
  E_NOERROR,
  E_WARNING,
  E_ERROR,
  E_FATAL
} errtype;

typedef enum
{
  E_OK,
  E_STATICPTR,
  E_MAXSECTIONS,
  E_MAXFILES,
  E_FILECREATE,
  E_NOMEM,
  E_MULTIPLE,
  E_NODATA,
  E_IGNORING,
  E_NOTIMPLEMENTED,
  E_UNKNOWNOPTION,
  E_NOFILE,
  E_EXT,
  E_INT_ERR,
  E_UNMATCHED_RELOC,
  E_PARSE,
  E_MAGIC
} err_codes;

char *errmsg[]=
{
  "No error",
  "Pointer to non-external Symbol-entry",
  "Too many Sections",
  "Too many Files",
  "Error creating output file",
  "Out of memory",
  "Multiple Definition of Symbol",
  "File contains no useful data",
  "Data ignoring",
  "Feature not implemented",
  "Unknown Linker Option",
  "File not found",
  "Unresolved external",
  "Undocumented feature",
  "Unmatched Relocation entry",
  "Parse error in command line",
  "Wrong magic number"
};

typedef enum
{
  FALSE, TRUE
} bool;

/* struct f_scn: Verkettete Liste aller verschiedenen Sections
 * Gleiche Sections werden in struct scndata verkettet */
struct f_scn
{
  long sc_start,sc_end;            /* Start address of Section, end address + 1!! */
  struct scnhdr *f_scnhdr;
  struct scndata *f_scndata;
/*  struct f_scn *next;*/
};

struct out_file
{
  struct filehdr *f_hdr;
  struct aouthdr *f_aouthdr;
  struct f_scn f_sections[MAX_SECTIONS]; /* f_sections[0] wird nicht benutzt */
};

/* struct scndata: Verkettete Liste *einer* Section */
struct scndata
{
  int fileno;
  long s_size;
  long s_nreloc;
  long s_nlnno;
  char *f_raw;
  struct reloc *f_reloc;
  struct lnno *f_lnno;
  struct scndata *next;
};

struct scn
{
  struct scnhdr sc_hdr;
  char *sc_raw;
  struct reloc *sc_reloc;
  struct lnno *sc_lnno;
};

struct f_syments
{
  long n_syms;
  struct syment *a_syment;
  struct f_syment *next;
};

struct map
{
  int sc_num;
  long offset;
};

struct syment ***r_symndx;

struct hash_tbl
{
  struct syment *syment;
  struct hash_tbl *next;
};

struct hash_tbl *hash_table[HASH_SIZE];
struct syment *quick_find[MAX_SECTIONS];
int quick_number;
unsigned long unresolved_externals;
char *outputname="a.out";
errtype err;
err_codes error;
int n_infiles,max_files;      /* Anzahl der Eingabefiles */
int debug_level;
char **filename;              /* Array von Filenamen */
bool partial_link;
bool multiple_pass_in_archive,archives;
bool exclude_debug_info,create_aout_hdr,strip_locals;
FILE *f;
struct out_file *outfile;
struct map **scn_mapping;

/* Inputfile Variablen */
struct filehdr *f_hdr;
/*struct aouthdr *f_opthdr;*/
struct scn *f_section;
char *f_strtbl;

void do_error(int fileno, char *str, errtype e, err_codes e1)
{
  if(e>err)
  {
    err=e;
    error=e1;
  }
  if(fileno>=0)
    fprintf(stderr,"In File %s:\n",filename[fileno]);
  switch(e)
  {
    case E_WARNING:
      fprintf(stderr,"Warning: %s %s\n",str, errmsg[e1]);
      return;
    case E_ERROR:
      fprintf(stderr,"Error: %s %s\n", str, errmsg[e1]);
      return;
    case E_FATAL:
      fprintf(stderr,"\007Fatal error: %s %s\n",str,errmsg[error]);
/* Bei Internem Fehler core Dump (durch abort())*/
      if(e1==E_INT_ERR)
        abort();
      else
        exit(E_FATAL);
    default:
      do_error(-1,"",E_FATAL,E_INT_ERR);
  }
}

void *ldmalloc(unsigned size)
{
  void *m;

  if((m=(void *)malloc(size))==NULL)
    do_error(-1,"",E_FATAL,E_NOMEM);
  return m;
}

void parse_cmd_line(int argc, char **argv)
{
  int i,j;

  for(i=1;i<argc;++i)
  {
    if(argv[i][0]=='-')
      switch(argv[i][1])
      {
/* Diesen Optionen folgt *ein* Argument */
        case 'o':
        case 'l':
        case 'L':
          if(!argv[i][2])
            ++i;       /* Nchstes Eingabeelement berlesen */
/* Allen anderen folgt kein Argument */
        default:
          break;
      }
    else
      ++n_infiles;
  }
  filename=(char **)ldmalloc(n_infiles*sizeof(char *));
  for(i=1,j=0;i<argc;++i)
  {
    if(argv[i][0]=='-')
      switch(argv[i][1])
      {
        case 'v':
          do_error(-1, "Option -v", E_WARNING, E_NOTIMPLEMENTED);
          break;
        case 'd':
          ++debug_level;
          break;
        case 'm':
          multiple_pass_in_archive=(argv[i][2]!='-');
          do_error(-1,"Option -m",E_WARNING,E_NOTIMPLEMENTED);
          break;
        case 'x':
          exclude_debug_info=(argv[i][2]!='-');
          do_error(-1,"Option -x",E_WARNING,E_NOTIMPLEMENTED);
          break;
        case 'r':
          partial_link=(argv[i][2]!='-');
          break;
        case 's':
          exclude_debug_info=TRUE;
          break;
        case 'S':
          strip_locals=TRUE;	  
          break;
        case 'o':
          if(!argv[i][2])
            if(argc<i-2)
              do_error(-1,"",E_ERROR,E_PARSE);
            else
              outputname=argv[++i];
          else
            outputname=argv[i]+2;
          break;
        case 'L':
        case 'l':
/*!!! Libraries einlesen und entspr. Variablen initialisieren */
          if(!argv[i][2])
            ++i;
          archives=TRUE;
          do_error(-1,"Options -l/-L",E_WARNING,E_NOTIMPLEMENTED);
          break;
        default:
          do_error(-1,argv[i],E_WARNING,E_UNKNOWNOPTION);
      }
    else
      filename[j++]=argv[i];
  }
}

void init()
{
  int i;
  err=E_NOERROR;
  error=E_OK;
  n_infiles=debug_level=0;
  unresolved_externals=0;
  strip_locals=create_aout_hdr=archives=partial_link=multiple_pass_in_archive=exclude_debug_info=FALSE;
  create_aout_hdr=TRUE;
  quick_number=0;
  for(i=0;i<HASH_SIZE;++i)
    hash_table[i]=NULL;
/*!!! ? */
}

void init_obj_files()
{
  if(debug_level)
    printf("Call to Routine init_obj_files()\n");
/*  r_symndx=(struct syment **)ldmalloc(n_infiles*sizeof(struct syment *));*/
/*!!!*/
}

/* Initialisiert Output-File mit Header mit aktuellem Datum, 0 Sections,
 * leere Symbol- und Stringtabelle */
void init_out_file()
{
  if(debug_level>2)
    printf("Creating empty Output-File\n");
  outfile=(struct out_file *)ldmalloc(sizeof(struct out_file));
  outfile->f_hdr=(struct filehdr *)ldmalloc(sizeof(struct filehdr));
  outfile->f_hdr->f_nscns=0;
  outfile->f_hdr->f_nsyms=0;
/* aouthdr wird bei write_output_file() erzeugt */
  r_symndx=(struct syment ***)ldmalloc(max_files*sizeof(struct syment **));
  scn_mapping=(struct map **)ldmalloc(max_files*sizeof(struct map *));
  f_hdr=(struct filehdr *)ldmalloc(max_files*sizeof(struct filehdr));
}

/* Liest alle Sections ein */
void read_sections(int fileno, FILE *f)
{
  int i,j;

  if(debug_level>1)
    printf("Reading Sections\n");
  fseek(f,FILHSZ+f_hdr[fileno].f_opthdr,0);
/* Zuerst Header (liegen sequentiell in File) */
  for(i=1;i<=f_hdr[fileno].f_nscns;++i)
  {
    fread(&f_section[i].sc_hdr,SCNHSZ,1,f);
    if(debug_level)
      printf("Name of Section %d:%s\n",i,f_section[i].sc_hdr.s_name);
  }
  for(i=1;i<=f_hdr[fileno].f_nscns;++i)
  {
    long n_reloc,n_lnno,sc_sz=f_section[i].sc_hdr.s_size;

    n_reloc=f_section[i].sc_hdr.s_nreloc;
    n_lnno=f_section[i].sc_hdr.s_nlnno;
    if(debug_level)
      printf("Size of Section %d: %ld, Relocs: %ld, LineInfo %ld\n",
             i,sc_sz,n_reloc,n_lnno);
/*!!!    f_section[i].sc_hdr.s_size; */
/* Lies Raw Data ein */
    if(!(f_section[i].sc_hdr.s_flags&STYP_BSS))
    {
      f_section[i].sc_raw=(char *)ldmalloc(sc_sz);
      fseek(f,f_section[i].sc_hdr.s_scnptr,0);
      fread(f_section[i].sc_raw,1,sc_sz,f);
    }
/* Lies Relocation Info ein */
    f_section[i].sc_reloc=(struct reloc *)ldmalloc(n_reloc*sizeof(struct reloc));
    fseek(f,f_section[i].sc_hdr.s_relptr,0);
    for(j=0;j<n_reloc;++j)
    {
      fread(&f_section[i].sc_reloc[j],RELOC_SIZE,1,f);
      f_section[i].sc_reloc[j].r_syment=NULL;
    }
/* Lies Lineinfo ein */
    fseek(f,f_section[i].sc_hdr.s_lnnoptr,0);
    f_section[i].sc_lnno=(struct lnno *)ldmalloc(n_lnno*sizeof(struct lnno));
    for(j=0;j<n_lnno;++j)
      fread(&(f_section[i].sc_lnno[j]),LNNO_SIZE,1,f);
  }
  if(debug_level>1)
    printf("Done reading Sections\n");
}

/* Brute-Force Hash-Value */
int hash_value(struct syment *syment)
{
  int value=0;
  char *c;

  for(c=syment->name;*c!=0;++c)
    value+=*c;
  return value%HASH_SIZE;
}

void generate_sections(int fileno, FILE *f)
{
  int i,j;
  struct scnhdr *scn_hdr;

  if(debug_level>1)
    printf("Remapping Sections of File %d\n",fileno);

  scn_hdr=(struct scnhdr *)ldmalloc(sizeof(struct scnhdr));
  scn_mapping[fileno]=
    (struct map *)ldmalloc((f_hdr[fileno].f_nscns+1)*sizeof(struct map));  
  fseek(f,f_hdr[fileno].f_opthdr+FILHSZ,0);
  for(i=1;i<=f_hdr[fileno].f_nscns;++i)
  {
    fread(scn_hdr,SCNHSZ,1,f);
    for(j=1;j<=outfile->f_hdr->f_nscns;++j)
      if(strcmp(scn_hdr->s_name,outfile->f_sections[j].f_scnhdr->s_name)==0)
        break;
    scn_mapping[fileno][i].sc_num=j;
    if(j>outfile->f_hdr->f_nscns)              /* Ist neue Section dazugekommen? */
    {
      ++outfile->f_hdr->f_nscns;
      /* Startadresse von Sectionheader nehmen */
      scn_mapping[fileno][i].offset=0;
      outfile->f_sections[j].sc_end=scn_hdr->s_size;
      outfile->f_sections[j].sc_start=scn_hdr->s_vaddr;
      outfile->f_sections[j].f_scndata=NULL;
      outfile->f_sections[j].f_scnhdr=
        (struct scnhdr *)ldmalloc(sizeof(struct scnhdr));
      memcpy(outfile->f_sections[j].f_scnhdr,scn_hdr,SCNHSZ);
/*einige Pointer stimmen zwar nicht, die mssen aber sowieso neu generiert werden.*/
    }
    else         /* Anpassungen an scn_hdr */
    {
      scn_mapping[fileno][i].offset=outfile->f_sections[j].sc_end-scn_hdr->s_vaddr;
      outfile->f_sections[j].sc_end+=scn_hdr->s_size;
      outfile->f_sections[j].f_scnhdr->s_size+=scn_hdr->s_size;
      outfile->f_sections[j].f_scnhdr->s_nreloc+=scn_hdr->s_nreloc;
      outfile->f_sections[j].f_scnhdr->s_nlnno+=scn_hdr->s_nlnno;
    }
  }
  free(scn_hdr);
}

struct hash_tbl *search_table(int value, struct syment *syment)
{
  struct hash_tbl *i;
  for(i=hash_table[value];i;i=i->next)
    if(strcmp(syment->name,i->syment->name)==0)
      return i;
  return NULL;
}

void append_hash(int value, struct syment *syment)
{
  if(hash_table[value]==NULL)
  {  /* Allererstes Element */
    hash_table[value]=(struct hash_tbl *)ldmalloc(sizeof(struct hash_tbl));
    hash_table[value]->syment=syment;
    hash_table[value]->next=NULL;
  }
  else
  {
    struct hash_tbl *i;

    for(i=hash_table[value];i->next;i=i->next)
      ;
    i->next=(struct hash_tbl *)ldmalloc(sizeof(struct hash_tbl));
    i->next->syment=syment;
    i->next->next=NULL;
  }
}

bool is_section(struct syment *syment)
{
  int i;

  for(i=1;i<=outfile->f_hdr->f_nscns;++i)
    if(strcmp(outfile->f_sections[i].f_scnhdr->s_name,syment->name)==0)
      return TRUE;
  return FALSE;
}

void generate_symbols(int fileno, FILE *f)
{
  int i,value;
  int n_syms;
  long str_size=0,strptr;
  struct syment *syment;
  char *strtbl;
  struct hash_tbl *hash_entry;

  n_syms=f_hdr[fileno].f_nsyms;
  r_symndx[fileno]=(struct syment **)ldmalloc(sizeof(struct syment *)*n_syms);
  strptr=f_hdr[fileno].f_symptr+n_syms*SYMENT_SIZE;
/* Stringtabelle einlesen, damit nachher eingelesene Symbole schon richtige
 * Namenszuordnung haben */
  fseek(f,strptr,0);
  fread(&str_size,4,1,f);
  strtbl=(char *)ldmalloc(str_size);
  fread(strtbl,1,str_size,f);
  fseek(f,f_hdr[fileno].f_symptr,0);

/* Nun Symboltabelle einlesen */
  syment=(struct syment *)ldmalloc(sizeof(struct syment)*n_syms);
  for(i=0;i<n_syms;++i)
  {
    fread(&syment[i],SYMENT_SIZE,1,f);
    /* Sectionnummer anpassen */
    if(syment[i].n_scnum>0)
    {
      syment[i].n_value+=scn_mapping[fileno][syment[i].n_scnum].offset/4;
      syment[i].n_scnum=scn_mapping[fileno][syment[i].n_scnum].sc_num;
    }
    /* syment.name richtig setzen */
    if(syment[i].n_zeroes)
    {
      int j;
      for(j=0;j<=7;++j)
        if(!syment[i].n_name[j])
          break;	
      if(j==8)
      {
        syment[i].name=(char *)ldmalloc(9);
        strncpy(syment[i].name,syment[i].n_name,8);
        syment[i].name[8]=0;
      }
      else
        syment[i].name=syment[i].n_name;
    }
    else
      syment[i].name=&strtbl[syment[i].n_offset-4];

    r_symndx[fileno][i]=&syment[i];
    syment[i].value=fileno;
    value=hash_value(&syment[i]);
    if(syment[i].n_sclass==C_EXT)
    {
      if((hash_entry=search_table(value,&syment[i])))
      {
        r_symndx[fileno][i]=hash_entry->syment;
        if(syment[i].n_scnum)         /* Definition */
          if(hash_entry->syment->n_scnum)
            do_error(fileno,syment[i].name,E_ERROR,E_MULTIPLE);
          else
          {
            memcpy(hash_entry->syment,&syment[i],sizeof(struct syment));
            --unresolved_externals;
          }
        else                          /* Neue Deklaration wird verworfen */
        {
/*!!!*/
        }
      }
      else
      {
        if(!syment[i].n_scnum)
          ++unresolved_externals;
        append_hash(value,&syment[i]);
        if(syment[i].name[0]=='.')    /* (Besser wre is_section(syment[i])) */
        {
          quick_find[quick_number++]=&syment[i];
          fprintf(stderr," Merkwrdig.\n");
        }
        r_symndx[fileno][i]=&syment[i];
      }
    }
    else  /* Kein C_EXT-Symbol */
    {
      if(is_section(&syment[i]))
      {
        if((hash_entry=search_table(value,&syment[i])))
          r_symndx[fileno][i]=hash_entry->syment;
        else
        {
          append_hash(value,&syment[i]);
          quick_find[quick_number++]=&syment[i];
        }
      }
      else              /* Ist ein normaler Symboltabelleneintrag */
      {
        if(syment[i].n_sclass==C_FILE)  /* C_FILE fr Debugging */
        {
          if(!(hash_entry=search_table(value, &syment[i])))
          /* Symbol ist noch nicht vorhanden */
          {
            append_hash(value, &syment[i]);
            r_symndx[fileno][i]=&syment[i];
          }
          else
          {
             r_symndx[fileno][i]=hash_entry->syment;
          }
        }
        else
          r_symndx[fileno][i]=&syment[i];
      }
    }
  }
}

/* Liest Sectionheader fr Files ein, generiert damit section-mapping, liest
 * Symboltabelle ein und fllt diese in Hashtabelle */
void preprocess_objfiles()
{
  FILE *f;
  int i;

  for(i=0;i<n_infiles;++i)
  {
    if(debug_level>1)
      printf("Reading Symbol- and Stringtable from File %s\n",filename[i]);
    if((f=fopen(filename[i],"r"))==NULL)
      do_error(i,"",E_FATAL,E_NOFILE);
    fread(&f_hdr[i],FILHSZ,1,f);
/* Prft Header auf Magic-Number */
    if(f_hdr[i].f_magic!=02400)
      do_error(i, "", E_FATAL, E_MAGIC);
    generate_sections(i,f);
    generate_symbols(i,f);
    fclose(f);
  }
}

void reloc_item(int fileno, int sc_num, struct reloc *i_reloc, struct syment *i_syment)
{
  long i, offset=0;

  i_reloc->r_vaddr+=scn_mapping[fileno][sc_num].offset/4;
/* Muss angepasst werden, da Section evtl. nicht mehr am Anfang steht */

  for(i=1;i<=f_hdr[fileno].f_nscns;++i)
    if(scn_mapping[fileno][i].sc_num==i_syment->n_scnum)
    {
      offset=scn_mapping[fileno][i].offset/4;
      break;
    }
/* Ist Zeiger auf C_EXT Symbol, dann keine Anpassung */
  if(i_syment->n_sclass==C_EXT)
  {
    i_reloc->r_offset+=i_syment->n_value;

/* Relocation-Eintrag soll nun auf .section-Eintrag stehen */
    for(i=0;i<quick_number;++i)
      if(quick_find[i]->n_scnum==i_syment->n_scnum)
      {
        i_reloc->r_syment=quick_find[i];
        break;
      }
  }
  else
    if(i_syment->name[0]!='.')
    {
      do_error(fileno,i_syment->name,E_WARNING,E_STATICPTR);
      i_reloc->r_offset=i_syment->n_value+offset;
    }
    else
      i_reloc->r_offset+=i_syment->n_value+offset;
}

void reloc_scn(int fileno, int sc_num)
{
  int i;
  struct reloc *f_reloc=f_section[sc_num].sc_reloc;

  if(debug_level)
    printf("Relocating Section %d\n",sc_num);

  for(i=0;i<f_section[sc_num].sc_hdr.s_nreloc;++i)
  {
    if(!f_reloc[i].r_syment)
      f_reloc[i].r_syment=r_symndx[fileno][f_reloc[i].r_symndx];
    reloc_item(fileno,sc_num,&f_reloc[i],r_symndx[fileno][f_reloc[i].r_symndx]);
  }
}

/* Fgt die neuen Sections mit entsprechenden Mappings in Outputfile hinzu,
 * evtl. musz Fileheader updated werden (Sections hinzugekommen) */
void merge_section(int fileno, int sc_num)
{
  int j;
  struct scndata *scn_data;

  /* Suche gleichen Sectionnamen in anderen Sections */
  for(j=1;j<=outfile->f_hdr->f_nscns;++j)
    if(!strcmp(f_section[sc_num].sc_hdr.s_name,
               outfile->f_sections[j].f_scnhdr->s_name))
      break;
  if(scn_mapping[fileno][sc_num].sc_num!=j)      /* Mapping sollte eindeutig sein */
    do_error(-1,"",E_FATAL,E_INT_ERR);
  
  scn_data=outfile->f_sections[j].f_scndata;
  if(scn_data==NULL)       /* Leere Section */
    scn_data=outfile->f_sections[j].f_scndata=
      (struct scndata *)ldmalloc(sizeof(struct scndata));
  else
  {
    for(;scn_data->next;scn_data=scn_data->next)
      ;
    scn_data->next=(struct scndata *)ldmalloc(sizeof(struct scndata));
    scn_data=scn_data->next;
  }
  for(j=0;j<f_section[sc_num].sc_hdr.s_nlnno;++j)
  {
    if(f_section[sc_num].sc_lnno[j].l_lnno)
      f_section[sc_num].sc_lnno[j].l_addr.l_paddr+=
        scn_mapping[fileno][sc_num].offset/4;
  }
  scn_data->fileno=fileno;
  scn_data->s_size=f_section[sc_num].sc_hdr.s_size;
  scn_data->s_nreloc=f_section[sc_num].sc_hdr.s_nreloc;
  scn_data->s_nlnno=f_section[sc_num].sc_hdr.s_nlnno;
  scn_data->f_raw=f_section[sc_num].sc_raw;
  scn_data->f_reloc=f_section[sc_num].sc_reloc;
  scn_data->f_lnno=f_section[sc_num].sc_lnno;
  scn_data->next=NULL;
}

void do_reloc()
{
  int i,sc_num;
  FILE *f;

  if(debug_level>2)
    printf("Call to Routine do_reloc()\n");

  for(i=0;i<n_infiles;++i)
  {
    if(debug_level)
      printf("Processing file %d: %s\n",i,filename[i]);

    f=fopen(filename[i],"r");

    f_section=(struct scn *)ldmalloc((f_hdr[i].f_nscns+1)*sizeof(struct scn));
    read_sections(i,f);

    for(sc_num=1;sc_num<=f_hdr[i].f_nscns;++sc_num)
    {
      if(debug_level>1)
        printf("Processing Section %d (old) %d (new)\n",
               sc_num,scn_mapping[i][sc_num].sc_num);
      reloc_scn(i,sc_num);
    }
    for(sc_num=1;sc_num<=f_hdr[i].f_nscns;++sc_num)
      merge_section(i,sc_num); /* Neue Section in output-File dranhngen */
    free(f_section);
    fclose(f);
  }
  free(f_hdr);                       /* Headerlnge ist immer gleich */
}

void process_archives()
{
/*!!!*/
  if(!archives)
    return;
  if(debug_level)
    printf("Skipping archives!\n");
}

void post_process()
{
/* For future purposes */

/*!!! Other stuff */
}

long renumber_symbols()
{
  long symbol_number=0;
  int i;

  for(i=0;i<HASH_SIZE;++i)
  {
    struct hash_tbl *j;

    for(j=hash_table[i];j;j=j->next)
      j->syment->value=symbol_number++;
  }
  return symbol_number;
}

void write_sym(FILE *f, long *str_ptr, struct syment *syment)
{
/* Das muss auch streng deterministisch sein! */
  int len;

  len=strlen(syment->name)+1;
  if(len>SYMMLEN)
  {
    syment->n_zeroes=0;
    syment->n_offset=*str_ptr;
    *str_ptr+=len;
  }
  else
  {
    char *c,*d;

    c=syment->n_name;
    d=syment->name;
    if(c!=d)
      while((*c++=*d++));

  }
  fwrite(syment,SYMENT_SIZE,1,f);
}

void write_str(FILE *f, struct syment *syment)
{
  int len;

  len=strlen(syment->name)+1;
  if(len<=SYMMLEN)
    return;

  fwrite(syment->name,len,1,f);
}

long get_text_size()
{
  int i;

  for(i=1;i<=outfile->f_hdr->f_nscns;++i)
    if(outfile->f_sections[i].f_scnhdr->s_flags&STYP_TEXT)
      return outfile->f_sections[i].f_scnhdr->s_size;
  return 0;
}

long get_data_size()
{
  int i;

  for(i=1;i<=outfile->f_hdr->f_nscns;++i)
    if(outfile->f_sections[i].f_scnhdr->s_flags&STYP_DATA)
      return outfile->f_sections[i].f_scnhdr->s_size;
  return 0;
}

long get_bss_size()
{
  int i;

  for(i=1;i<=outfile->f_hdr->f_nscns;++i)
    if(outfile->f_sections[i].f_scnhdr->s_flags&STYP_BSS)
      return outfile->f_sections[i].f_scnhdr->s_size;
  return 0;
}

void write_out_file()
{
  FILE *f;
  long str_ptr,f_offset,i,scnstart,contents,reloc,lnno;

  if(debug_level>2)
    printf("Beginning writing Output-File\n");

  if((f=fopen(outputname,"w+"))==NULL)
    do_error(-1,outputname,E_FATAL,E_FILECREATE);
  f_offset=0;
  outfile->f_hdr->f_nsyms=renumber_symbols();
  outfile->f_hdr->f_magic=0x500;
  outfile->f_hdr->f_timdat=0;/*time();*/
  outfile->f_hdr->f_flags=F_AR32W;
  if(exclude_debug_info)
    outfile->f_hdr->f_flags|=F_RELFLG;
  if(!partial_link&&err==0)
    outfile->f_hdr->f_flags|=F_EXEC;
/*  outfile->f_hdr->f_flags|=F_LNNO;*/
  if(create_aout_hdr)
  {
    outfile->f_hdr->f_opthdr=AOUTHSZ;     /* Kann variabel sein */
    outfile->f_aouthdr=(struct aouthdr *)ldmalloc(sizeof(struct aouthdr));
    outfile->f_aouthdr->magic=(exclude_debug_info==TRUE&&err==0?0413:0);
    outfile->f_aouthdr->vstamp=0;
    outfile->f_aouthdr->tsize=get_text_size();   /*!!! Sizeof (.text-Section) */
    outfile->f_aouthdr->dsize=get_data_size();   /*!!! dito. */
    outfile->f_aouthdr->bsize=get_bss_size();   /*!!! dito. */
    outfile->f_aouthdr->text_start=0;
    outfile->f_aouthdr->data_start=0;  
  }
  else
  {
    outfile->f_hdr->f_opthdr=0;
    outfile->f_aouthdr=NULL;
  }
/*!!! Schreibe verkettete Liste auf Platte zurck*/
/* Schreiben*/
  scnstart=FILHSZ+outfile->f_hdr->f_opthdr+outfile->f_hdr->f_nscns*SCNHSZ;
  contents=reloc=lnno=0;
  for(i=1;i<=outfile->f_hdr->f_nscns;++i)
  {
    outfile->f_sections[i].f_scnhdr->s_scnptr=scnstart+contents;
    if(!(outfile->f_sections[i].f_scnhdr->s_flags&STYP_BSS))
      contents+=outfile->f_sections[i].f_scnhdr->s_size;
  }
  for(i=1;i<=outfile->f_hdr->f_nscns;++i)
  {
    outfile->f_sections[i].f_scnhdr->s_relptr=scnstart+contents+reloc;
    reloc+=outfile->f_sections[i].f_scnhdr->s_nreloc*RELOC_SIZE;
  }
  for(i=1;i<=outfile->f_hdr->f_nscns;++i)
  {
    outfile->f_sections[i].f_scnhdr->s_lnnoptr=scnstart+contents+reloc+lnno;
    lnno+=outfile->f_sections[i].f_scnhdr->s_nlnno*LNNO_SIZE;
  }
  outfile->f_hdr->f_symptr=scnstart+contents+reloc+lnno;
  fwrite(outfile->f_hdr,FILHSZ,1,f);
  f_offset+=FILHSZ;
  if(outfile->f_aouthdr)
  {
    fwrite(outfile->f_aouthdr,AOUTHSZ,1,f);
    /* evtl. noch anderes Zeug */
    f_offset+=outfile->f_hdr->f_opthdr;
  }
  for(i=1;i<=outfile->f_hdr->f_nscns;++i)       /* Sectionheader schreiben */
  {
    fwrite(outfile->f_sections[i].f_scnhdr,SCNHSZ,1,f);
    f_offset+=SCNHSZ;
  }
  for(i=1;i<=outfile->f_hdr->f_nscns;++i)      /* Sectioninhalte schreiben */
  {
    struct scndata *j;
    if(!(outfile->f_sections[i].f_scnhdr->s_flags&STYP_BSS))
      for(j=outfile->f_sections[i].f_scndata;j!=NULL;j=j->next)
      {
        fwrite(j->f_raw,1,j->s_size,f);
        f_offset+=j->s_size;
      }
  }
  for(i=1;i<=outfile->f_hdr->f_nscns;++i)      /* Relocation schreiben */
  {
    struct scndata *j;

    for(j=outfile->f_sections[i].f_scndata;j!=NULL;j=j->next)
    {
      int k;

      for(k=0;k<j->s_nreloc;++k)
      {
        if(!j->f_reloc[k].r_syment)
        {
          do_error(-1,"",E_WARNING,E_NODATA);
          j->f_reloc[k].r_symndx=r_symndx[j->fileno][j->f_reloc[k].r_symndx]->value;
        }
        else
          j->f_reloc[k].r_symndx=j->f_reloc[k].r_syment->value;
        fwrite(&j->f_reloc[k],RELOC_SIZE,1,f);
      }
      f_offset+=j->s_nreloc*RELOC_SIZE;
    }
  }
  for(i=1;i<=outfile->f_hdr->f_nscns;++i)      /* Lineno-Info schreiben */
  {
    struct scndata *j;

    for(j=outfile->f_sections[i].f_scndata;j;j=j->next)
    {
      int k;

      for(k=0;k<j->s_nlnno;++k)
      {
        if(!j->f_lnno[k].l_lnno)
          j->f_lnno[k].l_addr.l_symndx=
            r_symndx[j->fileno][j->f_lnno[k].l_addr.l_symndx]->value;
        fwrite(&j->f_lnno[k],LNNO_SIZE,1,f);
      }
      f_offset+=j->s_nlnno*LNNO_SIZE;
    }
  }

  str_ptr=4;
  {
    int j,symnum=0;
    /* Hier mssen die Symbole in der selben Reihenfolge geschrieben werden, wie
     * sie in renumber_symbols() durchnumeriert wurden */

    /* Zuerst externe Symbole */
    for(j=0;j<HASH_SIZE;++j)
    {
      struct hash_tbl *k;

      for(k=hash_table[j];k;k=k->next)
      {
        if(k->syment->value!=symnum++)
          do_error(-1,"",E_FATAL,E_INT_ERR);
        write_sym(f,&str_ptr,k->syment);
        f_offset+=SYMENT_SIZE;
      }
    }
    /* Dann interne Symbole */
    if(symnum!=outfile->f_hdr->f_nsyms)
      do_error(-1,"",E_FATAL,E_INT_ERR);
  }
/* Schreibe Stringtabelle */
  fwrite(&str_ptr,4,1,f);
  {
    int j;
    for(j=0;j<HASH_SIZE;++j)
    {
      struct hash_tbl *k;

      for(k=hash_table[j];k;k=k->next)
      {
        write_str(f,k->syment);
      }
    }
  }
  if(debug_level)
    printf("Done: %ld Bytes written.\n",f_offset);
  fclose(f);
}

int count_files()
{
  return n_infiles;
}

int main(int argc, char **argv)
{
  if(debug_level)
    printf("Plink - PRAM Linker (c) 1994\n");
  init();
  parse_cmd_line(argc,argv);
  max_files=count_files();
  init_obj_files();
  init_out_file();
  preprocess_objfiles();  /* Lies Sectionheader, scn-mapping, Symboltabelle ein */
/*!!! preprocess_archives();: Sucht in Archiven nach bentigten Object-Files */
  
/*!!! archive_read_symbol_string_tables();: Symbol- und Stringtabellen aus Archiven lesen! */
/*!!! preprocess archive files (bentigte Files in Archiven werden bestimmt) 
 * liegt gut hier, da bis jetzt noch wenig Speicher belegt ist (ranklotzen)*/
  do_reloc();
  process_archives();     /* Bentigte Files in Archiv werden normal gelinkt */
  if(!partial_link&&unresolved_externals)
  {
    int i;

    fprintf(stderr,
      "\007%ld unresolved externals. Perhaps you should link this File with -r\n",
      unresolved_externals);
    for(i=0;i<HASH_SIZE;++i)
    {
      struct hash_tbl *j;
      for(j=hash_table[i];j;j=j->next)
        if((j->syment->n_sclass&C_EXT)&&!(j->syment->n_scnum))
          fprintf(stderr,"%s\n",j->syment->name);
    }
  }
  else
    if(err!=E_ERROR)
      write_out_file();
  post_process();
  if(err==E_WARNING)
    return 0;
  else
    return err;
}
