/* -*-mb0-c-*- */
/* 
  FILE:        loader.c
  DESCRIPTION: loader for coff-files
  AUTHOR:      Stefan Franziskus
  DATE:        JAN 15, 1993
*/

#include "define.h"
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"coff.h"
#include <unistd.h>

char infilename[STRINGLEN],outfilename[STRINGLEN];      /* names of files */
FILE *infile, *outfile, *dumpfile, *configfile;                 /* corresp. file descr */
int quietflag;
int debugflags=0;

struct section *sct;           /* Sectionliste */
struct section *sct_beg;       /* Pointer auf Anfang der Sectionliste */
struct syment_blk *symtab;
struct syment_blk *symtab_beg;
struct filehdr file_head;
struct aouthdr aout_head;
int p_addr[10], v_addr[10];
int p_size[10];
int vpmask, textlen, stacklen, heaplen, shmemlen;

int start, org, orgstart, textstart, datastart;

char **sbp_argv;
int sbp_argc, sbp_arglen=3;

int filenr;
extern int dev_prog, dev_pram;
extern char *section_mem[];			

char loaderrc[80]="/home/pram/lib/ldrc.p4\0";

#ifndef HOST_IN

struct option_desc command_opt[]=
{
    {'h', "help", "", O_FUNCTION, &print_cmd_help},	
	{'s', "stack", "%i", O_VALUE, &stacklen},
	{'H', "heap", "%i", O_VALUE, &heaplen}, 
	{'S', "shmem", "%i", O_VALUE, &shmemlen}, 
	{'o', "outfile", "%s", O_VALUE, outfilename},
	{'D', "debugflags", "%i", O_VALUE, &debugflags},
	{'l', "loaderrc", "%s", O_VALUE, loaderrc},
	{'n', "numprocs", "%i", O_VALUE, &vpmask},
	{'v', "vpmask", "%i", O_VALUE, &vpmask},
	{'r', "textstart", "%i", O_VALUE, &textstart},
	{'R', "datastart", "%i", O_VALUE, &datastart},
	{'t', "textstart", "%i", O_VALUE, &textstart},
	{'d', "datastart", "%i", O_VALUE, &datastart},
	{0, "", "", O_VALUE, (int *)NULL}
};

#define o_format command_opt[i].format
typedef void (* cmd_function)(char *);

void eval_params(argc,argv)
int argc;
char *argv[];

{ 
	int par=1;                    /* number of actual parameter */
	int i=0;

	strcpy(infilename,STDINCODE);
	strcpy(outfilename,"default");

	while(par<argc && (argv[par][0]=='-'))
		switch(argv[par][1])
		{
		case '-':
			for(i=0;command_opt[i].short_opt;i++)
				if(!strcmp(&argv[par][2],command_opt[i].long_opt))
				{
					switch(command_opt[i].type)
					{
					case O_VALUE:
						sscanf(argv[++par], o_format, 
							   command_opt[i].val_addr);
						break;
					case O_FLAG:
						*command_opt[i].val_addr=1;
						break;
					case O_FUNCTION:
						(*(cmd_function)(command_opt[i].val_addr)) (o_format);
						break;
					}
					break;
				}
			par++;
			break;
		default:
			for(i=0;command_opt[i].short_opt;i++)
				if(argv[par][1]==command_opt[i].short_opt)
				{
					switch(command_opt[i].type)
					{
					case O_VALUE:
						if(argv[par][2])
							sscanf(&argv[par][2], o_format, 
								   command_opt[i].val_addr);
						else
							sscanf(argv[++par], o_format,
								   command_opt[i].val_addr);
						break;
					case O_FLAG:
						*command_opt[i].val_addr=1;
						break;
					case O_FUNCTION:
						(*(cmd_function)(command_opt[i].val_addr)) (o_format);
						break;
					}
					break;
				}
			par++;
			break;
		}
	strcat(outfilename,".cod");
	if(par<argc)
		strcpy(infilename, argv[par]);   /* !!! Noch Error ausgeben */
	
	sbp_argv=malloc((argc-par+2)*sizeof(int));
	sbp_argc=argc-par;
	i=0;
	while(par<argc)
	{
		sbp_arglen+=strlen(argv[par])+2;
		sbp_argv[i++]=argv[par++];
	}
}

int print_cmd_help()
{
	printf("Usage: loader [-H --heap heaplen] [-s --stack stacksize] [-S --shmem shmemlen] [-o --outfile outfilename] [-D --debugflags dbgflgs] [-l --loaderrc loaderrc] [-n -v --vpmask vpmask] [-r -t --textstart textstart] [-R -d --datastart datastart] [-h --help] inputfilename [args]\n");

exit(0);	
}

#endif


int get_textsize()
{
	int i=0;
/*	int ups;
	long block_ptr;
	long ld_sct_start[20]; */
	char sct_name[8];
	int textsize=0;
	
	fseek(infile, 0, 0);
	fread(&file_head.f_magic, sizeof(short), 2, infile);
	fread(&file_head.f_timdat, sizeof(long), 3, infile);
	fread(&file_head.f_opthdr, sizeof(short), 2, infile);
	
	fread(&aout_head.magic, sizeof(short), 2, infile);
	fread(&aout_head.tsize, sizeof(long), 6, infile);

	sct=sct_beg;
	
	fseek(infile, FILHSZ + file_head.f_opthdr, 0);
	*sct_name=(char)"";
	i=0;
	
	while(i<file_head.f_nscns && strcmp(sct_name,".text"))
	{
		fread(sct_name, sizeof(char), 8, infile);
		fseek(infile, SCNHSZ-8, 1);
		i++;
	}
	
	if(!strcmp(sct_name,".text"))
	{
		fseek(infile, 16-SCNHSZ, 1);
		fread(&textsize, sizeof(long), 1, infile);
	}
	
	return(textsize/4);
}

void scan_coff_file()
{
	int i=0;
	long block_ptr;
	char sct_name[8];

	fseek(infile,0,0);
	fread(&file_head.f_magic, sizeof(short), 2, infile);
	fread(&file_head.f_timdat, sizeof(long), 3, infile);
	fread(&file_head.f_opthdr, sizeof(short), 2, infile);
	
	fread(&aout_head.magic, sizeof(short), 2, infile);
	fread(&aout_head.tsize, sizeof(long), 6, infile);

	if(debugflags==1)
	  {
	    printf("f_magic  %x\n",file_head.f_magic);
	    printf("f_nscns  %x\n",file_head.f_nscns);
	    printf("f_timdat %lx\n",file_head.f_timdat);
	    printf("f_symptr %lx\n",file_head.f_symptr);
	    printf("f_nsyms  %lx\n",file_head.f_nsyms);
	    printf("f_opthdr %x\n",file_head.f_opthdr);
	    printf("f_flags  %x\n",file_head.f_flags);
	    printf("\n");
	
	    printf("magic   %x\n",aout_head.magic);
	    printf("vstamp  %x\n",aout_head.vstamp);
	    printf("tsize   %lx\n",aout_head.tsize);
	    printf("dsize   %lx\n",aout_head.dsize);
	    printf("bsize   %lx\n",aout_head.bsize);
	    printf("entry   %lx\n",aout_head.entry);
	    printf("text_st %lx\n",aout_head.text_start);
	    printf("data_st %lx\n",aout_head.data_start);
	    printf("\n");
	}

	
	sct=sct_beg;
	start=datastart;
	
	while(sct!=NULL)
	{
		fseek(infile, FILHSZ + file_head.f_opthdr, 0);
		*sct_name=(char)"";
		i=0;
		
		while(i<file_head.f_nscns && strcmp(sct_name,sct->head.s_name))
		{
			fread(sct_name, sizeof(char), 8, infile);
			fseek(infile, SCNHSZ-8, 1);
			i++;
		}
		
		if(!strcmp(sct_name,sct->head.s_name))
		{
			fseek(infile, 16-SCNHSZ, 1);
			fread(&sct->head.s_size, sizeof(long), 1, infile);
			fread(&sct->head.s_scnptr, sizeof(long), 1, infile);
			fread(&sct->head.s_relptr, sizeof(long), 1, infile);
			fread(&sct->head.s_lnnoptr, sizeof(long), 1, infile);
			fread(&sct->head.s_nreloc, sizeof(short), 2, infile);
			fread(&sct->head.s_flags, sizeof(long), 1, infile);

			if(sct->head.s_flags==STYP_TEXT)
			{
				sct->head.s_paddr=sct->head.s_vaddr=textstart;
				textlen=sct->head.s_size/sizeof(long);
			}
			
			else
				if(sct->head.s_paddr==0)
				{
					org=0;
					sct->head.s_paddr=sct->head.s_vaddr=start;
					start+=sct->head.s_size/4;
				}
				else
				{
					if(orgstart!=sct->head.s_vaddr)
					{
						orgstart=sct->head.s_vaddr;
						org=orgstart;
					}
					
					sct->head.s_paddr=start;
					sct->head.s_vaddr=org;
					start+=sct->head.s_size/4;
					org+=sct->head.s_size/4;
				}
			v_addr[i-1]=sct->head.s_vaddr;
		}
	
		printf("Headers ok!\n");
		
		fseek(infile,sct->head.s_relptr,0);
		
		sct->relocate=malloc(sizeof(struct reloc_data));
		sct->reloc_start=sct->relocate;
		for(block_ptr=0;block_ptr<sct->head.s_nreloc;block_ptr++)
		{
			fread(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_vaddr, sizeof(long), 3, infile);
			fread(&sct->relocate->reloc_item[block_ptr % COFF_BLK_SIZE].r_type, sizeof(short), 2, infile);
			
			if (block_ptr % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
			{
				sct->relocate->next=malloc(sizeof(struct reloc_data));
				sct->relocate=sct->relocate->next;
				sct->relocate->next=NULL;
			}

		}
		printf("Reloc. info ok.\n");
		
		if(!strcmp(sct_name,".args") && !strcmp(sct->head.s_name,".args"))
			sct->head.s_size=sbp_arglen*4;
		
		sct=sct->next;
	}

	fseek(infile, file_head.f_symptr, 0);
	symtab=malloc(sizeof(struct syment_blk));
	symtab_beg=symtab;	
	for(block_ptr=0;block_ptr<file_head.f_nsyms;block_ptr++)
	{
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE]._n._n_name, sizeof(char), 8, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_value, sizeof(long), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_scnum, sizeof(short), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_type, sizeof(short), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_sclass, sizeof(char), 1, infile);
		fread(&symtab->entry[block_ptr % COFF_BLK_SIZE].n_numaux, sizeof(char), 1, infile);
		symtab->entry[block_ptr % COFF_BLK_SIZE].n_value/=sizeof(long);

		if (block_ptr % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
		{
			symtab->next=malloc(sizeof(struct syment_blk));
			symtab=symtab->next;
			symtab->next=NULL;
		}
	}
}

void get_reloc(long rel_ptr, struct reloc **l_rel)
{
  if ((rel_ptr-1) % COFF_BLK_SIZE +1 >= COFF_BLK_SIZE)
    sct->relocate=sct->relocate->next;
  
  **l_rel=sct->relocate->reloc_item[rel_ptr % COFF_BLK_SIZE];

  if(debugflags==1)
    {
      printf("Adresse     : %lx\n",(*l_rel)->r_vaddr);
      printf("Offset      : %lx\n",(*l_rel)->r_offset);
      printf("Symtabeintr : %lx\n",(*l_rel)->r_symndx);
      printf("Typ         : %x\n",(*l_rel)->r_type);
      printf("Stuff       : %x\n\n",(*l_rel)->r_stuff);
    }	
}

void get_symtab(long s_index, struct syment **l_sym)
{
	symtab=symtab_beg;
	while (s_index  >= COFF_BLK_SIZE)
	{
		symtab=symtab->next;
		s_index=s_index-COFF_BLK_SIZE;
	}

	**l_sym=symtab->entry[s_index % COFF_BLK_SIZE];
}

void do_relocation()
{
	long relptr=0;
	long sct_ptr;
	struct reloc *load_rel;
	struct syment *load_sym;

	unsigned long rel_mask=0xffffffff;
	long sign_mask=0x0;
	long rel_value;
	long sct_long;
	int host_blk[BUFSIZE];
	int i=0, j;
	char *src;
	struct section *sct_p;
	
	load_rel=malloc(sizeof(struct reloc));
	load_sym=malloc(sizeof(struct syment));
	fseek(infile, FILHSZ + file_head.f_opthdr + SCNHSZ*file_head.f_nscns, 0);

	sct=sct_beg;	
	symtab=symtab_beg;
	
	while(sct!=NULL)
	{

		sct_ptr=0;
		relptr=0;
		sct->relocate=sct->reloc_start;
		switch(sct->head.s_flags)
		{
		case STYP_TEXT:   
#ifdef HOST_IN
			lseek(dev_prog, 4*sct->head.s_paddr, SEEK_SET);
			filenr=dev_prog;
#else
			fprintf(dumpfile,".CODE\n");
			fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);

#endif

			break;
		case STYP_DATA:
#ifndef HOST_IN 
			if(!strcmp(sct->head.s_name,".lldata") ||\
			   !strcmp(sct->head.s_name,".lpdata") ||\
			   !strcmp(sct->head.s_name,".LDATA"))
			{
				fprintf(dumpfile,"%s\n",".LDATA");
				fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
			}
			else
			{
				fprintf(dumpfile,"%s\n",".GDATA");
				fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
			}
#else
			lseek(dev_pram, 4*sct->head.s_paddr, SEEK_SET);
			filenr=dev_pram;
#endif
			
			break;
		case STYP_BSS:
			if(!strcmp(sct->head.s_name,".lddata"))
			{
#ifdef HOST_IN 
				lseek(dev_pram, 4*sct->head.s_paddr, SEEK_SET);			
				host_blk[0]=vpmask;
				host_blk[1]=textlen;
				host_blk[2]=stacklen;
				host_blk[3]=heaplen;
				host_blk[4]=shmemlen;
				for(i=5,sct_p=sct;sct_p!=NULL;i++,sct_p=sct_p->next)
					host_blk[i]=sct_p->head.s_size/sizeof(long);
				
				write(dev_pram, host_blk, i*sizeof(long));

#else
				fprintf(dumpfile,"%s\n",".GDATA");
				fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
				fprintf(dumpfile,"0x%x\n0x%x\n0x%x\n0x%x\n0x%x\n",
						vpmask,textlen,stacklen,heaplen,shmemlen);
				sct_p=sct;
				while(sct_p!=NULL)
				{
					fprintf(dumpfile,"0x%lx\n",sct_p->head.s_size/sizeof(long));
					sct_p=sct_p->next;
				}
#endif
			}

/*		case STYP_BSS:
			if(sct->head.s_name==".llbss" || sct->head.s_name==".lpbss")
				fprintf(dumpfile,"%s\n",".LDATA");
			if(sct->head.s_name==".glbss" || sct->head.s_name==".ggbss")
				fprintf(dumpfile,"%s\n",".GDATA");
			break;
*/
		default:
			break;
		}

		if(sct->head.s_flags!=STYP_BSS && strcmp(sct->head.s_name, ".args"))
		{
			fseek(infile, sct->head.s_scnptr, 0);
			if(sct->head.s_nreloc>0)
			{		
				get_reloc(relptr, &load_rel);
				get_symtab(load_rel->r_symndx, &load_sym);
				relptr++;
			}
			i=0;
			while(sct_ptr<(sct->head.s_size/sizeof(long)))
			{
				fread(&sct_long, sizeof(long), 1, infile);
				if(sct_ptr==load_rel->r_vaddr && relptr <= sct->head.s_nreloc \
				   && sct->head.s_nreloc>0 )
				{
				/*	rel_value=load_sym->n_value+load_rel->r_offset;  */
					rel_value=load_rel->r_offset;
					switch(load_rel->r_type)
					{
					case R_13ABS:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_mask=REL_MASK13;
						sign_mask=SIGN_13;
						break;
					case R_13REL:
						rel_value-=sct_ptr;
						rel_mask=REL_MASK13<<1;
						sign_mask=0x0;
						break;
					case R_19ABS:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_mask=REL_MASK19;
						sign_mask=SIGN_19;
						break;
					case R_19REL:
						rel_value-=sct_ptr;
						rel_mask=REL_MASK19<<1;
						sign_mask=0x0;
						break;
					case R_GETHI:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_value>>=13;
						rel_mask=REL_MASK19;
						sign_mask=SIGN_19;
						break;
					case R_32DAT:
						rel_value+=v_addr[load_sym->n_scnum-1];
						rel_mask=REL_MASK32;
						sign_mask=0x0;
						break;
					default:
						break;
					}

					sct_long=((sct_long & rel_mask & ~sign_mask) | 
							  (rel_value & ~rel_mask));
					/*
 				  		   | (((rel_value&rel_mask) == rel_mask)?sign:0)));*/
					
					get_reloc(relptr, &load_rel);
					get_symtab(load_rel->r_symndx, &load_sym);
					relptr++;
				}
#ifdef HOST_IN 
				if(i<BUFSIZE)
					host_blk[i++]=sct_long;
				else
				{
					
					write(filenr, host_blk , BUFSIZE*sizeof(long)); 
					i=0;
					host_blk[i++]=sct_long;
				}
				
#else
				fprintf(dumpfile,"0x%lx\n",sct_long);
#endif
				sct_ptr++;
			}
		}
#ifdef HOST_IN
		write(filenr, host_blk , i*sizeof(long));
		i=0;
#endif
		if(!strcmp(sct->head.s_name, ".args") && (sct->head.s_size !=0))
		{
#ifdef HOST_IN
			lseek(dev_pram, 4*sct->head.s_paddr, SEEK_SET);
#else
			fprintf(dumpfile,"%s\n",".GDATA");
			fprintf(dumpfile,".ORIGIN 0x%lx\n",sct->head.s_paddr);
#endif
			host_blk[0]=sbp_argc;
			host_blk[1]=sct->head.s_vaddr+3;
			host_blk[2]=sct->head.s_vaddr+sbp_arglen;
			host_blk[3]=host_blk[1]+sbp_argc;
			for(i=0;i<sbp_argc-1;i++)
				host_blk[i+4]=host_blk[i+3]+strlen(sbp_argv[i])+1;
			src=sbp_argv[0];
			i+=4;
			sbp_arglen-=i;
			while(src-sbp_argv[0]<sbp_arglen)
			{
				if(i<BUFSIZE)
					host_blk[i++]=*src++;
				else
				{
#ifdef HOST_IN
					write(filenr, host_blk , BUFSIZE*sizeof(long)); 
#else
					for(i=0;i<BUFSIZE;i++)
						fprintf(dumpfile,"0x%x\n",host_blk[i]);
#endif
					i=0;
					host_blk[i++]=*src++;
				}
			}
			
#ifdef HOST_IN
			write(filenr, host_blk , i*sizeof(long));
#else				
			for(j=0;j<i;j++)
				fprintf(dumpfile,"0x%x\n",host_blk[j]);
#endif
			i=0;
		}
		sct=sct->next;
	}
}


#ifndef HOST_IN

int main(argc,argv)
int argc;
char *argv[];
 
{
	eval_params(argc,argv);

	init(1);
	
	init(2);

	scan_coff_file();
	do_relocation();


	return(0);
}

#endif





