/* -*-mb0-c-*- */
#define STDINCODE "--"
#define STRINGLEN 80
#define BUFSIZE 128


#define STDINCODE "--"
#define STRINGLEN 80
#define SUNFS_CLIENTS 1

#define N_PPROZ 128
#define SIM_MEM_SIZE 5000000

#define MTRP_HOST_INT 0x4
#define MTRP_HOST_REQ 73

#define MTRP_BITFIELD_START 0x80080*4
#define MTRP_BITFIELD_LEN 0x200
#define MTRP_BITFIELD_LONGS 0x80
#define MTRP_REQ_START 0x80100*4
#define MTRP_HOST_REQ_START 0x50*4

#define MTRP_LOAD_REQ 1
#define MTRP_START_PROG_REQ 2
#define MTRP_LOAD_ANSWER 2

#define MTRP_READY 1
#define MTRP_IO_IN 101
#define MTRP_IO_OUT 102
#define MTRP_IO_ERR 103

#define MTRP_SUN_OPEN 1001
#define MTRP_SUN_READ 1002
#define MTRP_SUN_WRITE 1003
#define MTRP_SUN_CLOSE 1004
#define MTRP_SUN_SEEK 1005

#define N_OF_CLIENTS 128

#define err(x) if(errno!=0) error(x);

#define MTRP_ISSET(n, p)  (p[(n)/MTRP_BITFIELD_LONGS] & (1 << ((n) % MTRP_BITFIELD_LONGS)))
#define MTRP_CONFIRM_REQ(a,b) lseek(dev_pram, MTRP_REQ_START+(a+1)*sizeof(PRAM_REQUEST)-8, SEEK_SET); write(dev_pram, b, 4);
#define MTRP_CONFIRM_JOB(a,b) lseek(dev_pram, MTRP_REQ_START+(a+1)*sizeof(PRAM_REQUEST)-4, SEEK_SET); write(dev_pram, b, 4);

#define dprintf(d) if(d<=debugflag) printf

#define MAX_FILE_NAME_LENGTH 80

enum show_category
{
	S_MSG,
	S_TCP,
	S_UDP,
	S_FS,
	S_IO,
	S_COM,
	S_MTRP
};

enum c_types {C_LOCAL, C_EXTERN};

enum tcp_blk_types{P_ACK, P_COM, P_IO_IN, P_IO_LOUT, P_IO_OUT, P_IO_ERR, P_INT, P_LOGIN, P_EXIT, P_OK, P_RUN, P_FREEZE};


struct option_desc
{
	char short_opt;
	char *long_opt;
	char *format;
	int type;
	int *val_addr;
};

enum option_types{O_VALUE, O_FLAG, O_FUNCTION};
	
/*
typedef struct mtrp_host_request
{
	int uid;
	int portid;
	int mem_size;
	int text_size;
	int data_size;
	int n_proz;
} MTRP_HOST_REQ;
*/

typedef struct pram_request
{
    int id[1];
    int flags;
	union
	{
		int _par[4];
		struct
		{
			int dummy;
			int _mem_start;
			int _text_start;
			int _progs;
		}_p_l;                      /* Load Answer */
		struct
		{
			int _mem_size;
			int _text_size;
			int _n_proz;
		}_p_h;                      /* Load Request */
		
	}_p;
	int confirm_req;
    int confirm_job;
} PRAM_REQUEST;

#define mtrp_par _p._par
#define mtrp_mem_start _p._p_l._mem_start
#define mtrp_text_start _p._p_l._text_start 
#define mtrp_progs _p._p_l._progs

#define mtrp_mem_size _p._p_h._mem_size
#define mtrp_text_size _p._p_h._text_size
/*#define mtrp_data_size _p._p_h._data_size*/
#define mtrp_n_proz _p._p_h._n_proz

typedef struct pram_global_filetab_ent
{
	int id;
	int flags[4];
	int flag;
	int offset;
	int filename[MAX_FILE_NAME_LENGTH];
} GLOB_FTAB_ENT;

typedef struct file_cache
{
	int fd;
	char fname[80];
	struct file_cache *next;
	struct file_cache *prev;
}FILE_CACHE_ENT;
#define FILE_CACHE_SIZE 16

typedef struct
{
	int length;
	int proz_id;
	int flags;
	int fseek;
	int ptr_buf;
	int nlongs;
	int uid;
	char fname[80];
}FSTAB_ENT;

#define UDP_BLK_SIZE 256

typedef struct
{
	int type;
	int blk_id;
	int length;
	int user_id;
	int port_id;
	int flags[5];
	int text[UDP_BLK_SIZE];
} USER_BLOCK;

int init(int x);
void scan_coff_file(void);

void go_server_mode();
void wait_for_pram_to_become_ready();
int load_prog(void);
int host_shell(void);
int init_pram(void);
int ioctl_pram(void);
int start_pram(void);

int do_load_file(int argc, char *argv[], int psin[2]);
int do_test_io(void);
int do_help(void);
int do_reset_pram(void);
int do_freeze(void);
int do_pstat(void);
int do_startup(void);
int do_down(void);
int do_check(void);
int do_start(void);
int do_exit(void);
int do_test_dev(void);
int bla(void);
int do_memdump(int argc, char *argv[], int psin[2]);
int usr_udp_read(void);
int usr_udp_write(int psin[2], int *text, int length, int type);
void do_relocation(void);
int print_cmd_help(void);
